// $Id: volume.h,v 1.8.2.1 2002/01/17 21:16:21 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_volume
#define RADIO_volume

#include <gtk--/box.h>
#include <gtk--/adjustment.h>
#include <gtk--/togglebutton.h>

class Volume: public Gtk::VBox
{
    Gtk::Adjustment vol_adj;
    Gtk::ToggleButton btn;

public:
    Volume();

    SigC::Signal1<void, bool> mute_changed;
    SigC::Signal1<void, int> volume_changed;
    
    void set_volume (int val);
    void set_mute   (bool state);

private:
    void vol_adj_changed ();
    void mute_toggle ();
};

#endif
