// $Id: volume.cc,v 1.11.2.1 2002/01/17 21:16:21 cactus Exp $

// RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "volume.h"

#include "radioactive.h"
#include <gtk--/scale.h>

Volume::Volume():
    vol_adj(RADIO_VOL_MIN, RADIO_VOL_MIN, RADIO_VOL_MAX, 1, 3),
    btn(_("Mute"))
{
    Gtk::VScale* vol_scale = new Gtk::VScale (vol_adj);
    vol_scale->set_draw_value (false);
    vol_scale->set_digits (0);
    vol_scale->set_value_pos (GTK_POS_BOTTOM);

    pack_start (*manage (vol_scale));
    pack_start (btn, true, true, 2);

    btn.clicked.connect (slot (this, &Volume::mute_toggle));
    vol_adj.value_changed.connect (slot (this, &Volume::vol_adj_changed));
}

void Volume::set_mute (bool state)
{
    btn.set_active(state);
}

void Volume::mute_toggle()
{
    mute_changed (btn.get_active());
}

void Volume::vol_adj_changed ()
{
    if (btn.get_active()) {
	btn.clicked();
    }

    volume_changed (RADIO_VOL_MAX - (int)vol_adj.get_value());
}

void Volume::set_volume (int val)
{
    vol_adj.set_value (RADIO_VOL_MAX - val);
}
