// $Id: speedtuner.h,v 1.9.2.1 2002/01/17 21:16:21 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_speedtuner
#define RADIO_speedtuner

#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/tooltips.h>

#include <string>
#include <vector>

class SpeedTuner: public Gtk::Table
{
    std::vector<Gtk::Button*> btnProg;
    Gtk::Tooltips tips;
public:
    SpeedTuner(int row, int col);

    // A button was clicked
    SigC::Signal1<void, int> clicked;
    // The user wants to set a button's value
    SigC::Signal1<void, int> rclicked;
    
    // Setting the tooltips
    void set (const std::vector<std::string> &values);
    void set (int index, const std::string &value);
private:
    void btnProg_clicked(int btn);
    int btnProg_mouse(GdkEventButton *e, int btn);
};

#endif
