// RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

// $Id: speedtuner.cc,v 1.16.2.1 2002/01/17 21:16:21 cactus Exp $

#include "speedtuner.h"

SpeedTuner::SpeedTuner(int row, int col):
    Gtk::Table(row, col),
    btnProg(row * col)
{
    char* label;

    using namespace SigC;
    
    for (int i = 0; i < (row * col); i++)
    {
	label = g_strdup_printf("%d", (i + 1));
	Gtk::Button *b = new Gtk::Button (label);
	g_free (label);
	b->clicked.connect (bind (clicked.slot (), i));
	b->button_press_event.connect( bind( slot(this, &SpeedTuner::btnProg_mouse), i));
	b->set_usize(30, 30);
	
	gint left_attach = div(i, col).rem;
	gint top_attach = div(i, col).quot;
	attach (*manage (b),
		left_attach, left_attach + 1,
		top_attach, top_attach + 1,
		(GTK_FILL | GTK_EXPAND), (GTK_FILL | GTK_EXPAND),
		2, 2);
	btnProg[i] = b;
    }
}

int SpeedTuner::btnProg_mouse (GdkEventButton *e, int btn)
{
    if (e->button == 3)
	rclicked(btn);
    return false;
}

void SpeedTuner::set (const std::vector<std::string> &values)
{
    int j;
    std::vector<std::string>::const_iterator i;
    for (i = values.begin(), j = 0;
	 i != values.end(); i++, j++)
	tips.set_tip(*btnProg[j], *i);
}

void SpeedTuner::set(int index, const std::string &value)
{
    tips.set_tip(*btnProg[index], value);
}

