// RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

//$Id: radioactive_applet.cc,v 1.22.2.1 2002/01/17 21:16:21 cactus Exp $ -*- c++ -*-
#include "radioactive.h"

#include "common/file.h"
#include "common/driver.h"

#include <getopt.h>
#include <iostream>

#include "common/wndMain.h"
#include "applet/applet.h"

#include <panel--/applet-main.h>
#include <stdexcept>

using namespace SigC;
using namespace Gnome;

int main(int argc, char** argv)
{
    bindtextdomain(PACKAGE, GNOMELOCALEDIR);
    textdomain(PACKAGE);
    
    Applet_Main m("radioactive_applet", VERSION, argc, argv);
    
    // Read configuration
    read_config();

    Radio* radio;

    try {
	radio = new Radio(arg::devfile);
    }
    catch (std::runtime_error e)
    {
	std::cerr << e.what () << std::endl;
	exit(1);
    }

    radio->set_freq   (arg::freq);
    radio->set_volume (arg::volume);
    radio->set_mute   (arg::mute);

    // User interface
    SpeedButtonData vec;

    wndMain *w = new wndMain(*radio);
    RApplet applet(*radio, *w);
    
    if (arg::save_pos)
	w->set_uposition(arg::pos_x, arg::pos_y);
    w->set_speedtuner(
	vec = load_button_values(arg::progbutton_col *
				 arg::progbutton_row));
	
    applet.set_vals(vec);
    applet.set_num(arg::last_button);
    
    applet.show();
    m.run();
    
    // Save configuration
    vec = w->get_speedtuner ();
    arg::freq = radio->get_freq ();
    arg::volume = radio->get_volume ();
    arg::last_button = applet.get_num ();
    arg::mute = radio->get_mute ();
    if (arg::save_pos)
	w->get_position(arg::pos_x, arg::pos_y);
    save_config();
    save_button_values(vec);

    if (arg::mute_exit)
	radio->set_mute (true);

    if (radio) delete radio;
    return 0;
}
