/* $Id: sample-app.c,v 1.4 2002/02/02 23:58:36 cactus Exp $
 *
 * You are free to use, modify, and redistribute this file any way you
 * wish, including incorporation into closed source products.
 *
 * Copyright (C) 2003  RDI Gerg <cactus@cactus.rulez.org>
 */

#include <System/SystemPublic.h>
#include <UI/UIPublic.h>

#include "form_FORM1.h"
#include "menu_MENU1.h"

#include "tutorial.guikachu.h"

Boolean widget_BUTTON1_ctlEnter_cb ()
{
    /* Pop up the About dialog */
    FrmAlert (DIALOG1);
    return true;
}

Boolean MENU1_MENU_NOTHING_activate_cb ()
{
    /* We'll do nothing here, and thus return false */
    return false;
}

Boolean MENU1_MENU_ABOUT_activate_cb ()
{
    FrmAlert (DIALOG1);
    return true;
}

static int StartApplication(void)
{
    FrmPopupForm (FORM1);
    
    return 0;
}

static void StopApplication ()
{
    FrmCloseAllForms ();
}

static void EventLoop ()
{
    short     err;
    int       formID;
    FormPtr   form;
    EventType event;
    
    do
    {
        
        EvtGetEvent(&event, 200);
        
        if (SysHandleEvent(&event)) continue;
        if (MenuHandleEvent((void *)0, &event, &err)) continue;
        
        if (event.eType == frmLoadEvent) {
            formID = event.data.frmLoad.formID;
            form = FrmInitForm(formID);
            FrmSetActiveForm(form);

            switch (formID) {
            case FORM1:
                FrmSetEventHandler (form, form_FORM1_handler);
                break;
            }
        }
	FrmDispatchEvent(&event);
    } while(event.eType != appStopEvent);
}


UInt32 PilotMain (UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
    if (cmd == sysAppLaunchCmdNormalLaunch) {
	StartApplication();
	EventLoop ();
	StopApplication ();
    }

    return 0;
}
