//$Id: xml-saver.h,v 1.12 2006/05/06 16:53:09 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_IO_XML_SAVER_H
#define GUIKACHU_IO_XML_SAVER_H

#include "io/guikachu-io.h"
#include "storage-node.h"
#include "resource-visitor.h"
#include "form-editor/widget-visitor.h"

namespace Guikachu
{
    namespace IO
    {
	class XMLSaver: public Saver
	{
	public:
	    void save (ResourceManager *manager, const Glib::ustring &uri) throw (Glib::Exception);
	};

	namespace XML
	{
	    class ResourceSaver: public ResourceVisitor
	    {
		StorageNode   &node;
                Glib::ustring  src_hint;
		
	    public:
		explicit ResourceSaver (StorageNode &node, const Glib::ustring &src_hint = Glib::ustring ());
	    
		void visit_resource (Resources::Dialog       *res);
		void visit_resource (Resources::String       *res);
		void visit_resource (Resources::StringList   *res);
		void visit_resource (Resources::Menu         *res);
		void visit_resource (Resources::Form         *res);
		void visit_resource (Resources::Blob         *res);
                void visit_resource (Resources::Bitmap       *res);
                void visit_resource (Resources::BitmapFamily *res);
	    };
	    
	    class WidgetSaver: public WidgetVisitor
	    {
		StorageNode   &node;
                Glib::ustring  src_hint;
		
	    public:
		explicit WidgetSaver (StorageNode &node, const Glib::ustring &src_hint = Glib::ustring ());
		
		void visit_widget (Widgets::Label           *widget);
		void visit_widget (Widgets::Button          *widget);
		void visit_widget (Widgets::PushButton      *widget);
		void visit_widget (Widgets::Graffiti        *widget);
		void visit_widget (Widgets::SelectorTrigger *widget);
		void visit_widget (Widgets::Checkbox        *widget);
		void visit_widget (Widgets::List            *widget);
		void visit_widget (Widgets::PopupTrigger    *widget);
		void visit_widget (Widgets::ScrollBar       *widget);
		void visit_widget (Widgets::Slider          *widget);
		void visit_widget (Widgets::TextField       *widget);
		void visit_widget (Widgets::Table           *widget);
                void visit_widget (Widgets::FormBitmap      *widget);
		void visit_widget (Widgets::Gadget          *widget);
	    };
	}
    }
}

#endif /* !GUIKACHU_IO_XML_SAVER_H */
