//$Id: main.cc,v 1.28 2005/11/22 23:14:24 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <glib/gi18n.h>

#include <libglademm/xml.h>
#include <fcntl.h>

#include "session.h"
#include "ui.h"

namespace {
    enum FileType
    {
	FILETYPE_REGULAR,
	FILETYPE_GLADE,
	FILETYPE_FONT,
	FILETYPE_TARGET_DEF
    };
    
    struct FileEntry
    {
	const char *filename;
	FileType type;
    };
}
    
static bool check_file (FileEntry& file)
{
    bool        success  = true;
    std::string filename = file.filename;

    /* For _REGULAR and _FONT */
    int fd = -1;

    /* For _GLADE */
    Glib::RefPtr<Gnome::Glade::Xml> gui;
    
    switch (file.type)
    {
    case FILETYPE_REGULAR:
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
	
    case FILETYPE_GLADE:
	filename = Glib::ustring (GUIKACHU_GLADEDIR) + "/" + filename;
	gui =  Gnome::Glade::Xml::create (filename);
	if (!gui)
	    success = false;
	break;
	
    case FILETYPE_FONT:
	filename = Glib::ustring (GUIKACHU_FONTDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;

    case FILETYPE_TARGET_DEF:
	filename = Glib::ustring (GUIKACHU_TARGETDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
    }

    return success;
}

static bool check_files ()
{
    bool success = true;
    
    FileEntry files[] = {
	{ "guikachu.glade",       FILETYPE_GLADE },
	{ "stdfont.txt",          FILETYPE_FONT },
	{ "boldfont.txt",         FILETYPE_FONT },
	{ "bigfont.txt",          FILETYPE_FONT },
        { "symbol.txt",           FILETYPE_FONT },
        { "symbol11.txt",         FILETYPE_FONT },
        { "symbol7.txt",          FILETYPE_FONT },
        { "ledfont.txt",          FILETYPE_FONT },
        { "bigbold.txt",          FILETYPE_FONT },
	{ "palm.guikachu-target", FILETYPE_TARGET_DEF }
    };

    for (unsigned int i = 0;
	 i < (sizeof (files) / sizeof (FileEntry));
	 i++)
    {
	if (!check_file (files[i]))
	{
	    Glib::ScopedPtr<char> buffer (g_strdup_printf (
		_("Opening file `%s' (required by Guikachu) failed.\n"
		  "Check your Guikachu installation"),
		g_basename (files[i].filename)));
	    Guikachu::UI::show_error (buffer.get ());
	    
	    success = false;
	}
    }

    return success;
}

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, GNOME_LOCALEDIR);
    bind_textdomain_codeset (PACKAGE, "UTF-8");
    textdomain (PACKAGE);
#endif
    
    Guikachu::Main app (argc, argv);
    
    using namespace Guikachu;
    
    if (!check_files ())
	return -1;

    app.run ();
}
