//$Id: ui-gui.cc,v 1.15 2005/11/05 08:20:22 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "ui-gui.h"
#include "session.h"
#include "io/io.h"

#include <gtkmm/alignment.h>
#include <gtkmm/label.h>
#include <gtkmm/image.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/main.h>
#include <gtkmm/aboutdialog.h>

#include <list>
#include <iostream>

using namespace Guikachu;

namespace {
#include "pixmaps/inline-pixbufs.h"
}

void UI::flush_events ()
{
    if (Guikachu::Main::initialized ())
	while (Gtk::Main::events_pending ())
	    Gtk::Main::iteration ();
}

namespace {
    void about_uri_cb (Gtk::AboutDialog &about, const Glib::ustring &uri)
    {
        gnome_url_show (uri.c_str (), 0);
    }
} // anonymous namespace

void UI::show_about (Gtk::Window *parent)
{
    std::list<Glib::ustring> authors;
    authors.push_back ("Gerg\xC5\x91 \xC3\x89rdi\thttp://cactus.rulez.org/");
    authors.push_back ("Jay Bloodworth");
    authors.push_back ("Christopher Keith Fairbairn");
    authors.push_back ("Tobias Gruetzmacher");
    authors.push_back ("Nathan Kurz");

    std::list<Glib::ustring> documenters;

    static Glib::RefPtr<Gdk::Pixbuf> logo = Gdk::Pixbuf::create_from_inline (-1, guikachu_logo_gdkbuf);
    
    // note to translators: please fill in your names and email addresses
    Glib::ustring translators = _("translator_credits");
    if (translators == "translator_credits")
	translators = "";

    static const char *license =
        "This program is free software; you can redistribute it and/or modify it\n"
        "under the terms of the GNU General Public License version 2 as published\n"
        "by the Free Software Foundation.\n"
        "\n"
        "This program is distributed in the hope that it will be useful but WITHOUT\n"
        "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY\n"
        "or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public \n"
        "License for more details.\n"
        "\n"
        "You should have received a copy of the GNU General Public License along\n"
        "with this program; if not, write to the Free Software Foundation, Inc.,\n"
        "59 Temple Place, Suite 330, Boston, MA 02111-1307 USA";
    
    Gtk::AboutDialog *about = new Gtk::AboutDialog;
    about->set_url_hook (sigc::ptr_fun (about_uri_cb));

    about->set_name ("Guikachu");
    about->set_version (VERSION);
    about->set_copyright ("Copyright \xC2\xA9 2001-2005 Gerg\xC5\x91 \xC3\x89rdi");
    about->set_comments (_("PalmOS resource file editor"));
    about->set_website ("http://cactus.rulez.org/projects/guikachu/");
    about->set_website_label (_("Visit the Guikachu website"));

    about->set_authors (authors);
    //about->set_documenters (documenters);
    if (translators != "")
        about->set_translator_credits (translators);

    about->set_logo (logo);
    about->set_license (license);

    if (parent)
        about->set_transient_for (*parent);
    about->run ();
    delete about;
}

void UI::show_error (const Glib::ustring &full_message,
		     const Glib::ustring &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gtk::MessageDialog dialog (full_message, true, Gtk::MESSAGE_ERROR,
                                   Gtk::BUTTONS_OK, true);
        dialog.run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Error: ") << short_message << std::endl;
    }
}

void UI::show_warning (const Glib::ustring &full_message,
		       const Glib::ustring &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gtk::MessageDialog dialog (full_message, true, Gtk::MESSAGE_WARNING,
                                   Gtk::BUTTONS_OK, true);
        dialog.run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Warning: ") << short_message << std::endl;
    }
}

Gtk::Button * UI::create_stock_button (const Gtk::StockID  &stock_id,
                                       const Glib::ustring &title)
{
    Gtk::Button *button = new Gtk::Button;
    
    Gtk::Alignment *alignment = new Gtk::Alignment (0.5, 0.5, 0, 0);
    Gtk::HBox *hbox = new Gtk::HBox (false, 2);
    hbox->pack_start (*manage (new Gtk::Image (stock_id, Gtk::ICON_SIZE_BUTTON)), Gtk::PACK_SHRINK);
    hbox->pack_start (*manage (new Gtk::Label (title, true)), Gtk::PACK_SHRINK);
    alignment->add (*manage (hbox));

    alignment->show_all ();
    button->add (*manage (alignment));
    return button;
}

bool UI::confirm_save (Gtk::FileChooserDialog &file_chooser)
{
    if (file_chooser.run () == Gtk::RESPONSE_ACCEPT)
    {
	Glib::ustring uri = file_chooser.get_uri ();
	if (IO::uri_exists (uri))
	{
	    Glib::ScopedPtr<char> message (
		g_strdup_printf (_("<b><big>\"%s\" already exists</big></b>\n"
				   "Would you like to overwrite it?"),
				 UI::visible_filename (uri).c_str ()));
	    Gtk::MessageDialog *confirm = new Gtk::MessageDialog (file_chooser,
								  message.get (), true,
								  Gtk::MESSAGE_QUESTION,
								  Gtk::BUTTONS_NONE,
								  true);
            Gtk::Button *overwrite_btn = UI::create_stock_button (Gtk::Stock::SAVE, _("Overwrite"));
            overwrite_btn->show ();

            confirm->add_button (Gtk::Stock::CANCEL, Gtk::RESPONSE_NO);
            confirm->add_action_widget (*manage (overwrite_btn), Gtk::RESPONSE_YES);
            confirm->set_default_response (Gtk::RESPONSE_NO);
            
            int response = confirm->run ();
	    delete confirm;

	    if (response == Gtk::RESPONSE_YES)
		return true;
	    else
		return confirm_save (file_chooser);
	    
	} else {
	    return true;
	}
    }
    
    return false;
}
