//$Id: size-entry.h,v 1.12 2005/07/29 09:54:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_SIZE_ENTRY_H
#define GUIKACHU_WIDGETS_SIZE_ENTRY_H

#include "num-entry.h"
#include "resource-manager.h"
#include "target.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace PropertyEditors
	{
	    class WidthEntry: public NumEntry
	    {
	    public:
		WidthEntry (ResourceManager *manager,
			    property_t      &property,
			    op_factory_t    *op_factory);
	    private:
		Target *target;
		
		void target_changed_cb ();
	    };
	    
	    class HeightEntry: public NumEntry
	    {
	    public:
		HeightEntry (ResourceManager *manager,
			     property_t      &property,
			     op_factory_t    *op_factory);
	    private:
		Target *target;
		
		void target_changed_cb ();
	    };
	}
    }
}

#endif /* !GUIKACHU_WIDGETS_SIZE_ENTRY_H */
