dnl **********************
dnl GUIKACHU_DEPS_GUIKACHU
dnl
dnl Check backend and GUI dependancy libraries for Guikachu
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_GUIKACHU],[
dnl Packages using pkg-config
PKG_CHECK_MODULES(GUIKACHU_GUI_DEPS, libgnomeuimm-2.6 libxml-2.0)
PKG_CHECK_MODULES(GUIKACHU_DEPS, glibmm-2.4 gdkmm-2.4 gnome-vfsmm-2.6 gconfmm-2.6 libxml-2.0)
LIBGNOME_DATADIR=`"$PKG_CONFIG" --variable=prefix libgnome-2.0`/share

dnl Export variables to Automake
AC_SUBST(GUIKACHU_DEPS_CFLAGS)
AC_SUBST(GUIKACHU_DEPS_LIBS)
AC_SUBST(GUIKACHU_GUI_DEPS_CFLAGS)
AC_SUBST(GUIKACHU_GUI_DEPS_LIBS)
AC_SUBST(LIBGNOME_DATADIR)
])


dnl **********************
dnl GUIKACHU_DEPS_FOOCANVAS
dnl
dnl Check dependancy libraries for FooCanvas
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_FOOCANVAS],[
PKG_CHECK_MODULES(FOOCANVAS_DEPS, gtk+-2.0 pango)
AC_SUBST(FOOCANVAS_DEPS_CFLAGS)
AC_SUBST(FOOCANVAS_DEPS_LIBS)

AC_PATH_PROG(GLIB_GENMARSHAL, glib-genmarshal)
])


dnl **********************
dnl GUIKACHU_DEPS_FOOCANVASMM
dnl
dnl Check dependancy libraries for FooCanvasmm
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_FOOCANVASMM],[
PKG_CHECK_MODULES(FOOCANVASMM_DEPS, gtkmm-2.4)
AC_SUBST(FOOCANVASMM_DEPS_CFLAGS)
AC_SUBST(FOOCANVASMM_DEPS_LIBS)

GTKMM_PREFIX=`$PKG_CONFIG --variable=prefix glibmm-2.4`
GTKMM_PROCDIR=$GTKMM_PREFIX/lib/glibmm-2.4/proc
AC_SUBST(GTKMM_PROCDIR)
GTKMM_PROC=$GTKMM_PROCDIR/gmmproc
AC_SUBST(GTKMM_PROC)
])
