//$Id: menu-win.h,v 1.19 2005/07/29 09:54:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_MENU_WIN_H
#define GUIKACHU_MENU_WIN_H

#include "menu-res.h"
#include "resource-win.h"

#include <gtkmm/window.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/label.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>

#include <libglademm/xml.h>

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class MenuWindow: public ResourceWindow,
			  public sigc::trackable
	{
	    Resources::Menu *res;

	    Glib::RefPtr<Gnome::Glade::Xml> gui;

	    Gtk::Window   *window;
	    Gtk::TreeView *treeview;
	    
	    Gtk::Entry  *id_entry;
	    Gtk::Button *btnUp, *btnDown, *btnRemove;
	    Gtk::Entry  *item_label, *item_id, *item_shortcut;
	    Gtk::Label  *lbl_item_label, *lbl_item_id, *lbl_item_shortcut;
	    Gtk::Button *btnSubmenu, *btnItem, *btnSeparator;

	    Gtk::TreeModelColumn<bool>          col_is_submenu;
	    Gtk::TreeModelColumn<unsigned int>  col_index;
	    Gtk::TreeModelColumn<unsigned int>  col_parent_index;
	    Glib::RefPtr<Gtk::ListStore>        treestore;

	    Resources::Menu::MenuTree submenus;
	    
	public:
	    MenuWindow (Guikachu::Resources::Menu *res);
	    ~MenuWindow ();

	    void show ();

	private:
            Gtk::Entry *current_entry;
            int         current_entry_pos;
	    int         update_block;

	    void update ();
            
	    void id_entry_cb ();
	    void item_label_entry_cb ();
	    void item_id_entry_cb ();
	    void item_shortcut_entry_cb ();

            void cell_label_cb    (Gtk::CellRenderer *cell, const Gtk::TreeModel::iterator &iter) const;
            void cell_id_cb       (Gtk::CellRenderer *cell, const Gtk::TreeModel::iterator &iter) const;
            void cell_shortcut_cb (Gtk::CellRenderer *cell, const Gtk::TreeModel::iterator &iter) const;

            void cell_label_edit_cb    (const Glib::ustring &path, const Glib::ustring &new_text);
            void cell_id_edit_cb       (const Glib::ustring &path, const Glib::ustring &new_text);
            void cell_shortcut_edit_cb (const Glib::ustring &path, const Glib::ustring &new_text);
            
	    void delete_event_impl (GdkEventAny *e);
            
	    void reset_controls ();

            void entry_insert_cb (const Glib::ustring &text, int *pos, Gtk::Entry *entry);
            void entry_delete_cb (int start_pos, int end_pos, Gtk::Entry *entry);
            
            void set_item_label    (const Gtk::TreeModel::iterator &iter, const std::string &new_label);
            void set_item_id       (const Gtk::TreeModel::iterator &iter, const std::string &new_id);
            void set_item_shortcut (const Gtk::TreeModel::iterator &iter, const std::string &new_shortcut);
            
	    void btn_up_cb ();
	    void btn_down_cb ();
	    void btn_remove_cb ();

	    void btn_submenu_cb ();
	    void btn_item_cb (bool separator);

	    void selection_changed_cb ();
	    
	    void submenu_up     (unsigned int index);
	    void submenu_down   (unsigned int index);
	    void submenu_remove (unsigned int index);
	    
	    void menuitem_up     (unsigned int parent_index, unsigned int index);
	    void menuitem_down   (unsigned int parent_index, unsigned int index);
	    void menuitem_remove (unsigned int parent_index, unsigned int index);
	};
    }
}

#endif /* !GUIKACHU_MENU_WIN_H */
