/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID_TOKEN = 258,
     AUTOID = 259,
     BEG = 260,
     END = 261,
     LBRACE = 262,
     RBRACE = 263,
     HELPID = 264,
     MENUID = 265,
     DEFAULTBTNID = 266,
     APPLICATIONICONNAME = 267,
     ALERT = 268,
     MENU = 269,
     STRING = 270,
     STRINGTABLE = 271,
     BITMAP = 272,
     BITMAPFAMILY = 273,
     DIALOG_CONFIRMATION = 274,
     DIALOG_INFORMATION = 275,
     DIALOG_WARNING = 276,
     DIALOG_ERROR = 277,
     BUTTON = 278,
     POPUPTRIGGER = 279,
     REPEATBUTTON = 280,
     CHECKBOX = 281,
     SELECTORTRIGGER = 282,
     LABEL = 283,
     PUSHBUTTON = 284,
     GRAFFITISTATEINDICATOR = 285,
     FIELD = 286,
     LIST = 287,
     FORMBITMAP = 288,
     GADGET = 289,
     POPUPLIST = 290,
     TABLE = 291,
     SCROLLBAR = 292,
     SLIDER = 293,
     AUTO = 294,
     USABLE = 295,
     NONUSABLE = 296,
     DISABLED = 297,
     LEFTANCHOR = 298,
     RIGHTANCHOR = 299,
     FRAME = 300,
     NOFRAME = 301,
     BOLDFRAME = 302,
     LEFTALIGN = 303,
     RIGHTALIGN = 304,
     NUMERIC = 305,
     AUTOSHIFT = 306,
     HASSCROLLBAR = 307,
     VERTICAL = 308,
     FEEDBACK = 309,
     VISIBLEITEMS = 310,
     SEARCH = 311,
     ROWS = 312,
     COLUMNS = 313,
     COLUMNWIDTHS = 314,
     VALUE = 315,
     MIN_VAL = 316,
     MAX_VAL = 317,
     PAGESIZE = 318,
     GRAPHICAL = 319,
     BITMAPID = 320,
     SELECTEDBITMAPID = 321,
     THUMBID = 322,
     BACKGROUNDID = 323,
     BITMAPGREY = 324,
     BITMAPGREY16 = 325,
     BITMAPCOLOR16 = 326,
     BITMAPCOLOR = 327,
     BITMAPCOLOR16K = 328,
     BITMAPFAMILYSPECIAL = 329,
     BITMAPFAMILYEX = 330,
     COMPRESS = 331,
     NOCOMPRESS = 332,
     FORCECOMPRESS = 333,
     COLORTABLE = 334,
     NOCOLORTABLE = 335,
     TRANSPARENT = 336,
     TRANSPARENTINDEX = 337,
     DENSITY = 338,
     BPP = 339,
     AT = 340,
     BUTTONS = 341,
     CHECKED = 342,
     DEFAULTBUTTON = 343,
     DYNAMICSIZE = 344,
     EDITABLE = 345,
     FONT = 346,
     FORM = 347,
     GROUP = 348,
     MAXCHARS = 349,
     MENUITEM = 350,
     MESSAGE = 351,
     MODAL = 352,
     MULTIPLELINES = 353,
     NONEDITABLE = 354,
     NOSAVEBEHIND = 355,
     PULLDOWN = 356,
     SAVEBEHIND = 357,
     SEPARATOR = 358,
     SINGLELINE = 359,
     TITLE = 360,
     UNDERLINED = 361,
     VERSION_TOKEN = 362,
     CENTER = 363,
     PREVLEFT = 364,
     PREVRIGHT = 365,
     PREVTOP = 366,
     PREVBOTTOM = 367,
     PREVWIDTH = 368,
     PREVHEIGHT = 369,
     QUOTESTRING = 370,
     WORD = 371,
     PLUS = 372,
     MINUS = 373,
     TIMES = 374,
     DIV = 375,
     NUMBER = 376
   };
#endif
#define ID_TOKEN 258
#define AUTOID 259
#define BEG 260
#define END 261
#define LBRACE 262
#define RBRACE 263
#define HELPID 264
#define MENUID 265
#define DEFAULTBTNID 266
#define APPLICATIONICONNAME 267
#define ALERT 268
#define MENU 269
#define STRING 270
#define STRINGTABLE 271
#define BITMAP 272
#define BITMAPFAMILY 273
#define DIALOG_CONFIRMATION 274
#define DIALOG_INFORMATION 275
#define DIALOG_WARNING 276
#define DIALOG_ERROR 277
#define BUTTON 278
#define POPUPTRIGGER 279
#define REPEATBUTTON 280
#define CHECKBOX 281
#define SELECTORTRIGGER 282
#define LABEL 283
#define PUSHBUTTON 284
#define GRAFFITISTATEINDICATOR 285
#define FIELD 286
#define LIST 287
#define FORMBITMAP 288
#define GADGET 289
#define POPUPLIST 290
#define TABLE 291
#define SCROLLBAR 292
#define SLIDER 293
#define AUTO 294
#define USABLE 295
#define NONUSABLE 296
#define DISABLED 297
#define LEFTANCHOR 298
#define RIGHTANCHOR 299
#define FRAME 300
#define NOFRAME 301
#define BOLDFRAME 302
#define LEFTALIGN 303
#define RIGHTALIGN 304
#define NUMERIC 305
#define AUTOSHIFT 306
#define HASSCROLLBAR 307
#define VERTICAL 308
#define FEEDBACK 309
#define VISIBLEITEMS 310
#define SEARCH 311
#define ROWS 312
#define COLUMNS 313
#define COLUMNWIDTHS 314
#define VALUE 315
#define MIN_VAL 316
#define MAX_VAL 317
#define PAGESIZE 318
#define GRAPHICAL 319
#define BITMAPID 320
#define SELECTEDBITMAPID 321
#define THUMBID 322
#define BACKGROUNDID 323
#define BITMAPGREY 324
#define BITMAPGREY16 325
#define BITMAPCOLOR16 326
#define BITMAPCOLOR 327
#define BITMAPCOLOR16K 328
#define BITMAPFAMILYSPECIAL 329
#define BITMAPFAMILYEX 330
#define COMPRESS 331
#define NOCOMPRESS 332
#define FORCECOMPRESS 333
#define COLORTABLE 334
#define NOCOLORTABLE 335
#define TRANSPARENT 336
#define TRANSPARENTINDEX 337
#define DENSITY 338
#define BPP 339
#define AT 340
#define BUTTONS 341
#define CHECKED 342
#define DEFAULTBUTTON 343
#define DYNAMICSIZE 344
#define EDITABLE 345
#define FONT 346
#define FORM 347
#define GROUP 348
#define MAXCHARS 349
#define MENUITEM 350
#define MESSAGE 351
#define MODAL 352
#define MULTIPLELINES 353
#define NONEDITABLE 354
#define NOSAVEBEHIND 355
#define PULLDOWN 356
#define SAVEBEHIND 357
#define SEPARATOR 358
#define SINGLELINE 359
#define TITLE 360
#define UNDERLINED 361
#define VERSION_TOKEN 362
#define CENTER 363
#define PREVLEFT 364
#define PREVRIGHT 365
#define PREVTOP 366
#define PREVBOTTOM 367
#define PREVWIDTH 368
#define PREVHEIGHT 369
#define QUOTESTRING 370
#define WORD 371
#define PLUS 372
#define MINUS 373
#define TIMES 374
#define DIV 375
#define NUMBER 376




/* Copy the first part of user declarations.  */
#line 19 "parser.yy"


#define YYERROR_VERBOSE

#include "parser-interface.h"
    
#include "config.h"
#include <libgnome/libgnome.h>
    
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "io/io.h"
    
#include "resource-manager.h"

#include "string-res.h"
#include "stringlist-res.h"
#include "dialog-res.h"
#include "form-res.h"
#include "menu-res.h"
#include "bitmap-res.h"
#include "bitmapfamily-res.h"

#include "form-editor/label.h"
#include "form-editor/checkbox.h"
#include "form-editor/button.h"    
#include "form-editor/pushbutton.h"
#include "form-editor/selector-trigger.h"
#include "form-editor/popup-trigger.h"
#include "form-editor/graffiti.h"
#include "form-editor/text-field.h"
#include "form-editor/list.h"
#include "form-editor/table.h"
#include "form-editor/scrollbar.h"
#include "form-editor/slider.h"
#include "form-editor/formbitmap.h"

#include <libgnomevfsmm/uri.h>
    
    extern int yylex();
    extern int lexer_lineno;
    extern char *yytext;

    extern struct yy_buffer_state* yy_scan_bytes (const char *bytes, int len);
    extern void yypop_buffer_state ();
    
    using namespace Guikachu;
    using namespace Guikachu::IO;

    namespace Guikachu
    {
	namespace IO
	{
	    namespace RCP
	    {
		std::string error;
		
		void setup (ResourceManager *manager, const std::string &uri);
		void finish ();
	    }
	}
    }
    
    namespace
    {
	ResourceManager               *manager;
	Glib::RefPtr<Gnome::Vfs::Uri>  base_uri;
	
	union
	{
	    Resources::Dialog       *dialog;
	    Resources::Menu         *menu;
	    Resources::StringList   *stringlist;
	    Resources::Form         *form;
	    Resources::BitmapFamily *bitmap_family;
	} current;

	union
	{
	    Widgets::Button          *button;
	    Widgets::Checkbox        *checkbox;
	    Widgets::Label           *label;
	    Widgets::PushButton      *pushbutton;
	    Widgets::SelectorTrigger *strigger;
	    Widgets::PopupTrigger    *ptrigger;
	    Widgets::TextField       *field;
	    Widgets::List            *lst;
	    Widgets::Table           *table;
	    Widgets::ScrollBar       *scrollbar;
            Widgets::FormBitmap      *bitmap;
            Widgets::Slider          *slider;
	} current_widget;

	Widget *previous_widget;
	
	struct
	{
	    int  x;
	    int  y;
	    int  width;
            bool width_auto;
	    int  height;
            bool height_auto;
	} current_pos_size;

        Resources::Bitmap::BitmapType current_bitmap_type;

	Glib::ustring create_child_uri (const Glib::ustring child)
	{
            Glib::RefPtr<Gnome::Vfs::Uri> child_uri = base_uri->append_path (child);
            return child_uri->to_string ();
	}
	
	namespace StringList
	{
	    std::vector<std::string> strings;

	    void import_string (const std::string &button)
	    {
		strings.push_back (button);
	    }
	    
	    void import_end ()
	    {
		current.stringlist->strings = strings;
		strings.clear ();
	    }
	}

	namespace Dialog
	{
	    void import_button (const std::string &button)
	    {
		std::vector<std::string> buttons = current.dialog->buttons;
		buttons.push_back (button);
		current.dialog->buttons = buttons;
	    }
	}

	namespace BitmapFamily
	{
	    void import_bitmap (const std::string &bitmap_filename,
				int                bitmap_bpp)
	    {
		Glib::ustring bitmap_uri = create_child_uri (bitmap_filename);
		
		Resources::Bitmap::BitmapType type = Resources::Bitmap::TYPE_COLOR_256;
		switch (bitmap_bpp)
		{
		case 1:
		    type = Resources::Bitmap::TYPE_MONO;
		    break;
		case 2:
		    type = Resources::Bitmap::TYPE_GREY_4;
		    break;
		case 4:
		    type = Resources::Bitmap::TYPE_GREY_16;
		    break;
		case 5:
		    type = Resources::Bitmap::TYPE_COLOR_16;
		    break;
		case 8:
		    type = Resources::Bitmap::TYPE_COLOR_256;
		    break;
		case 16:
		    type = Resources::Bitmap::TYPE_COLOR_16K;
		    break;
		default:
		    /* WRITE ME */
		    break;
		}
		
		current.bitmap_family->load_file (type, bitmap_uri);
	    }
	}
	
	namespace Menu
	{
	    Resources::Menu::MenuTree submenus;
	    
	    void import_end ()
	    {
		current.menu->set_submenus (submenus);
		submenus.clear ();
	    }

	    void import_menu (const std::string &menu_label)
	    {
		submenus.push_back (Resources::Menu::Submenu (menu_label));
	    }
	    
	    void import_menuitem (const std::string &id, const std::string &label,
				  const std::string &shortcut = "")
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item = { false, id, label, shortcut[0]};
		submenu.items.push_back (item);
	    }

	    void import_separator ()
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item;
		
		item.separator = true;
		submenu.items.push_back (item);
	    }
	}

	namespace Form
	{
	    typedef std::map<std::string, std::string> popuplist_map_t;
	    popuplist_map_t popuplist_map;
	    
	    void import_popuplist (const std::string &popup_id,
				   const std::string &list_id)
	    {
		popuplist_map[popup_id] = list_id;
	    }
	    
	    void import_end ()
	    {
		for (popuplist_map_t::const_iterator i = popuplist_map.begin ();
		     i != popuplist_map.end (); ++i)
		{
		    Widget *widget = current.form->get_widget (i->first);
		    Widgets::PopupTrigger *ptrigger = dynamic_cast<Widgets::PopupTrigger*> (widget);
		    if (ptrigger)
			ptrigger->list_id = i->second;
		}		
		
		popuplist_map.clear ();
	    }
	}

	namespace List
	{
	    std::vector<std::string> items;

	    void import_item (const std::string &item)
	    {
		items.push_back (item);
	    }

	    void apply_items ()
	    {
		current_widget.lst->items = items;
		items.clear ();
	    }
	}

	namespace Table
	{
	    std::vector<int> cols;

	    void import_col (int col)
	    {
		cols.push_back (col);
	    }

	    void import_end ()
	    {
		current_widget.table->column_width = cols;
		cols.clear ();
	    }
	}
	
	void widget_apply_pos (Widget *widget)
	{
	    widget->x = current_pos_size.x;
	    widget->y = current_pos_size.y;
	}
	    
	void widget_apply_pos_size (Widget *widget)
	{
	    widget_apply_pos (widget);

	    Widgets::ResizeableWidget *resizeable =
		dynamic_cast<Widgets::ResizeableWidget*> (widget);

            if (!current_pos_size.width_auto)
		resizeable->width = current_pos_size.width;
            if (!current_pos_size.height_auto)
		resizeable->height = current_pos_size.height;
        }
    }
    
    void RCP::setup (ResourceManager *manager_, const Glib::ustring &uri)
    {
	manager = manager_;
	error = "";

	// Store base URI
        Glib::RefPtr<Gnome::Vfs::Uri> orig_uri = Gnome::Vfs::Uri::create (uri);
	base_uri = orig_uri->get_parent ();
    }

    void RCP::finish ()
    {
	yypop_buffer_state ();
    }
    
    /* parse errors */
    void yyerror(const char *s) {
	char *buffer = g_strdup_printf (_("%s at line %d near `%s'"),
					s, lexer_lineno, yytext);
	IO::RCP::error = buffer;
	g_free (buffer);
    }




/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 334 "parser.yy"
typedef union YYSTYPE {
    char *str;
    int   num;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 638 "parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 213 of yacc.c.  */
#line 650 "parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   436

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  122
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  112
/* YYNRULES -- Number of rules. */
#define YYNRULES  277
/* YYNRULES -- Number of states. */
#define YYNSTATES  440

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   376

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     6,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    30,    32,    35,    37,    39,
      41,    43,    45,    50,    57,    64,    66,    68,    70,    72,
      73,    81,    84,    85,    87,    89,    91,    93,    95,    98,
     101,   102,   110,   113,   114,   116,   118,   120,   122,   125,
     127,   128,   136,   139,   140,   142,   144,   146,   148,   150,
     153,   156,   157,   165,   168,   169,   171,   173,   174,   182,
     185,   186,   188,   190,   192,   194,   197,   199,   202,   205,
     206,   212,   216,   220,   223,   224,   226,   228,   230,   232,
     234,   236,   238,   240,   243,   246,   247,   253,   256,   257,
     260,   262,   266,   267,   274,   277,   278,   281,   284,   287,
     290,   291,   293,   294,   302,   305,   306,   308,   311,   312,
     314,   316,   319,   321,   322,   329,   332,   333,   335,   338,
     341,   344,   347,   348,   355,   358,   359,   361,   363,   365,
     367,   370,   373,   376,   379,   382,   385,   386,   393,   396,
     397,   399,   401,   403,   405,   407,   409,   411,   413,   415,
     417,   419,   421,   424,   426,   428,   434,   439,   442,   443,
     445,   447,   449,   451,   453,   455,   458,   461,   464,   467,
     468,   471,   475,   477,   479,   481,   483,   485,   487,   489,
     491,   493,   495,   497,   499,   501,   502,   510,   513,   514,
     517,   519,   521,   523,   525,   528,   531,   532,   535,   538,
     541,   544,   545,   547,   551,   555,   558,   562,   563,   569,
     572,   573,   575,   576,   582,   584,   586,   588,   590,   592,
     594,   597,   598,   600,   602,   604,   606,   608,   613,   616,
     619,   621,   623,   625,   626,   635,   636,   645,   646,   654,
     657,   658,   659,   666,   667,   674,   677,   678,   679,   686,
     689,   690,   695,   698,   702,   706,   710,   714,   718,   722,
     724,   726,   728,   730,   732,   734,   736,   738
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     123,     0,    -1,   123,   124,    -1,    -1,   189,    -1,   203,
      -1,   206,    -1,   204,    -1,   205,    -1,   195,    -1,   210,
      -1,   215,    -1,   225,    -1,   116,    -1,     3,   116,    -1,
       4,    -1,    91,   121,    -1,    40,    -1,    41,    -1,    42,
      -1,    43,    -1,    44,    -1,     7,   232,   232,     8,    -1,
       7,   232,   232,   133,   134,     8,    -1,     7,   232,   232,
     232,   232,     8,    -1,   232,    -1,    39,    -1,   232,    -1,
      39,    -1,    -1,    24,   115,   125,    85,   131,   136,   137,
      -1,   137,   138,    -1,    -1,   126,    -1,   127,    -1,   128,
      -1,   129,    -1,    64,    -1,    65,   116,    -1,    66,   116,
      -1,    -1,    26,   115,   125,    85,   131,   140,   141,    -1,
     141,   142,    -1,    -1,   126,    -1,   127,    -1,   128,    -1,
     129,    -1,    93,   121,    -1,    87,    -1,    -1,    27,   115,
     125,    85,   131,   144,   145,    -1,   145,   146,    -1,    -1,
     126,    -1,   129,    -1,   127,    -1,   128,    -1,    64,    -1,
      65,   116,    -1,    66,   116,    -1,    -1,    28,   115,   125,
      85,   130,   148,   149,    -1,   149,   150,    -1,    -1,   126,
      -1,   127,    -1,    -1,    29,   115,   125,    85,   131,   152,
     153,    -1,   153,   154,    -1,    -1,   126,    -1,   127,    -1,
     128,    -1,   129,    -1,    93,   121,    -1,    64,    -1,    65,
     116,    -1,    66,   116,    -1,    -1,   157,    85,   131,   156,
     158,    -1,    23,   115,   125,    -1,    25,   115,   125,    -1,
     158,   159,    -1,    -1,   126,    -1,   127,    -1,   128,    -1,
      46,    -1,    45,    -1,    47,    -1,   129,    -1,    64,    -1,
      65,   116,    -1,    66,   116,    -1,    -1,    33,    85,   130,
     161,   162,    -1,   163,   162,    -1,    -1,    17,   116,    -1,
     127,    -1,    30,    85,   130,    -1,    -1,    36,   125,    85,
     131,   166,   167,    -1,   168,   167,    -1,    -1,    57,   121,
      -1,    58,   121,    -1,    59,   169,    -1,   170,   169,    -1,
      -1,   121,    -1,    -1,    32,   173,   125,    85,   131,   172,
     175,    -1,   174,   173,    -1,    -1,   115,    -1,   176,   175,
      -1,    -1,   127,    -1,   126,    -1,    55,   121,    -1,    56,
      -1,    -1,    35,   125,    85,   131,   178,   179,    -1,   180,
     179,    -1,    -1,   127,    -1,    60,   121,    -1,    61,   121,
      -1,    62,   121,    -1,    63,   121,    -1,    -1,    38,   125,
      85,   131,   182,   183,    -1,   184,   183,    -1,    -1,   127,
      -1,   128,    -1,    53,    -1,    54,    -1,    67,   116,    -1,
      68,   116,    -1,    60,   121,    -1,    61,   121,    -1,    62,
     121,    -1,    63,   121,    -1,    -1,    31,   125,    85,   131,
     186,   187,    -1,   188,   187,    -1,    -1,   127,    -1,   128,
      -1,   126,    -1,    90,    -1,    99,    -1,   106,    -1,   104,
      -1,    98,    -1,    89,    -1,    51,    -1,    50,    -1,    52,
      -1,    94,   121,    -1,    48,    -1,    49,    -1,   190,   191,
       5,   193,     6,    -1,    92,   125,    85,   132,    -1,   191,
     192,    -1,    -1,    45,    -1,    46,    -1,    40,    -1,    97,
      -1,   102,    -1,   100,    -1,     9,   116,    -1,    10,   116,
      -1,    11,   116,    -1,   193,   194,    -1,    -1,   105,   115,
      -1,    35,   125,   116,    -1,   155,    -1,   151,    -1,   147,
      -1,   143,    -1,   135,    -1,   185,    -1,   139,    -1,   164,
      -1,   165,    -1,   177,    -1,   181,    -1,   171,    -1,   160,
      -1,    -1,    13,   125,   196,   197,     5,   199,     6,    -1,
     197,   198,    -1,    -1,    88,   232,    -1,    20,    -1,    19,
      -1,    21,    -1,    22,    -1,     9,   125,    -1,   199,   200,
      -1,    -1,   105,   115,    -1,    96,   115,    -1,    86,   201,
      -1,   201,   202,    -1,    -1,   115,    -1,    15,   125,   115,
      -1,   107,   125,   115,    -1,   107,   115,    -1,    12,   125,
     115,    -1,    -1,    16,   125,   115,   207,   208,    -1,   209,
     208,    -1,    -1,   115,    -1,    -1,   212,   125,   115,   211,
     213,    -1,    17,    -1,    69,    -1,    70,    -1,    71,    -1,
      72,    -1,    73,    -1,   214,   213,    -1,    -1,    77,    -1,
      76,    -1,    78,    -1,    80,    -1,    79,    -1,    81,   121,
     121,   121,    -1,    82,   116,    -1,    83,   116,    -1,   216,
      -1,   218,    -1,   220,    -1,    -1,    18,   125,   115,   115,
     115,   115,   217,   213,    -1,    -1,    74,   125,   115,   115,
     115,   115,   219,   213,    -1,    -1,    75,   125,   221,   213,
       5,   222,     6,    -1,   223,   222,    -1,    -1,    -1,    17,
     115,    84,   121,   224,   213,    -1,    -1,    14,   125,   226,
       5,   227,     6,    -1,   228,   227,    -1,    -1,    -1,   101,
     115,   229,     5,   230,     6,    -1,   230,   231,    -1,    -1,
      95,   115,   125,   115,    -1,    95,   103,    -1,    95,   115,
     125,    -1,   232,   117,   232,    -1,   232,   118,   232,    -1,
     232,   119,   232,    -1,   232,   120,   232,    -1,     7,   232,
       8,    -1,   233,    -1,   121,    -1,   108,    -1,   109,    -1,
     111,    -1,   110,    -1,   112,    -1,   113,    -1,   114,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   492,   492,   492,   495,   496,   497,   498,   499,   500,
     501,   502,   503,   507,   507,   507,   512,   513,   513,   514,
     515,   515,   517,   522,   527,   538,   539,   541,   542,   549,
     549,   558,   558,   559,   560,   561,   562,   563,   564,   565,
     572,   572,   581,   581,   582,   583,   584,   585,   586,   587,
     595,   595,   604,   604,   605,   606,   607,   608,   609,   610,
     611,   618,   618,   627,   627,   628,   629,   637,   637,   646,
     646,   647,   648,   649,   650,   651,   652,   653,   654,   661,
     661,   667,   671,   678,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,   688,   695,   695,   703,   703,   704,
     705,   712,   724,   724,   730,   730,   731,   732,   733,   735,
     735,   736,   743,   743,   752,   752,   753,   757,   757,   758,
     759,   760,   761,   768,   768,   776,   776,   777,   778,   779,
     780,   781,   786,   786,   794,   794,   795,   796,   797,   798,
     799,   800,   801,   802,   803,   804,   810,   810,   820,   820,
     821,   822,   823,   824,   825,   826,   827,   828,   829,   830,
     831,   832,   833,   834,   835,   841,   843,   854,   854,   855,
     856,   857,   858,   859,   860,   861,   862,   863,   865,   865,
     866,   867,   868,   869,   870,   871,   872,   873,   874,   875,
     876,   877,   878,   879,   880,   887,   887,   893,   893,   894,
     895,   896,   897,   898,   899,   902,   902,   903,   904,   905,
     907,   907,   908,   915,   927,   928,   930,   937,   937,   944,
     944,   945,   952,   952,   962,   963,   964,   965,   966,   967,
     970,   970,   971,   971,   971,   972,   972,   973,   974,   975,
     982,   982,   982,   984,   983,  1000,   999,  1015,  1015,  1020,
    1020,  1021,  1021,  1029,  1029,  1034,  1034,  1035,  1035,  1038,
    1038,  1039,  1040,  1041,  1047,  1048,  1049,  1050,  1051,  1052,
    1054,  1055,  1056,  1057,  1058,  1059,  1060,  1061
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID_TOKEN", "AUTOID", "BEG", "END",
  "LBRACE", "RBRACE", "HELPID", "MENUID", "DEFAULTBTNID",
  "APPLICATIONICONNAME", "ALERT", "MENU", "STRING", "STRINGTABLE",
  "BITMAP", "BITMAPFAMILY", "DIALOG_CONFIRMATION", "DIALOG_INFORMATION",
  "DIALOG_WARNING", "DIALOG_ERROR", "BUTTON", "POPUPTRIGGER",
  "REPEATBUTTON", "CHECKBOX", "SELECTORTRIGGER", "LABEL", "PUSHBUTTON",
  "GRAFFITISTATEINDICATOR", "FIELD", "LIST", "FORMBITMAP", "GADGET",
  "POPUPLIST", "TABLE", "SCROLLBAR", "SLIDER", "AUTO", "USABLE",
  "NONUSABLE", "DISABLED", "LEFTANCHOR", "RIGHTANCHOR", "FRAME", "NOFRAME",
  "BOLDFRAME", "LEFTALIGN", "RIGHTALIGN", "NUMERIC", "AUTOSHIFT",
  "HASSCROLLBAR", "VERTICAL", "FEEDBACK", "VISIBLEITEMS", "SEARCH", "ROWS",
  "COLUMNS", "COLUMNWIDTHS", "VALUE", "MIN_VAL", "MAX_VAL", "PAGESIZE",
  "GRAPHICAL", "BITMAPID", "SELECTEDBITMAPID", "THUMBID", "BACKGROUNDID",
  "BITMAPGREY", "BITMAPGREY16", "BITMAPCOLOR16", "BITMAPCOLOR",
  "BITMAPCOLOR16K", "BITMAPFAMILYSPECIAL", "BITMAPFAMILYEX", "COMPRESS",
  "NOCOMPRESS", "FORCECOMPRESS", "COLORTABLE", "NOCOLORTABLE",
  "TRANSPARENT", "TRANSPARENTINDEX", "DENSITY", "BPP", "AT", "BUTTONS",
  "CHECKED", "DEFAULTBUTTON", "DYNAMICSIZE", "EDITABLE", "FONT", "FORM",
  "GROUP", "MAXCHARS", "MENUITEM", "MESSAGE", "MODAL", "MULTIPLELINES",
  "NONEDITABLE", "NOSAVEBEHIND", "PULLDOWN", "SAVEBEHIND", "SEPARATOR",
  "SINGLELINE", "TITLE", "UNDERLINED", "VERSION_TOKEN", "CENTER",
  "PREVLEFT", "PREVRIGHT", "PREVTOP", "PREVBOTTOM", "PREVWIDTH",
  "PREVHEIGHT", "QUOTESTRING", "WORD", "PLUS", "MINUS", "TIMES", "DIV",
  "NUMBER", "$accept", "rcpfile", "resource", "identifier",
  "widget_prop_font", "widget_prop_usable", "widget_prop_disabled",
  "widget_prop_anchor", "POSITION", "POS_SIZE", "FORM_POS_SIZE", "hsize",
  "vsize", "widget_ptrigger", "@1", "widget_ptrigger_options",
  "widget_ptrigger_option", "widget_checkbox", "@2",
  "widget_checkbox_options", "widget_checkbox_option", "widget_strigger",
  "@3", "widget_strigger_options", "widget_strigger_option",
  "widget_label", "@4", "widget_label_options", "widget_label_option",
  "widget_pushbutton", "@5", "widget_pushbutton_options",
  "widget_pushbutton_option", "widget_button", "@6", "widget_button_begin",
  "widget_button_options", "widget_button_option", "widget_bitmap", "@7",
  "widget_bitmap_options", "widget_bitmap_option", "widget_graffiti",
  "widget_table", "@8", "widget_table_options", "widget_table_option",
  "widget_table_cols", "widget_table_col", "widget_list", "@9",
  "widget_list_items", "widget_list_item", "widget_list_options",
  "widget_list_option", "widget_scrollbar", "@10",
  "widget_scrollbar_options", "widget_scrollbar_option", "widget_slider",
  "@11", "widget_slider_options", "widget_slider_option", "widget_field",
  "@12", "widget_field_options", "widget_field_option", "res_form",
  "res_form_start", "res_form_options", "res_form_option",
  "res_form_children", "res_form_child", "res_dialog", "@13",
  "res_dialog_options", "res_dialog_option", "res_dialog_children",
  "res_dialog_child", "res_dialog_buttons", "res_dialog_button",
  "res_string", "res_app_ver", "res_app_name", "res_stringlist", "@14",
  "res_stringlist_strings", "res_stringlist_string", "res_bitmap", "@15",
  "res_bitmap_type", "res_bitmap_options", "res_bitmap_option",
  "res_bitmapfamily", "res_bitmapfamily_def", "@16",
  "res_bitmapfamily_special", "@17", "res_bitmapfamily_ex", "@18",
  "res_bitmapfamily_children", "res_bitmapfamily_child", "@19", "res_menu",
  "@20", "res_menu_menus", "res_menu_menu", "@21", "res_menu_children",
  "res_menu_child", "expr", "expr_atom", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,   122,   123,   123,   124,   124,   124,   124,   124,   124,
     124,   124,   124,   125,   125,   125,   126,   127,   127,   128,
     129,   129,   130,   131,   132,   133,   133,   134,   134,   136,
     135,   137,   137,   138,   138,   138,   138,   138,   138,   138,
     140,   139,   141,   141,   142,   142,   142,   142,   142,   142,
     144,   143,   145,   145,   146,   146,   146,   146,   146,   146,
     146,   148,   147,   149,   149,   150,   150,   152,   151,   153,
     153,   154,   154,   154,   154,   154,   154,   154,   154,   156,
     155,   157,   157,   158,   158,   159,   159,   159,   159,   159,
     159,   159,   159,   159,   159,   161,   160,   162,   162,   163,
     163,   164,   166,   165,   167,   167,   168,   168,   168,   169,
     169,   170,   172,   171,   173,   173,   174,   175,   175,   176,
     176,   176,   176,   178,   177,   179,   179,   180,   180,   180,
     180,   180,   182,   181,   183,   183,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   186,   185,   187,   187,
     188,   188,   188,   188,   188,   188,   188,   188,   188,   188,
     188,   188,   188,   188,   188,   189,   190,   191,   191,   192,
     192,   192,   192,   192,   192,   192,   192,   192,   193,   193,
     194,   194,   194,   194,   194,   194,   194,   194,   194,   194,
     194,   194,   194,   194,   194,   196,   195,   197,   197,   198,
     198,   198,   198,   198,   198,   199,   199,   200,   200,   200,
     201,   201,   202,   203,   204,   204,   205,   207,   206,   208,
     208,   209,   211,   210,   212,   212,   212,   212,   212,   212,
     213,   213,   214,   214,   214,   214,   214,   214,   214,   214,
     215,   215,   215,   217,   216,   219,   218,   221,   220,   222,
     222,   224,   223,   226,   225,   227,   227,   229,   228,   230,
     230,   231,   231,   231,   232,   232,   232,   232,   232,   232,
     233,   233,   233,   233,   233,   233,   233,   233
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     2,     1,     1,     1,
       1,     1,     4,     6,     6,     1,     1,     1,     1,     0,
       7,     2,     0,     1,     1,     1,     1,     1,     2,     2,
       0,     7,     2,     0,     1,     1,     1,     1,     2,     1,
       0,     7,     2,     0,     1,     1,     1,     1,     1,     2,
       2,     0,     7,     2,     0,     1,     1,     0,     7,     2,
       0,     1,     1,     1,     1,     2,     1,     2,     2,     0,
       5,     3,     3,     2,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     0,     5,     2,     0,     2,
       1,     3,     0,     6,     2,     0,     2,     2,     2,     2,
       0,     1,     0,     7,     2,     0,     1,     2,     0,     1,
       1,     2,     1,     0,     6,     2,     0,     1,     2,     2,
       2,     2,     0,     6,     2,     0,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     0,     6,     2,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     5,     4,     2,     0,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     0,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     7,     2,     0,     2,
       1,     1,     1,     1,     2,     2,     0,     2,     2,     2,
       2,     0,     1,     3,     3,     2,     3,     0,     5,     2,
       0,     1,     0,     5,     1,     1,     1,     1,     1,     1,
       2,     0,     1,     1,     1,     1,     1,     4,     2,     2,
       1,     1,     1,     0,     8,     0,     8,     0,     7,     2,
       0,     0,     6,     0,     6,     2,     0,     0,     6,     2,
       0,     4,     2,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       3,     0,     1,     0,     0,     0,     0,     0,   224,     0,
     225,   226,   227,   228,   229,     0,     0,     0,     0,     2,
       4,   168,     9,     5,     7,     8,     6,    10,     0,    11,
     240,   241,   242,    12,     0,    15,    13,     0,   195,   253,
       0,     0,     0,     0,   247,     0,   215,     0,     0,     0,
      14,   216,   198,     0,   213,   217,     0,     0,   231,     0,
     214,   179,     0,     0,     0,   171,   169,   170,   172,   174,
     173,   167,   222,     0,   256,   220,     0,     0,   233,   232,
     234,   236,   235,     0,     0,     0,     0,   231,     0,   166,
       0,   175,   176,   177,   231,   206,     0,   201,   200,   202,
     203,     0,   197,     0,     0,   256,   221,   218,   220,     0,
       0,     0,   238,   239,   250,   230,     0,   271,   272,   274,
     273,   275,   276,   277,   270,     0,   269,   165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   115,     0,     0,
       0,     0,     0,   186,   188,   185,   184,   183,   182,     0,
     194,   189,   190,   193,   191,   192,   187,   178,   223,     0,
     204,   199,   257,   254,   255,   219,   243,   245,     0,     0,
       0,   250,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   116,     0,   115,
       0,     0,     0,     0,   180,     0,   196,   211,     0,     0,
     205,     0,   231,   231,   237,     0,   248,   249,   268,   264,
     265,   266,   267,     0,    81,     0,    82,     0,     0,     0,
       0,     0,   101,     0,     0,   114,    95,     0,   181,     0,
       0,     0,    79,   209,   208,   207,   260,   244,   246,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,    98,
     123,   102,   132,     0,    84,   212,   210,     0,   251,    24,
      29,    40,    50,    61,    67,     0,   149,   112,     0,    17,
      18,   100,    96,    98,   126,   105,   135,     0,    80,   258,
       0,   259,   231,    32,    43,    53,    64,    70,    22,    19,
     163,   164,   160,   159,   161,   158,   153,     0,     0,   157,
     154,   156,   155,   152,   150,   151,   147,   149,   118,    99,
      97,     0,     0,     0,     0,   127,   124,   126,     0,     0,
     110,   103,   105,   138,   139,     0,     0,     0,     0,     0,
       0,   136,   137,   133,   135,    26,     0,    25,    20,    21,
      89,    88,    90,    92,     0,     0,    85,    86,    87,    91,
      83,   262,     0,   252,    30,    41,    51,    62,    68,    16,
     162,   148,     0,   122,   120,   119,   113,   118,   128,   129,
     130,   131,   125,   106,   107,   111,   108,   110,   104,   142,
     143,   144,   145,   140,   141,   134,    28,     0,    27,    93,
      94,   263,    37,     0,     0,    33,    34,    35,    36,    31,
      49,     0,    44,    45,    46,    47,    42,    58,     0,     0,
      54,    56,    57,    55,    52,    65,    66,    63,    76,     0,
       0,     0,    71,    72,    73,    74,    69,   121,   117,   109,
      23,   261,    38,    39,    48,    59,    60,    77,    78,    75
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,     1,    19,    37,   303,   271,   305,   349,   222,   232,
      89,   336,   387,   143,   283,   354,   399,   144,   284,   355,
     406,   145,   285,   356,   414,   146,   286,   357,   417,   147,
     287,   358,   426,   148,   254,   149,   278,   350,   150,   249,
     272,   273,   151,   152,   275,   321,   322,   376,   377,   153,
     308,   188,   189,   366,   367,   154,   274,   316,   317,   155,
     276,   333,   334,   156,   266,   306,   307,    20,    21,    48,
      71,    90,   157,    22,    52,    73,   102,   159,   200,   233,
     256,    23,    24,    25,    26,    75,   107,   108,    27,    94,
      28,    86,    87,    29,    30,   202,    31,   203,    32,    58,
     170,   171,   282,    33,    53,   104,   105,   201,   257,   281,
     125,   126
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -259
static const short int yypact[] =
{
    -259,   211,  -259,    15,    15,    15,    15,    15,  -259,    15,
    -259,  -259,  -259,  -259,  -259,    15,    15,    15,    13,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,    15,  -259,
    -259,  -259,  -259,  -259,   -93,  -259,  -259,   -80,  -259,  -259,
     -70,   -69,   -67,   -62,  -259,   -48,  -259,   -60,   230,   -59,
    -259,  -259,  -259,    54,  -259,  -259,   -35,   -25,   327,    53,
    -259,  -259,   -23,   -22,   -17,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,   178,   -10,   -11,     5,    18,  -259,  -259,
    -259,  -259,  -259,   -20,    22,    23,   108,   327,    96,  -259,
      43,  -259,  -259,  -259,   327,  -259,    15,  -259,  -259,  -259,
    -259,    96,  -259,    19,   143,   -10,  -259,  -259,   -11,    45,
      56,    40,  -259,  -259,   156,  -259,    96,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,    33,  -259,  -259,    66,    67,
      70,    81,    97,    99,   101,   110,    15,   103,   134,    15,
      15,    15,   105,  -259,  -259,  -259,  -259,  -259,  -259,   136,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,    16,
    -259,   -55,  -259,  -259,  -259,  -259,  -259,  -259,   112,   116,
     231,   156,    39,    96,    96,    96,    96,    33,    15,    15,
      15,    15,    15,    15,    15,   229,   153,  -259,    15,   103,
     229,   -28,   157,   161,  -259,   240,  -259,  -259,   138,   139,
    -259,   250,   327,   327,  -259,   172,  -259,  -259,  -259,   -78,
     -78,  -259,  -259,    33,  -259,   175,  -259,   177,   180,   182,
     183,    96,  -259,   240,   184,  -259,  -259,   240,  -259,   240,
     240,    96,  -259,   142,  -259,  -259,  -259,  -259,  -259,   151,
      46,   240,   240,   240,   229,   240,    33,  -259,   240,     3,
    -259,  -259,  -259,    33,  -259,  -259,  -259,     0,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,    50,   256,  -259,   158,  -259,
    -259,  -259,  -259,     3,   259,    68,   360,    -3,   -14,  -259,
     -94,  -259,   327,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,   166,   167,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,   256,   203,  -259,
    -259,   168,   181,   194,   195,  -259,  -259,   259,   196,   204,
     205,  -259,    68,  -259,  -259,   207,   208,   210,   222,   162,
     163,  -259,  -259,  -259,   360,  -259,    80,   -55,  -259,  -259,
    -259,  -259,  -259,  -259,   185,   193,  -259,  -259,  -259,  -259,
    -259,  -259,    15,  -259,   328,   298,   333,    -2,   293,  -259,
    -259,  -259,   223,  -259,  -259,  -259,  -259,   203,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,   205,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,   269,   -55,  -259,
    -259,   209,  -259,   233,   235,  -259,  -259,  -259,  -259,  -259,
    -259,   232,  -259,  -259,  -259,  -259,  -259,  -259,   236,   245,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,   247,
     248,   244,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -259,  -259,  -259,    -4,  -106,   -44,   -63,  -258,  -183,   188,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
      83,  -259,  -259,  -259,  -259,    44,  -259,     1,  -259,  -259,
    -259,   190,  -259,    14,  -259,  -259,  -259,    63,  -259,  -259,
    -259,    48,  -259,  -259,  -259,    60,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,   275,  -259,  -259,  -259,
    -259,   -79,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
     216,  -259,  -259,  -259,  -259,   283,  -259,  -259,  -259,  -259,
     -91,  -259
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned short int yytable[] =
{
      38,    39,    40,    41,   116,    42,   279,   226,   115,   351,
     161,    43,    44,    45,    47,   158,    34,    35,    34,    35,
     268,   352,   196,    50,    49,   172,   269,   270,   289,   338,
     339,   340,   341,   342,   177,    51,   335,    59,   269,   270,
     116,   175,   176,   269,   270,    54,    55,   208,    56,   127,
     343,   344,   345,    57,   259,    60,    72,   227,   288,    74,
      88,   263,   173,   174,   175,   176,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   297,   139,   140,
      76,   141,   209,   210,   211,   212,   213,   116,   228,   297,
      77,   103,   160,    91,    92,   280,   398,   405,   413,    93,
     425,   111,   197,   116,   106,   117,   118,   119,   120,   121,
     122,   123,   198,   114,   173,   174,   175,   176,   124,   386,
     109,   199,   240,   237,   238,   318,   319,   320,    46,    36,
     246,    36,   186,   110,   162,   191,   192,   193,   112,   113,
     253,   117,   118,   119,   120,   121,   122,   123,   142,   163,
     173,   174,   175,   176,   124,   265,   173,   174,   175,   176,
     166,   168,   277,   173,   174,   175,   176,   173,   174,   175,
     176,   167,   346,   169,   214,   215,   216,   217,   218,   219,
     220,   178,   179,    95,   224,   180,   337,    96,   117,   118,
     119,   120,   121,   122,   123,   185,   181,    97,    98,    99,
     100,   124,   364,   353,   117,   118,   119,   120,   121,   122,
     123,     2,   182,   332,   183,   348,   184,   124,   187,   190,
     194,   195,   304,     3,     4,     5,     6,     7,     8,     9,
     315,   205,   331,   204,   347,    61,   221,   206,   223,    62,
      63,    64,   229,   269,   270,   388,   230,   231,   395,   402,
     410,   415,   422,   234,   235,   236,   239,   255,   362,   363,
     241,   364,   242,   304,   365,   243,   101,   244,   245,   248,
      65,   332,   258,   315,   309,    66,    67,   430,   383,   384,
      10,    11,    12,    13,    14,    15,    16,   359,   360,   368,
     331,   397,   404,   412,   297,   424,   269,   270,   289,   269,
     270,   389,   369,    17,   290,   291,   292,   293,   294,   390,
     396,   403,   411,   416,   423,   370,   371,   373,    18,   311,
     312,   313,   314,   365,   431,   374,   375,    68,   379,   380,
      69,   381,    70,   269,   270,   289,   338,   339,   269,   270,
     289,   338,   339,   382,   427,   295,   296,   297,   391,   432,
     298,   433,   435,   434,   299,   300,   310,   418,   419,   420,
     301,   436,   302,   437,   438,   439,   378,   361,   269,   270,
     289,   338,   339,   269,   270,   289,   338,   339,   429,   225,
     372,   428,   385,   165,   297,   400,   421,   207,   164,   297,
       0,   401,   392,   393,   394,     0,     0,   407,   408,   409,
     269,   270,   289,    78,    79,    80,    81,    82,    83,    84,
      85,   247,     0,   323,   324,   250,     0,   251,   252,   297,
     325,   326,   327,   328,   297,     0,     0,   329,   330,   260,
     261,   262,     0,   264,     0,     0,   267
};

static const short int yycheck[] =
{
       4,     5,     6,     7,     7,     9,     6,   190,    87,   103,
     101,    15,    16,    17,    18,    94,     3,     4,     3,     4,
      17,   115,     6,   116,    28,   116,    40,    41,    42,    43,
      44,    45,    46,    47,   125,   115,    39,    85,    40,    41,
       7,   119,   120,    40,    41,   115,   115,     8,   115,     6,
      64,    65,    66,   115,     8,   115,   115,    85,     8,     5,
       7,   244,   117,   118,   119,   120,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    91,    35,    36,
     115,    38,   173,   174,   175,   176,   177,     7,   116,    91,
     115,   101,    96,   116,   116,    95,   354,   355,   356,   116,
     358,   121,    86,     7,   115,   108,   109,   110,   111,   112,
     113,   114,    96,     5,   117,   118,   119,   120,   121,    39,
     115,   105,   213,   202,   203,    57,    58,    59,   115,   116,
     221,   116,   136,   115,   115,   139,   140,   141,   116,   116,
     231,   108,   109,   110,   111,   112,   113,   114,   105,     6,
     117,   118,   119,   120,   121,   246,   117,   118,   119,   120,
     115,   121,   253,   117,   118,   119,   120,   117,   118,   119,
     120,   115,   278,    17,   178,   179,   180,   181,   182,   183,
     184,   115,   115,     5,   188,   115,   277,     9,   108,   109,
     110,   111,   112,   113,   114,    85,   115,    19,    20,    21,
      22,   121,   308,   282,   108,   109,   110,   111,   112,   113,
     114,     0,   115,   276,   115,   278,   115,   121,   115,    85,
     115,    85,   266,    12,    13,    14,    15,    16,    17,    18,
     274,   115,   276,   121,   278,     5,     7,     6,    85,     9,
      10,    11,    85,    40,    41,   336,    85,     7,   354,   355,
     356,   357,   358,   115,   115,     5,    84,   115,    55,    56,
      85,   367,    85,   307,   308,    85,    88,    85,    85,    85,
      40,   334,   121,   317,   116,    45,    46,     8,   116,   116,
      69,    70,    71,    72,    73,    74,    75,   121,   121,   121,
     334,   354,   355,   356,    91,   358,    40,    41,    42,    40,
      41,   116,   121,    92,    48,    49,    50,    51,    52,   116,
     354,   355,   356,   357,   358,   121,   121,   121,   107,    60,
      61,    62,    63,   367,   115,   121,   121,    97,   121,   121,
     100,   121,   102,    40,    41,    42,    43,    44,    40,    41,
      42,    43,    44,   121,   121,    89,    90,    91,   352,   116,
      94,   116,   116,   121,    98,    99,   273,    64,    65,    66,
     104,   116,   106,   116,   116,   121,   322,   307,    40,    41,
      42,    43,    44,    40,    41,    42,    43,    44,   377,   189,
     317,   367,   334,   108,    91,    87,    93,   171,   105,    91,
      -1,    93,    64,    65,    66,    -1,    -1,    64,    65,    66,
      40,    41,    42,    76,    77,    78,    79,    80,    81,    82,
      83,   223,    -1,    53,    54,   227,    -1,   229,   230,    91,
      60,    61,    62,    63,    91,    -1,    -1,    67,    68,   241,
     242,   243,    -1,   245,    -1,    -1,   248
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,   123,     0,    12,    13,    14,    15,    16,    17,    18,
      69,    70,    71,    72,    73,    74,    75,    92,   107,   124,
     189,   190,   195,   203,   204,   205,   206,   210,   212,   215,
     216,   218,   220,   225,     3,     4,   116,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   115,   125,   191,   125,
     116,   115,   196,   226,   115,   115,   115,   115,   221,    85,
     115,     5,     9,    10,    11,    40,    45,    46,    97,   100,
     102,   192,   115,   197,     5,   207,   115,   115,    76,    77,
      78,    79,    80,    81,    82,    83,   213,   214,     7,   132,
     193,   116,   116,   116,   211,     5,     9,    19,    20,    21,
      22,    88,   198,   101,   227,   228,   115,   208,   209,   115,
     115,   121,   116,   116,     5,   213,     7,   108,   109,   110,
     111,   112,   113,   114,   121,   232,   233,     6,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    35,
      36,    38,   105,   135,   139,   143,   147,   151,   155,   157,
     160,   164,   165,   171,   177,   181,   185,   194,   213,   199,
     125,   232,   115,     6,   227,   208,   115,   115,   121,    17,
     222,   223,   232,   117,   118,   119,   120,   232,   115,   115,
     115,   115,   115,   115,   115,    85,   125,   115,   173,   174,
      85,   125,   125,   125,   115,    85,     6,    86,    96,   105,
     200,   229,   217,   219,   121,   115,     6,   222,     8,   232,
     232,   232,   232,   232,   125,   125,   125,   125,   125,   125,
     125,     7,   130,    85,   125,   173,   130,    85,   116,    85,
      85,     7,   131,   201,   115,   115,     5,   213,   213,    84,
     232,    85,    85,    85,    85,    85,   232,   131,    85,   161,
     131,   131,   131,   232,   156,   115,   202,   230,   121,     8,
     131,   131,   131,   130,   131,   232,   186,   131,    17,    40,
      41,   127,   162,   163,   178,   166,   182,   232,   158,     6,
      95,   231,   224,   136,   140,   144,   148,   152,     8,    42,
      48,    49,    50,    51,    52,    89,    90,    91,    94,    98,
      99,   104,   106,   126,   127,   128,   187,   188,   172,   116,
     162,    60,    61,    62,    63,   127,   179,   180,    57,    58,
      59,   167,   168,    53,    54,    60,    61,    62,    63,    67,
      68,   127,   128,   183,   184,    39,   133,   232,    43,    44,
      45,    46,    47,    64,    65,    66,   126,   127,   128,   129,
     159,   103,   115,   213,   137,   141,   145,   149,   153,   121,
     121,   187,    55,    56,   126,   127,   175,   176,   121,   121,
     121,   121,   179,   121,   121,   121,   169,   170,   167,   121,
     121,   121,   121,   116,   116,   183,    39,   134,   232,   116,
     116,   125,    64,    65,    66,   126,   127,   128,   129,   138,
      87,    93,   126,   127,   128,   129,   142,    64,    65,    66,
     126,   127,   128,   129,   146,   126,   127,   150,    64,    65,
      66,    93,   126,   127,   128,   129,   154,   121,   175,   169,
       8,   115,   116,   116,   121,   116,   116,   116,   116,   121
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 115: /* QUOTESTRING */
#line 481 "parser.yy"
        { free ((yyvaluep->str)); };
#line 1734 "parser.cc"
        break;
      case 116: /* WORD */
#line 481 "parser.yy"
        { free ((yyvaluep->str)); };
#line 1739 "parser.cc"
        break;

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 14:
#line 507 "parser.yy"
    { (yyval.str) = (yyvsp[0].str); }
    break;

  case 15:
#line 507 "parser.yy"
    { (yyval.str) = "_AUTO_"; }
    break;

  case 16:
#line 512 "parser.yy"
    { (yyval.num) = (yyvsp[0].num); }
    break;

  case 17:
#line 513 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 18:
#line 513 "parser.yy"
    { (yyval.num) = false; }
    break;

  case 19:
#line 514 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 20:
#line 515 "parser.yy"
    { (yyval.num) = false; }
    break;

  case 21:
#line 515 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 22:
#line 517 "parser.yy"
    {
    current_pos_size.x = (yyvsp[-2].num);
    current_pos_size.y = (yyvsp[-1].num);
}
    break;

  case 23:
#line 522 "parser.yy"
    {
    current_pos_size.x = (yyvsp[-4].num);
    current_pos_size.y = (yyvsp[-3].num);
}
    break;

  case 24:
#line 527 "parser.yy"
    {
    current_pos_size.x = (yyvsp[-4].num);
    current_pos_size.y = (yyvsp[-3].num);
    current_pos_size.width_auto = false;
    
    current_pos_size.width = (yyvsp[-2].num);
    current_pos_size.height_auto = false;
    current_pos_size.height = (yyvsp[-1].num);
}
    break;

  case 25:
#line 538 "parser.yy"
    { current_pos_size.width_auto = false; current_pos_size.width = (yyvsp[0].num); }
    break;

  case 26:
#line 539 "parser.yy"
    { current_pos_size.width_auto = true; }
    break;

  case 27:
#line 541 "parser.yy"
    { current_pos_size.height_auto = false; current_pos_size.height = (yyvsp[0].num); }
    break;

  case 28:
#line 542 "parser.yy"
    { current_pos_size.height_auto = true; }
    break;

  case 29:
#line 549 "parser.yy"
    {
    current_widget.ptrigger = dynamic_cast<Widgets::PopupTrigger*> (
	current.form->create_widget (Widgets::WIDGET_POPUP_TRIGGER, (yyvsp[-2].str), true));
    current_widget.ptrigger->text = (yyvsp[-3].str);
    widget_apply_pos_size (current_widget.ptrigger);
}
    break;

  case 30:
#line 554 "parser.yy"
    {
    previous_widget = current_widget.ptrigger;
}
    break;

  case 33:
#line 559 "parser.yy"
    { current_widget.ptrigger->font = (yyvsp[0].num); }
    break;

  case 34:
#line 560 "parser.yy"
    { current_widget.ptrigger->usable = (yyvsp[0].num); }
    break;

  case 35:
#line 561 "parser.yy"
    { current_widget.ptrigger->disabled = (yyvsp[0].num); }
    break;

  case 36:
#line 562 "parser.yy"
    { current_widget.ptrigger->anchor_right = (yyvsp[0].num); }
    break;

  case 38:
#line 564 "parser.yy"
    { current_widget.ptrigger->bitmap_id = (yyvsp[0].str); }
    break;

  case 39:
#line 565 "parser.yy"
    { current_widget.ptrigger->selected_bitmap_id = (yyvsp[0].str); }
    break;

  case 40:
#line 572 "parser.yy"
    {
    current_widget.checkbox = dynamic_cast<Widgets::Checkbox*> (
	current.form->create_widget (Widgets::WIDGET_CHECKBOX, (yyvsp[-2].str), true));
    current_widget.checkbox->text = (yyvsp[-3].str);
    widget_apply_pos_size (current_widget.checkbox);
}
    break;

  case 41:
#line 577 "parser.yy"
    {
    previous_widget = current_widget.checkbox;
}
    break;

  case 44:
#line 582 "parser.yy"
    { current_widget.checkbox->font = (yyvsp[0].num); }
    break;

  case 45:
#line 583 "parser.yy"
    { current_widget.checkbox->usable = (yyvsp[0].num); }
    break;

  case 46:
#line 584 "parser.yy"
    { current_widget.checkbox->disabled = (yyvsp[0].num); }
    break;

  case 47:
#line 585 "parser.yy"
    { current_widget.checkbox->anchor_right = (yyvsp[0].num); }
    break;

  case 48:
#line 586 "parser.yy"
    { current_widget.checkbox->group = (yyvsp[0].num); }
    break;

  case 49:
#line 587 "parser.yy"
    { current_widget.checkbox->toggled = true; }
    break;

  case 50:
#line 595 "parser.yy"
    {
    current_widget.strigger = dynamic_cast<Widgets::SelectorTrigger*> (
	current.form->create_widget (Widgets::WIDGET_SELECTOR_TRIGGER, (yyvsp[-2].str), true));
    current_widget.strigger->text = (yyvsp[-3].str);
    widget_apply_pos_size (current_widget.strigger);
}
    break;

  case 51:
#line 600 "parser.yy"
    {
    previous_widget = current_widget.strigger;
}
    break;

  case 54:
#line 605 "parser.yy"
    { current_widget.strigger->font = (yyvsp[0].num); }
    break;

  case 55:
#line 606 "parser.yy"
    { current_widget.strigger->anchor_right = (yyvsp[0].num); }
    break;

  case 56:
#line 607 "parser.yy"
    { current_widget.strigger->usable = (yyvsp[0].num); }
    break;

  case 57:
#line 608 "parser.yy"
    { current_widget.strigger->disabled = (yyvsp[0].num); }
    break;

  case 59:
#line 610 "parser.yy"
    { current_widget.strigger->bitmap_id = (yyvsp[0].str); }
    break;

  case 60:
#line 611 "parser.yy"
    { current_widget.strigger->selected_bitmap_id = (yyvsp[0].str); }
    break;

  case 61:
#line 618 "parser.yy"
    {
    current_widget.label = dynamic_cast<Widgets::Label*> (
	current.form->create_widget (Widgets::WIDGET_LABEL, (yyvsp[-2].str), true));
    current_widget.label->text = (yyvsp[-3].str);
    widget_apply_pos (current_widget.label);
}
    break;

  case 62:
#line 623 "parser.yy"
    {
    previous_widget = current_widget.label;
}
    break;

  case 65:
#line 628 "parser.yy"
    { current_widget.label->font = (yyvsp[0].num); }
    break;

  case 66:
#line 629 "parser.yy"
    { current_widget.label->usable = (yyvsp[0].num); }
    break;

  case 67:
#line 637 "parser.yy"
    {
    current_widget.pushbutton = dynamic_cast<Widgets::PushButton*> (
	current.form->create_widget (Widgets::WIDGET_PUSHBUTTON, (yyvsp[-2].str), true));
    current_widget.pushbutton->text = (yyvsp[-3].str);
    widget_apply_pos_size (current_widget.pushbutton);
}
    break;

  case 68:
#line 642 "parser.yy"
    {
    previous_widget = current_widget.pushbutton;
}
    break;

  case 71:
#line 647 "parser.yy"
    { current_widget.pushbutton->font = (yyvsp[0].num); }
    break;

  case 72:
#line 648 "parser.yy"
    { current_widget.pushbutton->usable = (yyvsp[0].num); }
    break;

  case 73:
#line 649 "parser.yy"
    { current_widget.pushbutton->disabled = (yyvsp[0].num); }
    break;

  case 74:
#line 650 "parser.yy"
    { current_widget.pushbutton->anchor_right = (yyvsp[0].num); }
    break;

  case 75:
#line 651 "parser.yy"
    { current_widget.pushbutton->group = (yyvsp[0].num); }
    break;

  case 77:
#line 653 "parser.yy"
    { current_widget.pushbutton->bitmap_id = (yyvsp[0].str); }
    break;

  case 78:
#line 654 "parser.yy"
    { current_widget.pushbutton->selected_bitmap_id = (yyvsp[0].str); }
    break;

  case 79:
#line 661 "parser.yy"
    {
    widget_apply_pos_size (current_widget.button); }
    break;

  case 80:
#line 663 "parser.yy"
    {
    previous_widget = current_widget.button;
}
    break;

  case 81:
#line 667 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, (yyvsp[0].str), true));
    current_widget.button->text = (yyvsp[-1].str);
}
    break;

  case 82:
#line 671 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, (yyvsp[0].str), true));
    current_widget.button->text = (yyvsp[-1].str);
    current_widget.button->repeat = true;
}
    break;

  case 85:
#line 679 "parser.yy"
    { current_widget.button->font = (yyvsp[0].num); }
    break;

  case 86:
#line 680 "parser.yy"
    { current_widget.button->usable = (yyvsp[0].num); }
    break;

  case 87:
#line 681 "parser.yy"
    { current_widget.button->disabled = (yyvsp[0].num); }
    break;

  case 88:
#line 682 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_NONE; }
    break;

  case 89:
#line 683 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_SIMPLE; }
    break;

  case 90:
#line 684 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_BOLD; }
    break;

  case 91:
#line 685 "parser.yy"
    { current_widget.button->anchor_right = (yyvsp[0].num); }
    break;

  case 93:
#line 687 "parser.yy"
    { current_widget.button->bitmap_id = (yyvsp[0].str); }
    break;

  case 94:
#line 688 "parser.yy"
    { current_widget.button->selected_bitmap_id = (yyvsp[0].str); }
    break;

  case 95:
#line 695 "parser.yy"
    {
    current_widget.bitmap = dynamic_cast<Widgets::FormBitmap*> (
	current.form->create_widget (Widgets::WIDGET_FORMBITMAP));
    widget_apply_pos (current_widget.bitmap);
}
    break;

  case 96:
#line 699 "parser.yy"
    {
    previous_widget = current_widget.bitmap;
}
    break;

  case 99:
#line 704 "parser.yy"
    { current_widget.bitmap->bitmap_id = (yyvsp[0].str); }
    break;

  case 100:
#line 705 "parser.yy"
    { current_widget.bitmap->usable = (yyvsp[0].num); }
    break;

  case 101:
#line 712 "parser.yy"
    {
    Widgets::Graffiti *graffiti = dynamic_cast<Widgets::Graffiti*> (
	current.form->create_widget (Widgets::WIDGET_GRAFFITI));
    widget_apply_pos (graffiti);
    previous_widget = graffiti;
}
    break;

  case 102:
#line 724 "parser.yy"
    {
    current_widget.table = dynamic_cast<Widgets::Table*> (
	current.form->create_widget (Widgets::WIDGET_TABLE, (yyvsp[-2].str), true));
    widget_apply_pos_size (current_widget.table);
}
    break;

  case 103:
#line 728 "parser.yy"
    { Table::import_end (); previous_widget = current_widget.table; }
    break;

  case 106:
#line 731 "parser.yy"
    { current_widget.table->num_rows = (yyvsp[0].num); }
    break;

  case 107:
#line 732 "parser.yy"
    { current_widget.table->num_columns = (yyvsp[0].num); }
    break;

  case 111:
#line 736 "parser.yy"
    { Table::import_col ((yyvsp[0].num)); }
    break;

  case 112:
#line 743 "parser.yy"
    {
    current_widget.lst = dynamic_cast<Widgets::List*> (
	current.form->create_widget (Widgets::WIDGET_LIST, (yyvsp[-2].str), true));
    widget_apply_pos (current_widget.lst);
    List::apply_items ();
}
    break;

  case 113:
#line 748 "parser.yy"
    {
    previous_widget = current_widget.lst;
}
    break;

  case 116:
#line 753 "parser.yy"
    {
    List::import_item ((yyvsp[0].str));
}
    break;

  case 119:
#line 758 "parser.yy"
    { current_widget.lst->usable = (yyvsp[0].num); }
    break;

  case 120:
#line 759 "parser.yy"
    { current_widget.lst->font = (yyvsp[0].num); }
    break;

  case 121:
#line 760 "parser.yy"
    { current_widget.lst->visible_items = (yyvsp[0].num); }
    break;

  case 122:
#line 761 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 123:
#line 768 "parser.yy"
    {
    current_widget.scrollbar = dynamic_cast<Widgets::ScrollBar*> (
	current.form->create_widget (Widgets::WIDGET_SCROLLBAR, (yyvsp[-2].str), true));
    widget_apply_pos_size (current_widget.scrollbar);    
}
    break;

  case 124:
#line 772 "parser.yy"
    {
    previous_widget = current_widget.scrollbar;
}
    break;

  case 127:
#line 777 "parser.yy"
    { current_widget.scrollbar->usable = (yyvsp[0].num); }
    break;

  case 128:
#line 778 "parser.yy"
    { current_widget.scrollbar->value = (yyvsp[0].num); }
    break;

  case 129:
#line 779 "parser.yy"
    { current_widget.scrollbar->min_value = (yyvsp[0].num); }
    break;

  case 130:
#line 780 "parser.yy"
    { current_widget.scrollbar->max_value = (yyvsp[0].num); }
    break;

  case 131:
#line 781 "parser.yy"
    { current_widget.scrollbar->page_size = (yyvsp[0].num); }
    break;

  case 132:
#line 786 "parser.yy"
    {
    current_widget.slider = dynamic_cast<Widgets::Slider*> (
        current.form->create_widget (Widgets::WIDGET_SLIDER, (yyvsp[-2].str), true));
    widget_apply_pos_size (current_widget.slider);
}
    break;

  case 133:
#line 790 "parser.yy"
    {
    previous_widget = current_widget.slider;
}
    break;

  case 136:
#line 795 "parser.yy"
    { current_widget.slider->usable = (yyvsp[0].num); }
    break;

  case 137:
#line 796 "parser.yy"
    { current_widget.slider->disabled = (yyvsp[0].num); }
    break;

  case 138:
#line 797 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 139:
#line 798 "parser.yy"
    { current_widget.slider->feedback = true; }
    break;

  case 140:
#line 799 "parser.yy"
    { current_widget.slider->thumb_id = (yyvsp[0].str); }
    break;

  case 141:
#line 800 "parser.yy"
    { current_widget.slider->background_id = (yyvsp[0].str); }
    break;

  case 142:
#line 801 "parser.yy"
    { current_widget.slider->value = (yyvsp[0].num); }
    break;

  case 143:
#line 802 "parser.yy"
    { current_widget.slider->min_value = (yyvsp[0].num); }
    break;

  case 144:
#line 803 "parser.yy"
    { current_widget.slider->max_value = (yyvsp[0].num); }
    break;

  case 145:
#line 804 "parser.yy"
    { current_widget.slider->page_size = (yyvsp[0].num); }
    break;

  case 146:
#line 810 "parser.yy"
    {
    current_widget.field = dynamic_cast<Widgets::TextField*> (
	current.form->create_widget (Widgets::WIDGET_TEXT_FIELD, (yyvsp[-2].str), true));
    current_widget.field->underline = false;
    current_widget.field->editable = false;
    widget_apply_pos_size (current_widget.field);
}
    break;

  case 147:
#line 816 "parser.yy"
    {
    previous_widget = current_widget.field;
}
    break;

  case 150:
#line 821 "parser.yy"
    { current_widget.field->usable = (yyvsp[0].num); }
    break;

  case 151:
#line 822 "parser.yy"
    { current_widget.field->disabled = (yyvsp[0].num); }
    break;

  case 152:
#line 823 "parser.yy"
    { current_widget.field->font = (yyvsp[0].num); }
    break;

  case 153:
#line 824 "parser.yy"
    { current_widget.field->editable = true; }
    break;

  case 154:
#line 825 "parser.yy"
    { current_widget.field->editable = false; }
    break;

  case 155:
#line 826 "parser.yy"
    { current_widget.field->underline = true; }
    break;

  case 156:
#line 827 "parser.yy"
    { current_widget.field->multi_line = false; }
    break;

  case 157:
#line 828 "parser.yy"
    { current_widget.field->multi_line = true; }
    break;

  case 158:
#line 829 "parser.yy"
    { current_widget.field->dynamic_size = true; }
    break;

  case 159:
#line 830 "parser.yy"
    { current_widget.field->auto_shift = true; }
    break;

  case 160:
#line 831 "parser.yy"
    { current_widget.field->numeric = true; }
    break;

  case 161:
#line 832 "parser.yy"
    { current_widget.field->has_scrollbar = true; }
    break;

  case 162:
#line 833 "parser.yy"
    { current_widget.field->max_length = (yyvsp[0].num); }
    break;

  case 163:
#line 834 "parser.yy"
    { current_widget.field->justify_right = false; }
    break;

  case 164:
#line 835 "parser.yy"
    { current_widget.field->justify_right = true; }
    break;

  case 165:
#line 841 "parser.yy"
    { Form::import_end (); }
    break;

  case 166:
#line 843 "parser.yy"
    {
    previous_widget = 0;
    
    current.form = dynamic_cast<Resources::Form*> (
	manager->create_resource (Resources::RESOURCE_FORM, (yyvsp[-2].str)));
    current.form->x = current_pos_size.x;
    current.form->y = current_pos_size.y;
    current.form->width = current_pos_size.width;
    current.form->height = current_pos_size.height;
}
    break;

  case 169:
#line 855 "parser.yy"
    { current.form->frame = true; }
    break;

  case 170:
#line 856 "parser.yy"
    { current.form->frame = false; }
    break;

  case 171:
#line 857 "parser.yy"
    { /* Do nothing */ }
    break;

  case 172:
#line 858 "parser.yy"
    { current.form->modal = true; }
    break;

  case 173:
#line 859 "parser.yy"
    { current.form->savebehind = true; }
    break;

  case 174:
#line 860 "parser.yy"
    { current.form->savebehind = false; }
    break;

  case 175:
#line 861 "parser.yy"
    { current.form->help_id = (yyvsp[0].str); }
    break;

  case 176:
#line 862 "parser.yy"
    { current.form->menu_id = (yyvsp[0].str); }
    break;

  case 177:
#line 863 "parser.yy"
    { current.form->def_button = (yyvsp[0].str); }
    break;

  case 180:
#line 866 "parser.yy"
    { current.form->title = (yyvsp[0].str); }
    break;

  case 181:
#line 867 "parser.yy"
    { Form::import_popuplist ((yyvsp[-1].str), (yyvsp[0].str)); }
    break;

  case 195:
#line 887 "parser.yy"
    {
    current.dialog = dynamic_cast<Resources::Dialog*> (
	manager->create_resource (Resources::RESOURCE_DIALOG, (yyvsp[0].str)));
}
    break;

  case 199:
#line 894 "parser.yy"
    { current.dialog->default_button = (yyvsp[0].num); }
    break;

  case 200:
#line 895 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_INFORMATION; }
    break;

  case 201:
#line 896 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_CONFIRMATION; }
    break;

  case 202:
#line 897 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_WARNING; }
    break;

  case 203:
#line 898 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_ERROR; }
    break;

  case 204:
#line 899 "parser.yy"
    { current.dialog->help_id = (yyvsp[0].str); }
    break;

  case 207:
#line 903 "parser.yy"
    { current.dialog->title = (yyvsp[0].str); }
    break;

  case 208:
#line 904 "parser.yy"
    { current.dialog->text = (yyvsp[0].str); }
    break;

  case 212:
#line 908 "parser.yy"
    { Dialog::import_button ((yyvsp[0].str)); }
    break;

  case 213:
#line 915 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_STRING, (yyvsp[-1].str));
    Resources::String *str = dynamic_cast<Resources::String*> (res);

    str->text = (yyvsp[0].str);
}
    break;

  case 214:
#line 927 "parser.yy"
    { manager->get_application ()->version = (yyvsp[0].str); }
    break;

  case 215:
#line 928 "parser.yy"
    { manager->get_application ()->version = (yyvsp[0].str); }
    break;

  case 216:
#line 930 "parser.yy"
    {
    manager->get_application ()->iconname = (yyvsp[0].str); }
    break;

  case 217:
#line 937 "parser.yy"
    {
    current.stringlist = dynamic_cast<Resources::StringList*> (
	manager->create_resource (Resources::RESOURCE_STRINGLIST, (yyvsp[-1].str)));

    current.stringlist->prefix = (yyvsp[0].str);
}
    break;

  case 218:
#line 942 "parser.yy"
    { StringList::import_end (); }
    break;

  case 221:
#line 945 "parser.yy"
    { StringList::import_string ((yyvsp[0].str)); }
    break;

  case 222:
#line 952 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAP, (yyvsp[-1].str));
    Resources::Bitmap *bmp = dynamic_cast<Resources::Bitmap*> (res);

    bmp->bitmap_type = current_bitmap_type;
    std::string bitmap_uri = create_child_uri ((yyvsp[0].str));
    if (bitmap_uri != "")
	bmp->load_file (bitmap_uri);
}
    break;

  case 224:
#line 962 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_MONO; }
    break;

  case 225:
#line 963 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_4; }
    break;

  case 226:
#line 964 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_16; }
    break;

  case 227:
#line 965 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16; }
    break;

  case 228:
#line 966 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_256; }
    break;

  case 229:
#line 967 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16K; }
    break;

  case 243:
#line 984 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[-4].str));
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri ((yyvsp[-3].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[-2].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[-1].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[0].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 245:
#line 1000 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[-4].str));
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri ((yyvsp[-3].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[-2].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[-1].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[0].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 247:
#line 1015 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[0].str));
    current.bitmap_family = dynamic_cast<Resources::BitmapFamily*> (res);    
}
    break;

  case 251:
#line 1021 "parser.yy"
    {
    BitmapFamily::import_bitmap ((yyvsp[-2].str), (yyvsp[0].num));
}
    break;

  case 253:
#line 1029 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_MENU, (yyvsp[0].str));
    current.menu = dynamic_cast<Resources::Menu*> (res);
}
    break;

  case 254:
#line 1032 "parser.yy"
    { Menu::import_end (); }
    break;

  case 257:
#line 1035 "parser.yy"
    { Menu::import_menu ((yyvsp[0].str)); }
    break;

  case 261:
#line 1039 "parser.yy"
    { Menu::import_menuitem ((yyvsp[-1].str), (yyvsp[-2].str), (yyvsp[0].str)); }
    break;

  case 262:
#line 1040 "parser.yy"
    { Menu::import_separator (); }
    break;

  case 263:
#line 1041 "parser.yy"
    { Menu::import_menuitem ((yyvsp[0].str), (yyvsp[-1].str)); }
    break;

  case 264:
#line 1047 "parser.yy"
    { (yyval.num) = (yyvsp[-2].num) + (yyvsp[0].num); }
    break;

  case 265:
#line 1048 "parser.yy"
    { (yyval.num) = (yyvsp[-2].num) - (yyvsp[0].num); }
    break;

  case 266:
#line 1049 "parser.yy"
    { (yyval.num) = (yyvsp[-2].num) * (yyvsp[0].num); }
    break;

  case 267:
#line 1050 "parser.yy"
    { (yyval.num) = (yyvsp[-2].num) / (yyvsp[0].num); }
    break;

  case 268:
#line 1051 "parser.yy"
    { (yyval.num) = (yyvsp[-1].num); }
    break;

  case 271:
#line 1055 "parser.yy"
    { (yyval.num) = 0; }
    break;

  case 272:
#line 1056 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->x : 0; }
    break;

  case 273:
#line 1057 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->y : 0; }
    break;

  case 274:
#line 1058 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->x + previous_widget->get_width () : 0;  }
    break;

  case 275:
#line 1059 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->y + previous_widget->get_height () : 0; }
    break;

  case 276:
#line 1060 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->get_width () : 0;  }
    break;

  case 277:
#line 1061 "parser.yy"
    { (yyval.num) = previous_widget ? previous_widget->get_height () : 0; }
    break;


    }

/* Line 1037 of yacc.c.  */
#line 3103 "parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {

		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct ("Error: popping",
                             yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct ("Error: discarding lookahead",
              yytoken, &yylval);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1063 "parser.yy"


const char *yy_token_name(int token_index) {
  int internal_index = YYTRANSLATE(token_index);
  return yytname[internal_index];
}

