//$Id: app-win.h,v 1.16 2005/07/29 09:54:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2005 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_APP_WIN_H
#define GUIKACHU_APP_WIN_H

#include "app-res.h"
#include "resource-win.h"

#include <gtkmm/window.h>
#include <gtkmm/optionmenu.h>
#include <map>
#include "widgets/propertytable.h"

namespace Guikachu
{
    namespace GUI
    {
	class AppWindow: public ResourceWindow,
			 public sigc::trackable
	{
	    Resources::Application *res;
	    Gtk::Window            *window;

	    PropertyTable *proptable;
	    Gtk::Widget   *custom_target_width;
	    Gtk::Widget   *custom_target_height;
            Gtk::Widget   *custom_target_color;

	public:
	    AppWindow (Resources::Application *res);
	    ~AppWindow ();

	    void show ();
	    void hide ();
	private:
	    bool delete_event_impl (GdkEventAny *e);
	    void update ();

	    void stock_target_cb ();
	    void custom_target_cb ();
	};
    };
};

#endif /* !GUIKACHU_APP_WIN_H */
