//$Id: widget-combobox.h,v 1.1 2004/07/19 13:51:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_WIDGET_COMBOBOX_H
#define GUIKACHU_WIDGETS_WIDGET_COMBOBOX_H

#include <gtkmm/combobox.h>
#include <gtkmm/liststore.h>

#include "form-editor/widget.h"

namespace Guikachu
{
    namespace GUI
    {
        class WidgetComboBox: public Gtk::ComboBox
        {
            Gtk::TreeModelColumn<Guikachu::Widget*> col;
            Glib::RefPtr<Gtk::ListStore>            store;

            typedef std::map<Guikachu::Widget*, Gtk::TreeRow> row_map_t;
            row_map_t row_map;

            std::set<Widgets::Type> types;
            
        public:
            WidgetComboBox (const std::set<Widgets::Type> &types,
                            Resources::Form               *form);

            Guikachu::Widget * get_value ();
            void               set_value (Guikachu::Widget *widget);
            
        private:
            void cell_cb (const Gtk::TreeModel::iterator &iter, Gtk::CellRendererText *cell);
            
	    void widget_created_cb (Guikachu::Widget *widget);
	    void widget_removed_cb (Guikachu::Widget *widget);
	    void widget_changed_cb (Gtk::TreeRow row);
        };
    }
}

#endif /* !GUIKACHU_WIDGETS_WIDGET_COMBOBOX_H */
