//$Id: resource-combobox.h,v 1.1 2004/07/19 13:51:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_RESOURCE_COMBOBOX_H
#define GUIKACHU_WIDGETS_RESOURCE_COMBOBOX_H

#include <gtkmm/combobox.h>
#include <gtkmm/liststore.h>

#include "resource.h"

namespace Guikachu
{
    namespace GUI
    {
        class ResourceComboBox: public Gtk::ComboBox
        {
            Gtk::TreeModelColumn<Resource*> col;
            Glib::RefPtr<Gtk::ListStore>    store;            

            typedef std::map<Resource*, Gtk::TreeRow> row_map_t;
            row_map_t row_map;

            std::set<Resources::Type> types;
            
        public:
            ResourceComboBox (const std::set<Resources::Type> &types,
                              ResourceManager                 *manager);

            Resource * get_value ();
            void       set_value (Resource *res);
            
        private:
            void cell_cb (const Gtk::TreeModel::iterator &iter, Gtk::CellRendererText *cell);
            
	    void resource_created_cb (Resource *res);
	    void resource_removed_cb (Resource *res);
	    void resource_changed_cb (Gtk::TreeRow row);
        };
    }
}

#endif /* !GUIKACHU_WIDGETS_RESOURCE_COMBOBOX_H */
