//$Id: mainwin.h,v 1.27 2004/07/15 09:52:50 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_MAINWIN_H
#define GUIKACHU_MAINWIN_H

#include <libgnomeuimm/app.h>
#include <gtkmm/fileselection.h>
#include "resource-tree.h"
#include "resource.h"
#include "resource-manager.h"
#include "resource-tree.h"

namespace Guikachu
{
    namespace GUI
    {
	class MainWin: public Gnome::UI::App
	{
	    ResourceManager *manager;
	    
	    Glib::ustring uri;
	    bool          in_exit;

	    int recent_files_num;

	    ResourceTree resource_tree;
	    
	public:
	    MainWin ();
	    void set_uri     (const Glib::ustring& uri);
	    void set_manager (ResourceManager *manager);
	    
	private:
	    void update_recent_files ();
	    void update_undo ();
	    
	    void update_title ();

	    bool on_delete_event (GdkEventAny *e);

	    void exit_cb ();
	    void undo_cb ();
	    void redo_cb ();
	    
	    void add_cb ();
	    void new_cb ();
	    void load_cb ();
	    void save_cb ();
	    void save_as_cb ();
	    void export_cb ();

	    void cut_cb ();
	    void copy_cb ();
	    void paste_cb ();
	    
	    void preferences_cb ();

	    void open (Glib::ustring uri);
	    
	    bool check_save ();
	};
    }
}

#endif /* !GUIKACHU_MAINWIN_H */
