//$Id: widget-combobox.cc,v 1.1 2004/07/19 13:51:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-combobox.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <vector>
#include "resource-manager.h"

using namespace Guikachu;
using namespace Guikachu::GUI;

WidgetComboBox::WidgetComboBox (const std::set<Widgets::Type> &types_,
                                Resources::Form               *form):
    types (types_)
{
    Gtk::TreeModel::ColumnRecord cols;
    cols.add (col);
    
    store = Gtk::ListStore::create (cols);
    set_model (store);
    
    Gtk::CellRendererText *cell_text = new Gtk::CellRendererText;
    pack_start (*manage (cell_text), true);
    set_cell_data_func (*cell_text, sigc::bind (sigc::mem_fun (*this, &WidgetComboBox::cell_cb), cell_text));

    form->widget_created.connect (sigc::mem_fun (*this, &WidgetComboBox::widget_created_cb));
    form->widget_removed.connect (sigc::mem_fun (*this, &WidgetComboBox::widget_removed_cb));
    
    // Create list items for existing resources
    Gtk::TreeRow row = *(store->append ());
    row[col] = 0;
    row_map[0] = row;
    
    const std::set<Guikachu::Widget*> widgets = form->get_widgets ();
    std::for_each (widgets.begin (), widgets.end (),
                   sigc::mem_fun (*this, &WidgetComboBox::widget_created_cb));
}

Widget * WidgetComboBox::get_value ()
{
    Gtk::TreeModel::iterator iter = get_active ();
    if (!iter)
        return 0;

    return (*iter)[col];
}

void WidgetComboBox::set_value (Guikachu::Widget *widget)
{
    row_map_t::iterator row_found = row_map.find (widget);
    g_return_if_fail (row_found != row_map.end ());

    set_active (row_found->second);
}

void WidgetComboBox::cell_cb (const Gtk::TreeModel::iterator &iter, Gtk::CellRendererText *cell)
{
    g_return_if_fail (cell);

    Guikachu::Widget *widget = (*iter)[col];

    Glib::ustring label = widget ? widget->id () : _("<None>");
    cell->property_text () = label;
}

void WidgetComboBox::widget_removed_cb (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
        return;
    
    row_map_t::iterator row_found = row_map.find (widget);
    g_return_if_fail (row_found != row_map.end ());

    store->erase (row_found->second);
    row_map.erase (row_found);
}

void WidgetComboBox::widget_created_cb (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
        return;
    
    Gtk::TreeRow row = *(store->append ());
    row[col] = widget;
    row_map[widget] = row;
    
    widget->changed.connect (sigc::bind (sigc::mem_fun (*this, &WidgetComboBox::widget_changed_cb), row));
}

void WidgetComboBox::widget_changed_cb (Gtk::TreeRow row)
{
    store->row_changed (store->get_path (row), row);
}
