//$Id: bitmap-res.cc,v 1.14 2004/12/06 16:27:50 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "bitmap-res.h"

#include "io/io.h"
#include "io/bmp-saver.h"

#include <gdkmm/pixbufloader.h>

using namespace Guikachu;

Resources::Bitmap::Bitmap (ResourceManager   *manager,
			   const std::string &id,
			   serial_t           serial):
    Resource (manager, id, serial),
    bitmap_type (changed, TYPE_COLOR_256)
{
}

void Resources::Bitmap::load_file (const Glib::ustring &uri)
{
    unsigned char *data = 0;
    Gnome::Vfs::FileSize len;
    
    try {
        IO::load_uri (uri, data, len);
    } catch (...) {
        delete[] data;
        return;
    }

    load_data (data, len);
    delete[] data;
}

void Resources::Bitmap::load_data (const unsigned char *data, size_t len)
{
    try {
	Glib::RefPtr<Gdk::PixbufLoader> loader = Gdk::PixbufLoader::create ();
	loader->write ((unsigned char*)data, len);
	loader->close ();
	
	ImageData pixbuf = loader->get_pixbuf ();

	set_image (pixbuf);
    } catch (Glib::Exception &e) {
        std::cerr << e.what () << std::endl;
    }
}

void Resources::Bitmap::save_file_bmp (const Glib::ustring &uri) const
{
    if (!image)
	return;

    unsigned char *buf = 0;
    Gnome::Vfs::FileSize len;

    try {
        IO::save_bmp (image, buf, len);
	IO::save_uri (uri, buf, len);
    } catch (Glib::Exception &e) {
        ;
    }

    delete[] buf;
}

void Resources::Bitmap::save_data_png (unsigned char *&data, size_t &len) const
{
    len = 0;
    data = 0;
    
    unsigned char *pixbuf_buf;
    GError *error = 0;
    
    gdk_pixbuf_save_to_buffer (image->gobj (), reinterpret_cast<char**>(&pixbuf_buf), &len,
                               "png", &error, 0);
    if (error)
    {
	g_error_free (error);
	g_free (pixbuf_buf);

        throw Glib::Error (error);        
    }

    data = new unsigned char[len];
    memcpy (data, pixbuf_buf, len);
    g_free (pixbuf_buf);
}

void Resources::Bitmap::save_file_png (const Glib::ustring &uri) const
{
    if (!image)
	return;

    unsigned char *buf = 0;
    size_t len;

    try {
        save_data_png (buf, len);
	IO::save_uri (uri, buf, len);
    } catch (Glib::Exception &e) {
        ;
    }

    delete[] buf;    
}

void Resources::Bitmap::set_image (const ImageData &pixbuf)
{
    image = pixbuf;

    changed.emit ();
}
