
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <foocanvasmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "canvas.h"
#include "group.h"
#include "item.h"
#include "line.h"
#include "polygon.h"
#include "rect-ellipse.h"
#include "rect.h"
#include "ellipse.h"
#include "pixbuf.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType foo_canvas_get_type(void);
GType foo_canvas_ellipse_get_type(void);
GType foo_canvas_group_get_type(void);
GType foo_canvas_item_get_type(void);
GType foo_canvas_line_get_type(void);
GType foo_canvas_pixbuf_get_type(void);
GType foo_canvas_polygon_get_type(void);
GType foo_canvas_rect_get_type(void);
GType foo_canvas_re_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace FooCanvasmm {  class Canvas_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Ellipse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Group_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Item_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Line_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Pixbuf_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Polygon_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class Rect_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace FooCanvasmm {  class RectEllipse_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace FooCanvasmm { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(foo_canvas_get_type(), &FooCanvasmm::Canvas_Class::wrap_new);
  Glib::wrap_register(foo_canvas_ellipse_get_type(), &FooCanvasmm::Ellipse_Class::wrap_new);
  Glib::wrap_register(foo_canvas_group_get_type(), &FooCanvasmm::Group_Class::wrap_new);
  Glib::wrap_register(foo_canvas_item_get_type(), &FooCanvasmm::Item_Class::wrap_new);
  Glib::wrap_register(foo_canvas_line_get_type(), &FooCanvasmm::Line_Class::wrap_new);
  Glib::wrap_register(foo_canvas_pixbuf_get_type(), &FooCanvasmm::Pixbuf_Class::wrap_new);
  Glib::wrap_register(foo_canvas_polygon_get_type(), &FooCanvasmm::Polygon_Class::wrap_new);
  Glib::wrap_register(foo_canvas_rect_get_type(), &FooCanvasmm::Rect_Class::wrap_new);
  Glib::wrap_register(foo_canvas_re_get_type(), &FooCanvasmm::RectEllipse_Class::wrap_new);

  // Register the gtkmm gtypes:
  FooCanvasmm::Canvas::get_type();
  FooCanvasmm::Ellipse::get_type();
  FooCanvasmm::Group::get_type();
  FooCanvasmm::Item::get_type();
  FooCanvasmm::Line::get_type();
  FooCanvasmm::Pixbuf::get_type();
  FooCanvasmm::Polygon::get_type();
  FooCanvasmm::Rect::get_type();
  FooCanvasmm::RectEllipse::get_type();

} // wrap_init()

} //FooCanvasmm


