//$Id: resource-combobox.cc,v 1.1 2004/07/19 13:51:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resource-combobox.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <vector>
#include "resource-manager.h"

using namespace Guikachu;
using namespace Guikachu::GUI;

ResourceComboBox::ResourceComboBox (const std::set<Resources::Type> &types_,
                                    ResourceManager                 *manager):
    types (types_)
{
    Gtk::TreeModel::ColumnRecord cols;
    cols.add (col);
    
    store = Gtk::ListStore::create (cols);
    set_model (store);
    
    Gtk::CellRendererText *cell_text = new Gtk::CellRendererText;
    pack_start (*manage (cell_text), true);
    set_cell_data_func (*cell_text, sigc::bind (sigc::mem_fun (*this, &ResourceComboBox::cell_cb), cell_text));

    manager->resource_created.connect (sigc::mem_fun (*this, &ResourceComboBox::resource_created_cb));
    manager->resource_removed.connect (sigc::mem_fun (*this, &ResourceComboBox::resource_removed_cb));
    
    // Create list items for existing resources
    Gtk::TreeRow row = *(store->append ());
    row[col] = 0;
    row_map[0] = row;
    
    const std::set<Resource*> resources = manager->get_resources ();
    std::for_each (resources.begin (), resources.end (),
                   sigc::mem_fun (*this, &ResourceComboBox::resource_created_cb));
}

Resource * ResourceComboBox::get_value ()
{
    Gtk::TreeModel::iterator iter = get_active ();
    if (!iter)
        return 0;

    return (*iter)[col];
}

void ResourceComboBox::set_value (Resource *res)
{
    row_map_t::iterator row_found = row_map.find (res);
    g_return_if_fail (row_found != row_map.end ());

    set_active (row_found->second);
}

void ResourceComboBox::cell_cb (const Gtk::TreeModel::iterator &iter, Gtk::CellRendererText *cell)
{
    g_return_if_fail (cell);

    Resource *res = (*iter)[col];

    Glib::ustring label = res ? res->id () : _("<None>");
    cell->property_text () = label;
}

void ResourceComboBox::resource_removed_cb (Resource *res)
{
    if (types.find (res->get_type ()) == types.end ())
        return;
    
    row_map_t::iterator row_found = row_map.find (res);
    g_return_if_fail (row_found != row_map.end ());

    store->erase (row_found->second);
    row_map.erase (row_found);
}

void ResourceComboBox::resource_created_cb (Resource *res)
{
    if (types.find (res->get_type ()) == types.end ())
        return;
    
    Gtk::TreeRow row = *(store->append ());
    row[col] = res;
    row_map[res] = row;
    
    res->changed.connect (sigc::bind (sigc::mem_fun (*this, &ResourceComboBox::resource_changed_cb), row));
}

void ResourceComboBox::resource_changed_cb (Gtk::TreeRow row)
{
    store->row_changed (store->get_path (row), row);
}
