/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID_TOKEN = 258,
     AUTOID = 259,
     BEG = 260,
     END = 261,
     LBRACE = 262,
     RBRACE = 263,
     HELPID = 264,
     MENUID = 265,
     DEFAULTBTNID = 266,
     APPLICATIONICONNAME = 267,
     ALERT = 268,
     MENU = 269,
     STRING = 270,
     STRINGTABLE = 271,
     BITMAP = 272,
     BITMAPFAMILY = 273,
     DIALOG_CONFIRMATION = 274,
     DIALOG_INFORMATION = 275,
     DIALOG_WARNING = 276,
     DIALOG_ERROR = 277,
     BUTTON = 278,
     POPUPTRIGGER = 279,
     REPEATBUTTON = 280,
     CHECKBOX = 281,
     SELECTORTRIGGER = 282,
     LABEL = 283,
     PUSHBUTTON = 284,
     GRAFFITISTATEINDICATOR = 285,
     FIELD = 286,
     LIST = 287,
     FORMBITMAP = 288,
     GADGET = 289,
     POPUPLIST = 290,
     TABLE = 291,
     SCROLLBAR = 292,
     AUTO = 293,
     USABLE = 294,
     NONUSABLE = 295,
     DISABLED = 296,
     LEFTANCHOR = 297,
     RIGHTANCHOR = 298,
     FRAME = 299,
     NOFRAME = 300,
     BOLDFRAME = 301,
     LEFTALIGN = 302,
     RIGHTALIGN = 303,
     NUMERIC = 304,
     AUTOSHIFT = 305,
     HASSCROLLBAR = 306,
     VISIBLEITEMS = 307,
     SEARCH = 308,
     ROWS = 309,
     COLUMNS = 310,
     COLUMNWIDTHS = 311,
     VALUE = 312,
     MIN_VAL = 313,
     MAX_VAL = 314,
     PAGESIZE = 315,
     GRAPHICAL = 316,
     BITMAPID = 317,
     SELECTEDBITMAPID = 318,
     BITMAPGREY = 319,
     BITMAPGREY16 = 320,
     BITMAPCOLOR16 = 321,
     BITMAPCOLOR = 322,
     BITMAPCOLOR16K = 323,
     BITMAPFAMILYSPECIAL = 324,
     BITMAPFAMILYEX = 325,
     COMPRESS = 326,
     NOCOMPRESS = 327,
     FORCECOMPRESS = 328,
     COLORTABLE = 329,
     NOCOLORTABLE = 330,
     TRANSPARENT = 331,
     TRANSPARENTINDEX = 332,
     DENSITY = 333,
     BPP = 334,
     AT = 335,
     BUTTONS = 336,
     CHECKED = 337,
     DEFAULTBUTTON = 338,
     DYNAMICSIZE = 339,
     EDITABLE = 340,
     FONT = 341,
     FORM = 342,
     GROUP = 343,
     MAXCHARS = 344,
     MENUITEM = 345,
     MESSAGE = 346,
     MODAL = 347,
     MULTIPLELINES = 348,
     NONEDITABLE = 349,
     NOSAVEBEHIND = 350,
     PULLDOWN = 351,
     SAVEBEHIND = 352,
     SEPARATOR = 353,
     SINGLELINE = 354,
     TITLE = 355,
     UNDERLINED = 356,
     VERSION_TOKEN = 357,
     CENTER = 358,
     PREVLEFT = 359,
     PREVRIGHT = 360,
     PREVTOP = 361,
     PREVBOTTOM = 362,
     PREVWIDTH = 363,
     PREVHEIGHT = 364,
     QUOTESTRING = 365,
     WORD = 366,
     PLUS = 367,
     MINUS = 368,
     TIMES = 369,
     DIV = 370,
     NUMBER = 371
   };
#endif
#define ID_TOKEN 258
#define AUTOID 259
#define BEG 260
#define END 261
#define LBRACE 262
#define RBRACE 263
#define HELPID 264
#define MENUID 265
#define DEFAULTBTNID 266
#define APPLICATIONICONNAME 267
#define ALERT 268
#define MENU 269
#define STRING 270
#define STRINGTABLE 271
#define BITMAP 272
#define BITMAPFAMILY 273
#define DIALOG_CONFIRMATION 274
#define DIALOG_INFORMATION 275
#define DIALOG_WARNING 276
#define DIALOG_ERROR 277
#define BUTTON 278
#define POPUPTRIGGER 279
#define REPEATBUTTON 280
#define CHECKBOX 281
#define SELECTORTRIGGER 282
#define LABEL 283
#define PUSHBUTTON 284
#define GRAFFITISTATEINDICATOR 285
#define FIELD 286
#define LIST 287
#define FORMBITMAP 288
#define GADGET 289
#define POPUPLIST 290
#define TABLE 291
#define SCROLLBAR 292
#define AUTO 293
#define USABLE 294
#define NONUSABLE 295
#define DISABLED 296
#define LEFTANCHOR 297
#define RIGHTANCHOR 298
#define FRAME 299
#define NOFRAME 300
#define BOLDFRAME 301
#define LEFTALIGN 302
#define RIGHTALIGN 303
#define NUMERIC 304
#define AUTOSHIFT 305
#define HASSCROLLBAR 306
#define VISIBLEITEMS 307
#define SEARCH 308
#define ROWS 309
#define COLUMNS 310
#define COLUMNWIDTHS 311
#define VALUE 312
#define MIN_VAL 313
#define MAX_VAL 314
#define PAGESIZE 315
#define GRAPHICAL 316
#define BITMAPID 317
#define SELECTEDBITMAPID 318
#define BITMAPGREY 319
#define BITMAPGREY16 320
#define BITMAPCOLOR16 321
#define BITMAPCOLOR 322
#define BITMAPCOLOR16K 323
#define BITMAPFAMILYSPECIAL 324
#define BITMAPFAMILYEX 325
#define COMPRESS 326
#define NOCOMPRESS 327
#define FORCECOMPRESS 328
#define COLORTABLE 329
#define NOCOLORTABLE 330
#define TRANSPARENT 331
#define TRANSPARENTINDEX 332
#define DENSITY 333
#define BPP 334
#define AT 335
#define BUTTONS 336
#define CHECKED 337
#define DEFAULTBUTTON 338
#define DYNAMICSIZE 339
#define EDITABLE 340
#define FONT 341
#define FORM 342
#define GROUP 343
#define MAXCHARS 344
#define MENUITEM 345
#define MESSAGE 346
#define MODAL 347
#define MULTIPLELINES 348
#define NONEDITABLE 349
#define NOSAVEBEHIND 350
#define PULLDOWN 351
#define SAVEBEHIND 352
#define SEPARATOR 353
#define SINGLELINE 354
#define TITLE 355
#define UNDERLINED 356
#define VERSION_TOKEN 357
#define CENTER 358
#define PREVLEFT 359
#define PREVRIGHT 360
#define PREVTOP 361
#define PREVBOTTOM 362
#define PREVWIDTH 363
#define PREVHEIGHT 364
#define QUOTESTRING 365
#define WORD 366
#define PLUS 367
#define MINUS 368
#define TIMES 369
#define DIV 370
#define NUMBER 371




/* Copy the first part of user declarations.  */
#line 19 "parser.yy"


#define YYERROR_VERBOSE

#include "parser-interface.h"
    
#include "config.h"
#include <libgnome/libgnome.h>
    
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "io/io.h"
    
#include "resource-manager.h"

#include "string-res.h"
#include "stringlist-res.h"
#include "dialog-res.h"
#include "form-res.h"
#include "menu-res.h"
#include "bitmap-res.h"
#include "bitmapfamily-res.h"

#include "form-editor/label.h"
#include "form-editor/checkbox.h"
#include "form-editor/button.h"    
#include "form-editor/pushbutton.h"
#include "form-editor/selector-trigger.h"
#include "form-editor/popup-trigger.h"
#include "form-editor/graffiti.h"
#include "form-editor/text-field.h"
#include "form-editor/list.h"
#include "form-editor/table.h"
#include "form-editor/scrollbar.h"
#include "form-editor/formbitmap.h"

#include <libgnomevfsmm/uri.h>
    
    extern int yylex();
    extern int lexer_lineno;
    extern char *yytext;

    extern struct yy_buffer_state* yy_scan_bytes (const char *bytes, int len);
    extern void yypop_buffer_state ();
    
    using namespace Guikachu;
    using namespace Guikachu::IO;

    namespace Guikachu
    {
	namespace IO
	{
	    namespace RCP
	    {
		std::string error;
		
		void setup (ResourceManager *manager, const std::string &uri);
		void finish ();
	    }
	}
    }
    
    namespace
    {
	ResourceManager               *manager;
	Glib::RefPtr<Gnome::Vfs::Uri>  base_uri;
	
	union
	{
	    Resources::Dialog       *dialog;
	    Resources::Menu         *menu;
	    Resources::StringList   *stringlist;
	    Resources::Form         *form;
	    Resources::BitmapFamily *bitmap_family;
	} current;

	union
	{
	    Widgets::Button          *button;
	    Widgets::Checkbox        *checkbox;
	    Widgets::Label           *label;
	    Widgets::PushButton      *pushbutton;
	    Widgets::SelectorTrigger *strigger;
	    Widgets::PopupTrigger    *ptrigger;
	    Widgets::TextField       *field;
	    Widgets::List            *lst;
	    Widgets::Table           *table;
	    Widgets::ScrollBar       *scrollbar;
            Widgets::FormBitmap      *bitmap;
	} current_widget;

	Widget *previous_widget;
	
	struct
	{
	    int  x;
	    int  y;
	    int  width;
            bool width_auto;
	    int  height;
            bool height_auto;
	} current_pos_size;

        Resources::Bitmap::BitmapType current_bitmap_type;

	Glib::ustring create_child_uri (const Glib::ustring child)
	{
            Glib::RefPtr<Gnome::Vfs::Uri> child_uri = base_uri->append_path (child);
            return child_uri->to_string ();
	}
	
	namespace StringList
	{
	    std::vector<std::string> strings;

	    void import_string (const std::string &button)
	    {
		strings.push_back (button);
	    }
	    
	    void import_end ()
	    {
		current.stringlist->strings = strings;
		strings.clear ();
	    }
	}

	namespace Dialog
	{
	    void import_button (const std::string &button)
	    {
		std::vector<std::string> buttons = current.dialog->buttons;
		buttons.push_back (button);
		current.dialog->buttons = buttons;
	    }
	}

	namespace BitmapFamily
	{
	    void import_bitmap (const std::string &bitmap_filename,
				int                bitmap_bpp)
	    {
		Glib::ustring bitmap_uri = create_child_uri (bitmap_filename);
		
		Resources::Bitmap::BitmapType type = Resources::Bitmap::TYPE_COLOR_256;
		switch (bitmap_bpp)
		{
		case 1:
		    type = Resources::Bitmap::TYPE_MONO;
		    break;
		case 2:
		    type = Resources::Bitmap::TYPE_GREY_4;
		    break;
		case 4:
		    type = Resources::Bitmap::TYPE_GREY_16;
		    break;
		case 5:
		    type = Resources::Bitmap::TYPE_COLOR_16;
		    break;
		case 8:
		    type = Resources::Bitmap::TYPE_COLOR_256;
		    break;
		case 16:
		    type = Resources::Bitmap::TYPE_COLOR_16K;
		    break;
		default:
		    /* WRITE ME */
		    break;
		}
		
		current.bitmap_family->load_file (type, bitmap_uri);
	    }
	}
	
	namespace Menu
	{
	    Resources::Menu::MenuTree submenus;
	    
	    void import_end ()
	    {
		current.menu->set_submenus (submenus);
		submenus.clear ();
	    }

	    void import_menu (const std::string &menu_label)
	    {
		submenus.push_back (Resources::Menu::Submenu (menu_label));
	    }
	    
	    void import_menuitem (const std::string &id, const std::string &label,
				  const std::string &shortcut = "")
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item = { false, id, label, shortcut[0]};
		submenu.items.push_back (item);
	    }

	    void import_separator ()
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item;
		
		item.separator = true;
		submenu.items.push_back (item);
	    }
	}

	namespace Form
	{
	    typedef std::map<std::string, std::string> popuplist_map_t;
	    popuplist_map_t popuplist_map;
	    
	    void import_popuplist (const std::string &popup_id,
				   const std::string &list_id)
	    {
		popuplist_map[popup_id] = list_id;
	    }
	    
	    void import_end ()
	    {
		for (popuplist_map_t::const_iterator i = popuplist_map.begin ();
		     i != popuplist_map.end (); ++i)
		{
		    Widget *widget = current.form->get_widget (i->first);
		    Widgets::PopupTrigger *ptrigger = dynamic_cast<Widgets::PopupTrigger*> (widget);
		    if (ptrigger)
			ptrigger->list_id = i->second;
		}		
		
		popuplist_map.clear ();
	    }
	}

	namespace List
	{
	    std::vector<std::string> items;

	    void import_item (const std::string &item)
	    {
		items.push_back (item);
	    }

	    void apply_items ()
	    {
		current_widget.lst->items = items;
		items.clear ();
	    }
	}

	namespace Table
	{
	    std::vector<int> cols;

	    void import_col (int col)
	    {
		cols.push_back (col);
	    }

	    void import_end ()
	    {
		current_widget.table->column_width = cols;
		cols.clear ();
	    }
	}
	
	void widget_apply_pos (Widget *widget)
	{
	    widget->x = current_pos_size.x;
	    widget->y = current_pos_size.y;
	}
	    
	void widget_apply_pos_size (Widget *widget)
	{
	    widget_apply_pos (widget);

	    Widgets::ResizeableWidget *resizeable =
		dynamic_cast<Widgets::ResizeableWidget*> (widget);

            if (!current_pos_size.width_auto)
		resizeable->width = current_pos_size.width;
            if (!current_pos_size.height_auto)
		resizeable->width = current_pos_size.height;
        }
    }
    
    void RCP::setup (ResourceManager *manager_, const Glib::ustring &uri)
    {
	manager = manager_;
	error = "";

	// Store base URI
        Glib::RefPtr<Gnome::Vfs::Uri> orig_uri = Gnome::Vfs::Uri::create (uri);
	base_uri = orig_uri->get_parent ();
    }

    void RCP::finish ()
    {
	yypop_buffer_state ();
    }
    
    /* parse errors */
    void yyerror(const char *s) {
	char *buffer = g_strdup_printf (_("%s at line %d near `%s'"),
					s, lexer_lineno, yytext);
	IO::RCP::error = buffer;
	g_free (buffer);
    }




/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 332 "parser.yy"
typedef union YYSTYPE {
    char *str;
    int   num;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 626 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 638 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   401

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  117
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  108
/* YYNRULES -- Number of rules. */
#define YYNRULES  251
/* YYNRULES -- Number of states. */
#define YYNSTATES  397

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   371

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     6,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    30,    32,    34,    37,    40,
      43,    45,    47,    49,    51,    53,    58,    65,    72,    74,
      76,    78,    80,    81,    89,    92,    93,    95,    97,    99,
     101,   102,   110,   113,   114,   116,   118,   120,   123,   125,
     126,   134,   137,   138,   140,   142,   144,   146,   147,   155,
     158,   159,   161,   163,   164,   172,   175,   176,   178,   180,
     182,   185,   187,   188,   194,   198,   202,   205,   206,   208,
     210,   212,   214,   216,   218,   220,   221,   227,   230,   231,
     234,   236,   240,   241,   248,   251,   252,   255,   258,   261,
     264,   265,   267,   268,   276,   279,   280,   282,   285,   286,
     288,   290,   293,   295,   296,   303,   306,   307,   309,   312,
     315,   318,   321,   322,   329,   332,   333,   335,   337,   339,
     341,   343,   345,   347,   349,   351,   353,   355,   358,   360,
     362,   368,   373,   376,   377,   379,   381,   383,   385,   387,
     389,   392,   395,   398,   401,   402,   405,   409,   411,   413,
     415,   417,   419,   421,   423,   425,   427,   429,   431,   433,
     434,   442,   445,   446,   449,   451,   453,   455,   457,   460,
     463,   464,   467,   470,   473,   476,   477,   479,   483,   487,
     490,   494,   495,   501,   504,   505,   507,   508,   514,   516,
     518,   520,   522,   524,   526,   529,   530,   532,   534,   536,
     538,   540,   545,   548,   551,   553,   555,   557,   558,   567,
     568,   577,   578,   585,   588,   589,   590,   597,   598,   605,
     608,   609,   610,   617,   620,   621,   626,   629,   633,   637,
     641,   645,   649,   653,   655,   657,   659,   661,   663,   665,
     667,   669
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     118,     0,    -1,   118,   119,    -1,    -1,   180,    -1,   194,
      -1,   197,    -1,   195,    -1,   196,    -1,   186,    -1,   201,
      -1,   206,    -1,   216,    -1,   111,    -1,     3,   111,    -1,
       4,    -1,    61,    -1,    62,   111,    -1,    63,   111,    -1,
      86,   116,    -1,    39,    -1,    40,    -1,    41,    -1,    42,
      -1,    43,    -1,     7,   223,   223,     8,    -1,     7,   223,
     223,   128,   129,     8,    -1,     7,   223,   223,   223,   223,
       8,    -1,   223,    -1,    38,    -1,   223,    -1,    38,    -1,
      -1,    24,   110,   120,    80,   126,   131,   132,    -1,   132,
     133,    -1,    -1,   122,    -1,   123,    -1,   124,    -1,   121,
      -1,    -1,    26,   110,   120,    80,   126,   135,   136,    -1,
     136,   137,    -1,    -1,   122,    -1,   123,    -1,   124,    -1,
      88,   116,    -1,    82,    -1,    -1,    27,   110,   120,    80,
     126,   139,   140,    -1,   140,   141,    -1,    -1,   122,    -1,
     124,    -1,   123,    -1,   121,    -1,    -1,    28,   110,   120,
      80,   125,   143,   144,    -1,   144,   145,    -1,    -1,   122,
      -1,   123,    -1,    -1,    29,   110,   120,    80,   126,   147,
     148,    -1,   148,   149,    -1,    -1,   122,    -1,   123,    -1,
     124,    -1,    88,   116,    -1,   121,    -1,    -1,   152,    80,
     126,   151,   153,    -1,    23,   110,   120,    -1,    25,   110,
     120,    -1,   153,   154,    -1,    -1,   122,    -1,   123,    -1,
      45,    -1,    44,    -1,    46,    -1,   124,    -1,   121,    -1,
      -1,    33,    80,   125,   156,   157,    -1,   158,   157,    -1,
      -1,    17,   111,    -1,   123,    -1,    30,    80,   125,    -1,
      -1,    36,   120,    80,   126,   161,   162,    -1,   163,   162,
      -1,    -1,    54,   116,    -1,    55,   116,    -1,    56,   164,
      -1,   165,   164,    -1,    -1,   116,    -1,    -1,    32,   168,
     120,    80,   126,   167,   170,    -1,   169,   168,    -1,    -1,
     110,    -1,   171,   170,    -1,    -1,   123,    -1,   122,    -1,
      52,   116,    -1,    53,    -1,    -1,    35,   120,    80,   126,
     173,   174,    -1,   175,   174,    -1,    -1,   123,    -1,    57,
     116,    -1,    58,   116,    -1,    59,   116,    -1,    60,   116,
      -1,    -1,    31,   120,    80,   126,   177,   178,    -1,   179,
     178,    -1,    -1,   123,    -1,   122,    -1,    85,    -1,    94,
      -1,   101,    -1,    99,    -1,    93,    -1,    84,    -1,    50,
      -1,    49,    -1,    51,    -1,    89,   116,    -1,    47,    -1,
      48,    -1,   181,   182,     5,   184,     6,    -1,    87,   120,
      80,   127,    -1,   182,   183,    -1,    -1,    44,    -1,    45,
      -1,    39,    -1,    92,    -1,    97,    -1,    95,    -1,     9,
     111,    -1,    10,   111,    -1,    11,   111,    -1,   184,   185,
      -1,    -1,   100,   110,    -1,    35,   120,   111,    -1,   150,
      -1,   146,    -1,   142,    -1,   138,    -1,   130,    -1,   176,
      -1,   134,    -1,   159,    -1,   160,    -1,   172,    -1,   166,
      -1,   155,    -1,    -1,    13,   120,   187,   188,     5,   190,
       6,    -1,   188,   189,    -1,    -1,    83,   223,    -1,    20,
      -1,    19,    -1,    21,    -1,    22,    -1,     9,   120,    -1,
     190,   191,    -1,    -1,   100,   110,    -1,    91,   110,    -1,
      81,   192,    -1,   192,   193,    -1,    -1,   110,    -1,    15,
     120,   110,    -1,   102,   120,   110,    -1,   102,   110,    -1,
      12,   120,   110,    -1,    -1,    16,   120,   110,   198,   199,
      -1,   200,   199,    -1,    -1,   110,    -1,    -1,   203,   120,
     110,   202,   204,    -1,    17,    -1,    64,    -1,    65,    -1,
      66,    -1,    67,    -1,    68,    -1,   205,   204,    -1,    -1,
      72,    -1,    71,    -1,    73,    -1,    75,    -1,    74,    -1,
      76,   116,   116,   116,    -1,    77,   111,    -1,    78,   111,
      -1,   207,    -1,   209,    -1,   211,    -1,    -1,    18,   120,
     110,   110,   110,   110,   208,   204,    -1,    -1,    69,   120,
     110,   110,   110,   110,   210,   204,    -1,    -1,    70,   120,
     212,     5,   213,     6,    -1,   214,   213,    -1,    -1,    -1,
      17,   110,    79,   116,   215,   204,    -1,    -1,    14,   120,
     217,     5,   218,     6,    -1,   219,   218,    -1,    -1,    -1,
      96,   110,   220,     5,   221,     6,    -1,   221,   222,    -1,
      -1,    90,   110,   120,   110,    -1,    90,    98,    -1,    90,
     110,   120,    -1,   223,   112,   223,    -1,   223,   113,   223,
      -1,   223,   114,   223,    -1,   223,   115,   223,    -1,     7,
     223,     8,    -1,   224,    -1,   116,    -1,   103,    -1,   104,
      -1,   106,    -1,   105,    -1,   107,    -1,   108,    -1,   109,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   485,   485,   485,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   500,   500,   500,   506,   507,   508,   510,
     511,   511,   511,   512,   512,   514,   519,   524,   535,   536,
     538,   539,   546,   546,   555,   555,   556,   557,   558,   559,
     566,   566,   575,   575,   576,   577,   578,   579,   580,   588,
     588,   597,   597,   598,   599,   600,   601,   608,   608,   617,
     617,   618,   619,   627,   627,   636,   636,   637,   638,   639,
     640,   641,   648,   648,   654,   658,   665,   665,   666,   667,
     668,   669,   670,   671,   672,   679,   679,   687,   687,   688,
     689,   696,   708,   708,   714,   714,   715,   716,   717,   719,
     719,   720,   727,   727,   736,   736,   737,   741,   741,   742,
     743,   744,   745,   752,   752,   760,   760,   761,   762,   763,
     764,   765,   771,   771,   781,   781,   782,   783,   784,   785,
     786,   787,   788,   789,   790,   791,   792,   793,   794,   795,
     801,   803,   814,   814,   815,   816,   817,   818,   819,   820,
     821,   822,   823,   825,   825,   826,   827,   828,   829,   830,
     831,   832,   833,   834,   835,   836,   837,   838,   839,   846,
     846,   852,   852,   853,   854,   855,   856,   857,   858,   861,
     861,   862,   863,   864,   866,   866,   867,   874,   886,   887,
     889,   896,   896,   903,   903,   904,   911,   911,   921,   922,
     923,   924,   925,   926,   929,   929,   930,   930,   930,   931,
     931,   932,   933,   934,   941,   941,   941,   943,   942,   959,
     958,   974,   974,   979,   979,   980,   980,   988,   988,   993,
     993,   994,   994,   997,   997,   998,   999,  1000,  1006,  1007,
    1008,  1009,  1010,  1011,  1013,  1014,  1015,  1016,  1017,  1018,
    1019,  1020
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID_TOKEN", "AUTOID", "BEG", "END", 
  "LBRACE", "RBRACE", "HELPID", "MENUID", "DEFAULTBTNID", 
  "APPLICATIONICONNAME", "ALERT", "MENU", "STRING", "STRINGTABLE", 
  "BITMAP", "BITMAPFAMILY", "DIALOG_CONFIRMATION", "DIALOG_INFORMATION", 
  "DIALOG_WARNING", "DIALOG_ERROR", "BUTTON", "POPUPTRIGGER", 
  "REPEATBUTTON", "CHECKBOX", "SELECTORTRIGGER", "LABEL", "PUSHBUTTON", 
  "GRAFFITISTATEINDICATOR", "FIELD", "LIST", "FORMBITMAP", "GADGET", 
  "POPUPLIST", "TABLE", "SCROLLBAR", "AUTO", "USABLE", "NONUSABLE", 
  "DISABLED", "LEFTANCHOR", "RIGHTANCHOR", "FRAME", "NOFRAME", 
  "BOLDFRAME", "LEFTALIGN", "RIGHTALIGN", "NUMERIC", "AUTOSHIFT", 
  "HASSCROLLBAR", "VISIBLEITEMS", "SEARCH", "ROWS", "COLUMNS", 
  "COLUMNWIDTHS", "VALUE", "MIN_VAL", "MAX_VAL", "PAGESIZE", "GRAPHICAL", 
  "BITMAPID", "SELECTEDBITMAPID", "BITMAPGREY", "BITMAPGREY16", 
  "BITMAPCOLOR16", "BITMAPCOLOR", "BITMAPCOLOR16K", "BITMAPFAMILYSPECIAL", 
  "BITMAPFAMILYEX", "COMPRESS", "NOCOMPRESS", "FORCECOMPRESS", 
  "COLORTABLE", "NOCOLORTABLE", "TRANSPARENT", "TRANSPARENTINDEX", 
  "DENSITY", "BPP", "AT", "BUTTONS", "CHECKED", "DEFAULTBUTTON", 
  "DYNAMICSIZE", "EDITABLE", "FONT", "FORM", "GROUP", "MAXCHARS", 
  "MENUITEM", "MESSAGE", "MODAL", "MULTIPLELINES", "NONEDITABLE", 
  "NOSAVEBEHIND", "PULLDOWN", "SAVEBEHIND", "SEPARATOR", "SINGLELINE", 
  "TITLE", "UNDERLINED", "VERSION_TOKEN", "CENTER", "PREVLEFT", 
  "PREVRIGHT", "PREVTOP", "PREVBOTTOM", "PREVWIDTH", "PREVHEIGHT", 
  "QUOTESTRING", "WORD", "PLUS", "MINUS", "TIMES", "DIV", "NUMBER", 
  "$accept", "rcpfile", "resource", "identifier", "widget_prop_graphical", 
  "widget_prop_font", "widget_prop_usable", "widget_prop_anchor", 
  "POSITION", "POS_SIZE", "FORM_POS_SIZE", "hsize", "vsize", 
  "widget_ptrigger", "@1", "widget_ptrigger_options", 
  "widget_ptrigger_option", "widget_checkbox", "@2", 
  "widget_checkbox_options", "widget_checkbox_option", "widget_strigger", 
  "@3", "widget_strigger_options", "widget_strigger_option", 
  "widget_label", "@4", "widget_label_options", "widget_label_option", 
  "widget_pushbutton", "@5", "widget_pushbutton_options", 
  "widget_pushbutton_option", "widget_button", "@6", 
  "widget_button_begin", "widget_button_options", "widget_button_option", 
  "widget_bitmap", "@7", "widget_bitmap_options", "widget_bitmap_option", 
  "widget_graffiti", "widget_table", "@8", "widget_table_options", 
  "widget_table_option", "widget_table_cols", "widget_table_col", 
  "widget_list", "@9", "widget_list_items", "widget_list_item", 
  "widget_list_options", "widget_list_option", "widget_scrollbar", "@10", 
  "widget_scrollbar_options", "widget_scrollbar_option", "widget_field", 
  "@11", "widget_field_options", "widget_field_option", "res_form", 
  "res_form_start", "res_form_options", "res_form_option", 
  "res_form_children", "res_form_child", "res_dialog", "@12", 
  "res_dialog_options", "res_dialog_option", "res_dialog_children", 
  "res_dialog_child", "res_dialog_buttons", "res_dialog_button", 
  "res_string", "res_app_ver", "res_app_name", "res_stringlist", "@13", 
  "res_stringlist_strings", "res_stringlist_string", "res_bitmap", "@14", 
  "res_bitmap_type", "res_bitmap_options", "res_bitmap_option", 
  "res_bitmapfamily", "res_bitmapfamily_def", "@15", 
  "res_bitmapfamily_special", "@16", "res_bitmapfamily_ex", "@17", 
  "res_bitmapfamily_children", "res_bitmapfamily_child", "@18", 
  "res_menu", "@19", "res_menu_menus", "res_menu_menu", "@20", 
  "res_menu_children", "res_menu_child", "expr", "expr_atom", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,   117,   118,   118,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   120,   120,   120,   121,   121,   121,   122,
     123,   123,   123,   124,   124,   125,   126,   127,   128,   128,
     129,   129,   131,   130,   132,   132,   133,   133,   133,   133,
     135,   134,   136,   136,   137,   137,   137,   137,   137,   139,
     138,   140,   140,   141,   141,   141,   141,   143,   142,   144,
     144,   145,   145,   147,   146,   148,   148,   149,   149,   149,
     149,   149,   151,   150,   152,   152,   153,   153,   154,   154,
     154,   154,   154,   154,   154,   156,   155,   157,   157,   158,
     158,   159,   161,   160,   162,   162,   163,   163,   163,   164,
     164,   165,   167,   166,   168,   168,   169,   170,   170,   171,
     171,   171,   171,   173,   172,   174,   174,   175,   175,   175,
     175,   175,   177,   176,   178,   178,   179,   179,   179,   179,
     179,   179,   179,   179,   179,   179,   179,   179,   179,   179,
     180,   181,   182,   182,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   184,   184,   185,   185,   185,   185,   185,
     185,   185,   185,   185,   185,   185,   185,   185,   185,   187,
     186,   188,   188,   189,   189,   189,   189,   189,   189,   190,
     190,   191,   191,   191,   192,   192,   193,   194,   195,   195,
     196,   198,   197,   199,   199,   200,   202,   201,   203,   203,
     203,   203,   203,   203,   204,   204,   205,   205,   205,   205,
     205,   205,   205,   205,   206,   206,   206,   208,   207,   210,
     209,   212,   211,   213,   213,   215,   214,   217,   216,   218,
     218,   220,   219,   221,   221,   222,   222,   222,   223,   223,
     223,   223,   223,   223,   224,   224,   224,   224,   224,   224,
     224,   224
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     4,     6,     6,     1,     1,
       1,     1,     0,     7,     2,     0,     1,     1,     1,     1,
       0,     7,     2,     0,     1,     1,     1,     2,     1,     0,
       7,     2,     0,     1,     1,     1,     1,     0,     7,     2,
       0,     1,     1,     0,     7,     2,     0,     1,     1,     1,
       2,     1,     0,     5,     3,     3,     2,     0,     1,     1,
       1,     1,     1,     1,     1,     0,     5,     2,     0,     2,
       1,     3,     0,     6,     2,     0,     2,     2,     2,     2,
       0,     1,     0,     7,     2,     0,     1,     2,     0,     1,
       1,     2,     1,     0,     6,     2,     0,     1,     2,     2,
       2,     2,     0,     6,     2,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     4,     2,     0,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     0,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       7,     2,     0,     2,     1,     1,     1,     1,     2,     2,
       0,     2,     2,     2,     2,     0,     1,     3,     3,     2,
       3,     0,     5,     2,     0,     1,     0,     5,     1,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     1,     1,
       1,     4,     2,     2,     1,     1,     1,     0,     8,     0,
       8,     0,     6,     2,     0,     0,     6,     0,     6,     2,
       0,     0,     6,     2,     0,     4,     2,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       3,     0,     1,     0,     0,     0,     0,     0,   198,     0,
     199,   200,   201,   202,   203,     0,     0,     0,     0,     2,
       4,   143,     9,     5,     7,     8,     6,    10,     0,    11,
     214,   215,   216,    12,     0,    15,    13,     0,   169,   227,
       0,     0,     0,     0,   221,     0,   189,     0,     0,     0,
      14,   190,   172,     0,   187,   191,     0,     0,     0,     0,
     188,   154,     0,     0,     0,   146,   144,   145,   147,   149,
     148,   142,   196,     0,   230,   194,     0,     0,   224,     0,
     141,     0,   150,   151,   152,   205,   180,     0,   175,   174,
     176,   177,     0,   171,     0,     0,   230,   195,   192,   194,
       0,     0,     0,     0,   224,     0,   245,   246,   248,   247,
     249,   250,   251,   244,     0,   243,   140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   105,     0,     0,     0,
       0,   161,   163,   160,   159,   158,   157,     0,   168,   164,
     165,   167,   166,   162,   153,   207,   206,   208,   210,   209,
       0,     0,     0,   197,   205,     0,   178,   173,   231,   228,
     229,   193,   217,   219,     0,   222,   223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   106,     0,   105,     0,     0,     0,   155,     0,
       0,   212,   213,   204,   170,   185,     0,     0,   179,     0,
     205,   205,     0,   242,   238,   239,   240,   241,     0,    74,
       0,    75,     0,     0,     0,     0,     0,    91,     0,     0,
     104,    85,     0,   156,     0,     0,    72,     0,   183,   182,
     181,   234,   218,   220,   225,     0,     0,     0,     0,     0,
       0,     0,   122,     0,    88,   113,    92,     0,    77,   211,
     186,   184,     0,   205,    27,    32,    40,    49,    57,    63,
       0,   125,   102,     0,    20,    21,    22,    90,    86,    88,
     116,    95,     0,    73,   232,     0,   233,   226,    35,    43,
      52,    60,    66,    25,   138,   139,   135,   134,   136,   133,
     128,     0,     0,   132,   129,   131,   130,   127,   126,   123,
     125,   108,    89,    87,     0,     0,     0,     0,   117,   114,
     116,     0,     0,   100,    93,    95,    29,     0,    28,    23,
      24,    81,    80,    82,    16,     0,     0,    84,    78,    79,
      83,    76,   236,     0,    33,    41,    50,    58,    64,    19,
     137,   124,     0,   112,   110,   109,   103,   108,   118,   119,
     120,   121,   115,    96,    97,   101,    98,   100,    94,    31,
       0,    30,    17,    18,   237,    39,    36,    37,    38,    34,
      48,     0,    44,    45,    46,    42,    56,    53,    55,    54,
      51,    61,    62,    59,     0,    71,    67,    68,    69,    65,
     111,   107,    99,    26,   235,    47,    70
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,    19,    37,   327,   297,   267,   330,   217,   226,
      80,   317,   360,   131,   278,   334,   369,   132,   279,   335,
     375,   133,   280,   336,   380,   134,   281,   337,   383,   135,
     282,   338,   389,   136,   248,   137,   273,   331,   138,   244,
     268,   269,   139,   140,   271,   314,   315,   356,   357,   141,
     301,   183,   184,   346,   347,   142,   270,   309,   310,   143,
     261,   299,   300,    20,    21,    48,    71,    81,   144,    22,
      52,    73,    93,   155,   198,   228,   251,    23,    24,    25,
      26,    75,    98,    99,    27,    85,    28,   153,   154,    29,
      30,   200,    31,   201,    32,    58,   103,   104,   253,    33,
      53,    95,    96,   199,   252,   276,   114,   115
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -270
static const short yypact[] =
{
    -270,   187,  -270,    12,    12,    12,    12,    12,  -270,    12,
    -270,  -270,  -270,  -270,  -270,    12,    12,    12,     4,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,    12,  -270,
    -270,  -270,  -270,  -270,   -91,  -270,  -270,   -85,  -270,  -270,
     -81,   -72,   -59,   -55,  -270,   -44,  -270,   -48,   219,   -42,
    -270,  -270,  -270,    66,  -270,  -270,   -36,   -30,    76,    75,
    -270,  -270,   -26,   -19,     6,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,   240,    23,    -2,    25,    31,   138,    77,
    -270,   183,  -270,  -270,  -270,   308,  -270,    12,  -270,  -270,
    -270,  -270,    77,  -270,    46,   152,    23,  -270,  -270,    -2,
      54,    56,    57,   162,   138,    77,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,    24,  -270,  -270,    67,    68,    78,
      81,    82,    84,   115,    96,    12,   116,   154,    12,    12,
     127,  -270,  -270,  -270,  -270,  -270,  -270,   164,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
     130,   137,   139,  -270,   308,   136,  -270,   108,  -270,  -270,
    -270,  -270,  -270,  -270,   168,  -270,  -270,    39,    77,    77,
      77,    77,    24,    12,    12,    12,    12,    12,    12,    12,
     258,   188,  -270,    12,   116,   258,   -74,   189,  -270,   260,
     155,  -270,  -270,  -270,  -270,  -270,   160,   163,  -270,   267,
     308,   308,   159,  -270,   -65,   -65,  -270,  -270,    24,  -270,
     199,  -270,   200,   202,   204,   207,    77,  -270,   260,   208,
    -270,  -270,   260,  -270,   260,    77,  -270,   174,   182,  -270,
    -270,  -270,  -270,  -270,  -270,    48,   260,   260,   260,   258,
     260,    24,  -270,   260,     2,  -270,  -270,    24,  -270,  -270,
    -270,  -270,     3,   308,  -270,  -270,  -270,  -270,  -270,  -270,
      83,   192,  -270,   198,  -270,  -270,  -270,  -270,  -270,     2,
      18,   -10,    -3,   315,  -270,   -76,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,   194,   205,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
     192,   -13,  -270,  -270,   206,   209,   214,   218,  -270,  -270,
      18,   220,   223,   224,  -270,   -10,  -270,    41,   108,  -270,
    -270,  -270,  -270,  -270,  -270,   213,   231,  -270,  -270,  -270,
    -270,  -270,  -270,    12,   305,   255,   305,    13,   265,  -270,
    -270,  -270,   233,  -270,  -270,  -270,  -270,   -13,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,   224,  -270,  -270,
     307,   108,  -270,  -270,   210,  -270,  -270,  -270,  -270,  -270,
    -270,   234,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,   236,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -270,  -270,  -270,    -4,  -216,   -35,  -240,  -269,  -167,    95,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
      49,  -270,  -270,  -270,  -270,    47,  -270,     7,  -270,  -270,
    -270,   179,  -270,    22,  -270,  -270,  -270,    55,  -270,  -270,
    -270,    70,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,  -270,
    -270,  -270,   272,  -270,  -270,  -270,  -270,  -137,  -270,  -270,
    -270,  -270,  -270,  -270,  -270,  -270,   268,  -270,  -270,  -270,
    -270,   277,  -270,  -270,  -270,  -270,   -82,  -270
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned short yytable[] =
{
      38,    39,    40,    41,   105,    42,   222,    34,    35,   274,
     157,    43,    44,    45,    47,    34,    35,   193,   221,   263,
      50,   298,   332,   167,    49,    51,   264,   265,   266,    54,
     308,   105,   172,   329,   333,   316,    59,   223,    55,   342,
     343,   264,   265,   266,   311,   312,   313,   203,   105,   170,
     171,    56,   264,   265,   266,    57,   254,   264,   265,   266,
     298,   345,    60,   232,   233,   368,   374,   379,    72,   388,
     308,    74,   258,   291,    76,   304,   305,   306,   307,   359,
      77,    78,    79,   156,   105,    82,   204,   205,   206,   207,
     208,   283,    83,   275,   367,   373,   378,   382,   387,   291,
     106,   107,   108,   109,   110,   111,   112,   345,    97,   168,
     169,   170,   171,   113,    46,    36,   277,    84,   365,    94,
     376,   181,   385,    36,   186,   187,   235,   106,   107,   108,
     109,   110,   111,   112,   241,   100,   168,   169,   170,   171,
     113,   101,   194,   247,   106,   107,   108,   109,   110,   111,
     112,   168,   169,   170,   171,   102,   158,   113,   159,   260,
     168,   169,   170,   171,   162,   272,   163,   164,   165,   209,
     210,   211,   212,   213,   214,   215,   180,   173,   174,   219,
     106,   107,   108,   109,   110,   111,   112,     2,   175,   116,
     318,   176,   177,   113,   178,   168,   169,   170,   171,     3,
       4,     5,     6,     7,     8,     9,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   195,   128,   129,
     168,   169,   170,   171,    61,   179,   182,   196,    62,    63,
      64,   264,   265,   266,   185,   361,   197,   188,   328,   284,
     285,   286,   287,   288,   189,    86,   190,   202,   191,    87,
     192,    10,    11,    12,    13,    14,    15,    16,    65,    88,
      89,    90,    91,    66,    67,   216,   344,   225,   218,   224,
     229,   227,   231,   230,    17,   234,   289,   290,   291,   236,
     237,   292,   238,   130,   239,   293,   294,   240,   243,    18,
     249,   295,   250,   296,   264,   265,   266,   319,   320,   366,
     372,   377,   381,   386,   264,   265,   266,   319,   320,   302,
     339,    68,   344,   242,    69,   393,    70,   245,   303,   246,
     394,   340,   348,    92,   362,   349,   324,   325,   326,   364,
     350,   255,   256,   257,   351,   259,   353,   370,   262,   354,
     355,   291,   363,   371,   264,   265,   266,   319,   320,   390,
     395,   291,   396,   384,   264,   265,   266,   319,   320,   321,
     322,   323,   358,   220,   392,   352,   324,   325,   326,   391,
     341,   161,   166,   160,     0,     0,   324,   325,   326,   145,
     146,   147,   148,   149,   150,   151,   152,     0,     0,     0,
       0,   291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   291
};

static const short yycheck[] =
{
       4,     5,     6,     7,     7,     9,    80,     3,     4,     6,
      92,    15,    16,    17,    18,     3,     4,   154,   185,    17,
     111,   261,    98,   105,    28,   110,    39,    40,    41,   110,
     270,     7,   114,   273,   110,    38,    80,   111,   110,    52,
      53,    39,    40,    41,    54,    55,    56,     8,     7,   114,
     115,   110,    39,    40,    41,   110,     8,    39,    40,    41,
     300,   301,   110,   200,   201,   334,   335,   336,   110,   338,
     310,     5,   239,    86,   110,    57,    58,    59,    60,    38,
     110,     5,     7,    87,     7,   111,   168,   169,   170,   171,
     172,     8,   111,    90,   334,   335,   336,   337,   338,    86,
     103,   104,   105,   106,   107,   108,   109,   347,   110,   112,
     113,   114,   115,   116,   110,   111,   253,   111,   334,    96,
     336,   125,   338,   111,   128,   129,   208,   103,   104,   105,
     106,   107,   108,   109,   216,   110,   112,   113,   114,   115,
     116,   110,     6,   225,   103,   104,   105,   106,   107,   108,
     109,   112,   113,   114,   115,    17,   110,   116,     6,   241,
     112,   113,   114,   115,   110,   247,   110,   110,     6,   173,
     174,   175,   176,   177,   178,   179,    80,   110,   110,   183,
     103,   104,   105,   106,   107,   108,   109,     0,   110,     6,
     272,   110,   110,   116,   110,   112,   113,   114,   115,    12,
      13,    14,    15,    16,    17,    18,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    81,    35,    36,
     112,   113,   114,   115,     5,   110,   110,    91,     9,    10,
      11,    39,    40,    41,    80,   317,   100,   110,   273,    47,
      48,    49,    50,    51,    80,     5,   116,    79,   111,     9,
     111,    64,    65,    66,    67,    68,    69,    70,    39,    19,
      20,    21,    22,    44,    45,     7,   301,     7,    80,    80,
     110,   116,     5,   110,    87,   116,    84,    85,    86,    80,
      80,    89,    80,   100,    80,    93,    94,    80,    80,   102,
     116,    99,   110,   101,    39,    40,    41,    42,    43,   334,
     335,   336,   337,   338,    39,    40,    41,    42,    43,   111,
     116,    92,   347,   218,    95,     8,    97,   222,   269,   224,
     110,   116,   116,    83,   111,   116,    61,    62,    63,   333,
     116,   236,   237,   238,   116,   240,   116,    82,   243,   116,
     116,    86,   111,    88,    39,    40,    41,    42,    43,   116,
     116,    86,   116,    88,    39,    40,    41,    42,    43,    44,
      45,    46,   315,   184,   357,   310,    61,    62,    63,   347,
     300,    99,   104,    96,    -1,    -1,    61,    62,    63,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,   118,     0,    12,    13,    14,    15,    16,    17,    18,
      64,    65,    66,    67,    68,    69,    70,    87,   102,   119,
     180,   181,   186,   194,   195,   196,   197,   201,   203,   206,
     207,   209,   211,   216,     3,     4,   111,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   110,   120,   182,   120,
     111,   110,   187,   217,   110,   110,   110,   110,   212,    80,
     110,     5,     9,    10,    11,    39,    44,    45,    92,    95,
      97,   183,   110,   188,     5,   198,   110,   110,     5,     7,
     127,   184,   111,   111,   111,   202,     5,     9,    19,    20,
      21,    22,    83,   189,    96,   218,   219,   110,   199,   200,
     110,   110,    17,   213,   214,     7,   103,   104,   105,   106,
     107,   108,   109,   116,   223,   224,     6,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    35,    36,
     100,   130,   134,   138,   142,   146,   150,   152,   155,   159,
     160,   166,   172,   176,   185,    71,    72,    73,    74,    75,
      76,    77,    78,   204,   205,   190,   120,   223,   110,     6,
     218,   199,   110,   110,   110,     6,   213,   223,   112,   113,
     114,   115,   223,   110,   110,   110,   110,   110,   110,   110,
      80,   120,   110,   168,   169,    80,   120,   120,   110,    80,
     116,   111,   111,   204,     6,    81,    91,   100,   191,   220,
     208,   210,    79,     8,   223,   223,   223,   223,   223,   120,
     120,   120,   120,   120,   120,   120,     7,   125,    80,   120,
     168,   125,    80,   111,    80,     7,   126,   116,   192,   110,
     110,     5,   204,   204,   116,   223,    80,    80,    80,    80,
      80,   223,   126,    80,   156,   126,   126,   223,   151,   116,
     110,   193,   221,   215,     8,   126,   126,   126,   125,   126,
     223,   177,   126,    17,    39,    40,    41,   123,   157,   158,
     173,   161,   223,   153,     6,    90,   222,   204,   131,   135,
     139,   143,   147,     8,    47,    48,    49,    50,    51,    84,
      85,    86,    89,    93,    94,    99,   101,   122,   123,   178,
     179,   167,   111,   157,    57,    58,    59,    60,   123,   174,
     175,    54,    55,    56,   162,   163,    38,   128,   223,    42,
      43,    44,    45,    46,    61,    62,    63,   121,   122,   123,
     124,   154,    98,   110,   132,   136,   140,   144,   148,   116,
     116,   178,    52,    53,   122,   123,   170,   171,   116,   116,
     116,   116,   174,   116,   116,   116,   164,   165,   162,    38,
     129,   223,   111,   111,   120,   121,   122,   123,   124,   133,
      82,    88,   122,   123,   124,   137,   121,   122,   123,   124,
     141,   122,   123,   145,    88,   121,   122,   123,   124,   149,
     116,   170,   164,     8,   110,   116,   116
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {
      case 110: /* QUOTESTRING */
#line 474 "parser.yy"
        { free (yyvaluep->str); };
#line 1656 "y.tab.c"
        break;
      case 111: /* WORD */
#line 474 "parser.yy"
        { free (yyvaluep->str); };
#line 1661 "y.tab.c"
        break;

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 14:
#line 500 "parser.yy"
    { yyval.str = yyvsp[0].str; }
    break;

  case 15:
#line 500 "parser.yy"
    { yyval.str = "_AUTO_"; }
    break;

  case 19:
#line 510 "parser.yy"
    { yyval.num = yyvsp[0].num; }
    break;

  case 20:
#line 511 "parser.yy"
    { yyval.num = true; }
    break;

  case 21:
#line 511 "parser.yy"
    { yyval.num = false; }
    break;

  case 22:
#line 511 "parser.yy"
    { yyval.num = false; }
    break;

  case 23:
#line 512 "parser.yy"
    { yyval.num = false; }
    break;

  case 24:
#line 512 "parser.yy"
    { yyval.num = true; }
    break;

  case 25:
#line 514 "parser.yy"
    {
    current_pos_size.x = yyvsp[-2].num;
    current_pos_size.y = yyvsp[-1].num;
}
    break;

  case 26:
#line 519 "parser.yy"
    {
    current_pos_size.x = yyvsp[-4].num;
    current_pos_size.y = yyvsp[-3].num;
}
    break;

  case 27:
#line 524 "parser.yy"
    {
    current_pos_size.x = yyvsp[-4].num;
    current_pos_size.y = yyvsp[-3].num;
    current_pos_size.width_auto = false;
    
    current_pos_size.width = yyvsp[-2].num;
    current_pos_size.height_auto = false;
    current_pos_size.height = yyvsp[-1].num;
}
    break;

  case 28:
#line 535 "parser.yy"
    { current_pos_size.width_auto = false; current_pos_size.width = yyvsp[0].num; }
    break;

  case 29:
#line 536 "parser.yy"
    { current_pos_size.width_auto = true; }
    break;

  case 30:
#line 538 "parser.yy"
    { current_pos_size.height_auto = false; current_pos_size.height = yyvsp[0].num; }
    break;

  case 31:
#line 539 "parser.yy"
    { current_pos_size.height_auto = true; }
    break;

  case 32:
#line 546 "parser.yy"
    {
    current_widget.ptrigger = dynamic_cast<Widgets::PopupTrigger*> (
	current.form->create_widget (Widgets::WIDGET_POPUP_TRIGGER, yyvsp[-2].str, true));
    current_widget.ptrigger->text = yyvsp[-3].str;
    widget_apply_pos_size (current_widget.ptrigger);
}
    break;

  case 33:
#line 551 "parser.yy"
    {
    previous_widget = current_widget.ptrigger;
}
    break;

  case 36:
#line 556 "parser.yy"
    { current_widget.ptrigger->font = yyvsp[0].num; }
    break;

  case 37:
#line 557 "parser.yy"
    { current_widget.ptrigger->usable = yyvsp[0].num; }
    break;

  case 38:
#line 558 "parser.yy"
    { current_widget.ptrigger->anchor_right = yyvsp[0].num; }
    break;

  case 39:
#line 559 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 40:
#line 566 "parser.yy"
    {
    current_widget.checkbox = dynamic_cast<Widgets::Checkbox*> (
	current.form->create_widget (Widgets::WIDGET_CHECKBOX, yyvsp[-2].str, true));
    current_widget.checkbox->text = yyvsp[-3].str;
    widget_apply_pos_size (current_widget.checkbox);
}
    break;

  case 41:
#line 571 "parser.yy"
    {
    previous_widget = current_widget.checkbox;
}
    break;

  case 44:
#line 576 "parser.yy"
    { current_widget.checkbox->font = yyvsp[0].num; }
    break;

  case 45:
#line 577 "parser.yy"
    { current_widget.checkbox->usable = yyvsp[0].num; }
    break;

  case 46:
#line 578 "parser.yy"
    { current_widget.checkbox->anchor_right = yyvsp[0].num; }
    break;

  case 47:
#line 579 "parser.yy"
    { current_widget.checkbox->group = yyvsp[0].num; }
    break;

  case 48:
#line 580 "parser.yy"
    { current_widget.checkbox->toggled = true; }
    break;

  case 49:
#line 588 "parser.yy"
    {
    current_widget.strigger = dynamic_cast<Widgets::SelectorTrigger*> (
	current.form->create_widget (Widgets::WIDGET_SELECTOR_TRIGGER, yyvsp[-2].str, true));
    current_widget.strigger->text = yyvsp[-3].str;
    widget_apply_pos_size (current_widget.strigger);
}
    break;

  case 50:
#line 593 "parser.yy"
    {
    previous_widget = current_widget.strigger;
}
    break;

  case 53:
#line 598 "parser.yy"
    { current_widget.strigger->font = yyvsp[0].num; }
    break;

  case 54:
#line 599 "parser.yy"
    { current_widget.strigger->anchor_right = yyvsp[0].num; }
    break;

  case 55:
#line 600 "parser.yy"
    { current_widget.strigger->usable = yyvsp[0].num; }
    break;

  case 56:
#line 601 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 57:
#line 608 "parser.yy"
    {
    current_widget.label = dynamic_cast<Widgets::Label*> (
	current.form->create_widget (Widgets::WIDGET_LABEL, yyvsp[-2].str, true));
    current_widget.label->text = yyvsp[-3].str;
    widget_apply_pos (current_widget.label);
}
    break;

  case 58:
#line 613 "parser.yy"
    {
    previous_widget = current_widget.label;
}
    break;

  case 61:
#line 618 "parser.yy"
    { current_widget.label->font = yyvsp[0].num; }
    break;

  case 62:
#line 619 "parser.yy"
    { current_widget.label->usable = yyvsp[0].num; }
    break;

  case 63:
#line 627 "parser.yy"
    {
    current_widget.pushbutton = dynamic_cast<Widgets::PushButton*> (
	current.form->create_widget (Widgets::WIDGET_PUSHBUTTON, yyvsp[-2].str, true));
    current_widget.pushbutton->text = yyvsp[-3].str;
    widget_apply_pos_size (current_widget.pushbutton);
}
    break;

  case 64:
#line 632 "parser.yy"
    {
    previous_widget = current_widget.pushbutton;
}
    break;

  case 67:
#line 637 "parser.yy"
    { current_widget.pushbutton->font = yyvsp[0].num; }
    break;

  case 68:
#line 638 "parser.yy"
    { current_widget.pushbutton->usable = yyvsp[0].num; }
    break;

  case 69:
#line 639 "parser.yy"
    { current_widget.pushbutton->anchor_right = yyvsp[0].num; }
    break;

  case 70:
#line 640 "parser.yy"
    { current_widget.pushbutton->group = yyvsp[0].num; }
    break;

  case 71:
#line 641 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 72:
#line 648 "parser.yy"
    {
    widget_apply_pos_size (current_widget.button); }
    break;

  case 73:
#line 650 "parser.yy"
    {
    previous_widget = current_widget.button;
}
    break;

  case 74:
#line 654 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, yyvsp[0].str, true));
    current_widget.button->text = yyvsp[-1].str;
}
    break;

  case 75:
#line 658 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, yyvsp[0].str, true));
    current_widget.button->text = yyvsp[-1].str;
    current_widget.button->repeat = true;
}
    break;

  case 78:
#line 666 "parser.yy"
    { current_widget.button->font = yyvsp[0].num; }
    break;

  case 79:
#line 667 "parser.yy"
    { current_widget.button->usable = yyvsp[0].num; }
    break;

  case 80:
#line 668 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_NONE; }
    break;

  case 81:
#line 669 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_SIMPLE; }
    break;

  case 82:
#line 670 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_BOLD; }
    break;

  case 83:
#line 671 "parser.yy"
    { current_widget.button->anchor_right = yyvsp[0].num; }
    break;

  case 84:
#line 672 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 85:
#line 679 "parser.yy"
    {
    current_widget.bitmap = dynamic_cast<Widgets::FormBitmap*> (
	current.form->create_widget (Widgets::WIDGET_FORMBITMAP));
    widget_apply_pos (current_widget.bitmap);
}
    break;

  case 86:
#line 683 "parser.yy"
    {
    previous_widget = current_widget.bitmap;
}
    break;

  case 89:
#line 688 "parser.yy"
    { current_widget.bitmap->bitmap_id = yyvsp[0].str; }
    break;

  case 90:
#line 689 "parser.yy"
    { current_widget.bitmap->usable = yyvsp[0].num; }
    break;

  case 91:
#line 696 "parser.yy"
    {
    Widgets::Graffiti *graffiti = dynamic_cast<Widgets::Graffiti*> (
	current.form->create_widget (Widgets::WIDGET_GRAFFITI));
    widget_apply_pos (graffiti);
    previous_widget = graffiti;
}
    break;

  case 92:
#line 708 "parser.yy"
    {
    current_widget.table = dynamic_cast<Widgets::Table*> (
	current.form->create_widget (Widgets::WIDGET_TABLE, yyvsp[-2].str, true));
    widget_apply_pos_size (current_widget.table);
}
    break;

  case 93:
#line 712 "parser.yy"
    { Table::import_end (); previous_widget = current_widget.table; }
    break;

  case 96:
#line 715 "parser.yy"
    { current_widget.table->num_rows = yyvsp[0].num; }
    break;

  case 97:
#line 716 "parser.yy"
    { current_widget.table->num_columns = yyvsp[0].num; }
    break;

  case 101:
#line 720 "parser.yy"
    { Table::import_col (yyvsp[0].num); }
    break;

  case 102:
#line 727 "parser.yy"
    {
    current_widget.lst = dynamic_cast<Widgets::List*> (
	current.form->create_widget (Widgets::WIDGET_LIST, yyvsp[-2].str, true));
    widget_apply_pos (current_widget.lst);
    List::apply_items ();
}
    break;

  case 103:
#line 732 "parser.yy"
    {
    previous_widget = current_widget.lst;
}
    break;

  case 106:
#line 737 "parser.yy"
    {
    List::import_item (yyvsp[0].str);
}
    break;

  case 109:
#line 742 "parser.yy"
    { current_widget.lst->usable = yyvsp[0].num; }
    break;

  case 110:
#line 743 "parser.yy"
    { current_widget.lst->font = yyvsp[0].num; }
    break;

  case 111:
#line 744 "parser.yy"
    { current_widget.lst->visible_items = yyvsp[0].num; }
    break;

  case 112:
#line 745 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 113:
#line 752 "parser.yy"
    {
    current_widget.scrollbar = dynamic_cast<Widgets::ScrollBar*> (
	current.form->create_widget (Widgets::WIDGET_SCROLLBAR, yyvsp[-2].str, true));
    widget_apply_pos_size (current_widget.scrollbar);    
}
    break;

  case 114:
#line 756 "parser.yy"
    {
    previous_widget = current_widget.scrollbar;
}
    break;

  case 117:
#line 761 "parser.yy"
    { current_widget.scrollbar->usable = yyvsp[0].num; }
    break;

  case 118:
#line 762 "parser.yy"
    { current_widget.scrollbar->value = yyvsp[0].num; }
    break;

  case 119:
#line 763 "parser.yy"
    { current_widget.scrollbar->min_value = yyvsp[0].num; }
    break;

  case 120:
#line 764 "parser.yy"
    { current_widget.scrollbar->max_value = yyvsp[0].num; }
    break;

  case 121:
#line 765 "parser.yy"
    { current_widget.scrollbar->page_size = yyvsp[0].num; }
    break;

  case 122:
#line 771 "parser.yy"
    {
    current_widget.field = dynamic_cast<Widgets::TextField*> (
	current.form->create_widget (Widgets::WIDGET_TEXT_FIELD, yyvsp[-2].str, true));
    current_widget.field->underline = false;
    current_widget.field->editable = false;
    widget_apply_pos_size (current_widget.field);
}
    break;

  case 123:
#line 777 "parser.yy"
    {
    previous_widget = current_widget.field;
}
    break;

  case 126:
#line 782 "parser.yy"
    { current_widget.field->usable = yyvsp[0].num; }
    break;

  case 127:
#line 783 "parser.yy"
    { current_widget.field->font = yyvsp[0].num; }
    break;

  case 128:
#line 784 "parser.yy"
    { current_widget.field->editable = true; }
    break;

  case 129:
#line 785 "parser.yy"
    { current_widget.field->editable = false; }
    break;

  case 130:
#line 786 "parser.yy"
    { current_widget.field->underline = true; }
    break;

  case 131:
#line 787 "parser.yy"
    { current_widget.field->multi_line = false; }
    break;

  case 132:
#line 788 "parser.yy"
    { current_widget.field->multi_line = true; }
    break;

  case 133:
#line 789 "parser.yy"
    { current_widget.field->dynamic_size = true; }
    break;

  case 134:
#line 790 "parser.yy"
    { current_widget.field->auto_shift = true; }
    break;

  case 135:
#line 791 "parser.yy"
    { current_widget.field->numeric = true; }
    break;

  case 136:
#line 792 "parser.yy"
    { current_widget.field->has_scrollbar = true; }
    break;

  case 137:
#line 793 "parser.yy"
    { current_widget.field->max_length = yyvsp[0].num; }
    break;

  case 138:
#line 794 "parser.yy"
    { current_widget.field->justify_right = false; }
    break;

  case 139:
#line 795 "parser.yy"
    { current_widget.field->justify_right = true; }
    break;

  case 140:
#line 801 "parser.yy"
    { Form::import_end (); }
    break;

  case 141:
#line 803 "parser.yy"
    {
    previous_widget = 0;
    
    current.form = dynamic_cast<Resources::Form*> (
	manager->create_resource (Resources::RESOURCE_FORM, yyvsp[-2].str));
    current.form->x = current_pos_size.x;
    current.form->y = current_pos_size.y;
    current.form->width = current_pos_size.width;
    current.form->height = current_pos_size.height;
}
    break;

  case 144:
#line 815 "parser.yy"
    { current.form->frame = true; }
    break;

  case 145:
#line 816 "parser.yy"
    { current.form->frame = false; }
    break;

  case 146:
#line 817 "parser.yy"
    { /* Do nothing */ }
    break;

  case 147:
#line 818 "parser.yy"
    { current.form->modal = true; }
    break;

  case 148:
#line 819 "parser.yy"
    { current.form->savebehind = true; }
    break;

  case 149:
#line 820 "parser.yy"
    { current.form->savebehind = false; }
    break;

  case 150:
#line 821 "parser.yy"
    { current.form->help_id = yyvsp[0].str; }
    break;

  case 151:
#line 822 "parser.yy"
    { current.form->menu_id = yyvsp[0].str; }
    break;

  case 152:
#line 823 "parser.yy"
    { current.form->def_button = yyvsp[0].str; }
    break;

  case 155:
#line 826 "parser.yy"
    { current.form->title = yyvsp[0].str; }
    break;

  case 156:
#line 827 "parser.yy"
    { Form::import_popuplist (yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 169:
#line 846 "parser.yy"
    {
    current.dialog = dynamic_cast<Resources::Dialog*> (
	manager->create_resource (Resources::RESOURCE_DIALOG, yyvsp[0].str));
}
    break;

  case 173:
#line 853 "parser.yy"
    { current.dialog->default_button = yyvsp[0].num; }
    break;

  case 174:
#line 854 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_INFORMATION; }
    break;

  case 175:
#line 855 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_CONFIRMATION; }
    break;

  case 176:
#line 856 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_WARNING; }
    break;

  case 177:
#line 857 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_ERROR; }
    break;

  case 178:
#line 858 "parser.yy"
    { current.dialog->help_id = yyvsp[0].str; }
    break;

  case 181:
#line 862 "parser.yy"
    { current.dialog->title = yyvsp[0].str; }
    break;

  case 182:
#line 863 "parser.yy"
    { current.dialog->text = yyvsp[0].str; }
    break;

  case 186:
#line 867 "parser.yy"
    { Dialog::import_button (yyvsp[0].str); }
    break;

  case 187:
#line 874 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_STRING, yyvsp[-1].str);
    Resources::String *str = dynamic_cast<Resources::String*> (res);

    str->text = yyvsp[0].str;
}
    break;

  case 188:
#line 886 "parser.yy"
    { manager->get_application ()->version = yyvsp[0].str; }
    break;

  case 189:
#line 887 "parser.yy"
    { manager->get_application ()->version = yyvsp[0].str; }
    break;

  case 190:
#line 889 "parser.yy"
    {
    manager->get_application ()->iconname = yyvsp[0].str; }
    break;

  case 191:
#line 896 "parser.yy"
    {
    current.stringlist = dynamic_cast<Resources::StringList*> (
	manager->create_resource (Resources::RESOURCE_STRINGLIST, yyvsp[-1].str));

    current.stringlist->prefix = yyvsp[0].str;
}
    break;

  case 192:
#line 901 "parser.yy"
    { StringList::import_end (); }
    break;

  case 195:
#line 904 "parser.yy"
    { StringList::import_string (yyvsp[0].str); }
    break;

  case 196:
#line 911 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAP, yyvsp[-1].str);
    Resources::Bitmap *bmp = dynamic_cast<Resources::Bitmap*> (res);

    bmp->bitmap_type = current_bitmap_type;
    std::string bitmap_uri = create_child_uri (yyvsp[0].str);
    if (bitmap_uri != "")
	bmp->load_file (bitmap_uri);
}
    break;

  case 198:
#line 921 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_MONO; }
    break;

  case 199:
#line 922 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_4; }
    break;

  case 200:
#line 923 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_16; }
    break;

  case 201:
#line 924 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16; }
    break;

  case 202:
#line 925 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_256; }
    break;

  case 203:
#line 926 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16K; }
    break;

  case 217:
#line 943 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, yyvsp[-4].str);
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri (yyvsp[-3].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[-2].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[-1].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[0].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 219:
#line 959 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, yyvsp[-4].str);
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri (yyvsp[-3].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[-2].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[-1].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri (yyvsp[0].str)) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 221:
#line 974 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, yyvsp[0].str);
    current.bitmap_family = dynamic_cast<Resources::BitmapFamily*> (res);    
}
    break;

  case 225:
#line 980 "parser.yy"
    {
    BitmapFamily::import_bitmap (yyvsp[-2].str, yyvsp[0].num);
}
    break;

  case 227:
#line 988 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_MENU, yyvsp[0].str);
    current.menu = dynamic_cast<Resources::Menu*> (res);
}
    break;

  case 228:
#line 991 "parser.yy"
    { Menu::import_end (); }
    break;

  case 231:
#line 994 "parser.yy"
    { Menu::import_menu (yyvsp[0].str); }
    break;

  case 235:
#line 998 "parser.yy"
    { Menu::import_menuitem (yyvsp[-1].str, yyvsp[-2].str, yyvsp[0].str); }
    break;

  case 236:
#line 999 "parser.yy"
    { Menu::import_separator (); }
    break;

  case 237:
#line 1000 "parser.yy"
    { Menu::import_menuitem (yyvsp[0].str, yyvsp[-1].str); }
    break;

  case 238:
#line 1006 "parser.yy"
    { yyval.num = yyvsp[-2].num + yyvsp[0].num; }
    break;

  case 239:
#line 1007 "parser.yy"
    { yyval.num = yyvsp[-2].num - yyvsp[0].num; }
    break;

  case 240:
#line 1008 "parser.yy"
    { yyval.num = yyvsp[-2].num * yyvsp[0].num; }
    break;

  case 241:
#line 1009 "parser.yy"
    { yyval.num = yyvsp[-2].num / yyvsp[0].num; }
    break;

  case 242:
#line 1010 "parser.yy"
    { yyval.num = yyvsp[-1].num; }
    break;

  case 245:
#line 1014 "parser.yy"
    { yyval.num = 0; }
    break;

  case 246:
#line 1015 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->x : 0; }
    break;

  case 247:
#line 1016 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->y : 0; }
    break;

  case 248:
#line 1017 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->x + previous_widget->get_width () : 0;  }
    break;

  case 249:
#line 1018 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->y + previous_widget->get_height () : 0; }
    break;

  case 250:
#line 1019 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->get_width () : 0;  }
    break;

  case 251:
#line 1020 "parser.yy"
    { yyval.num = previous_widget ? previous_widget->get_height () : 0; }
    break;


    }

/* Line 999 of yacc.c.  */
#line 2906 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 485 "parser.yy"


const char *yy_token_name(int token_index) {
  int internal_index = YYTRANSLATE(token_index);
  return yytname[internal_index];
}

