//$Id: bitmapfamily-res.cc,v 1.8 2004/08/20 18:22:17 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "bitmapfamily-res.h"

#include <Magick++.h>
#include <libgnomevfs/gnome-vfs.h>

#include "io/io.h"

using namespace Guikachu;

Resources::BitmapFamily::BitmapFamily (ResourceManager   *manager,
				       const std::string &id,
				       serial_t           serial):
    Resource (manager, id, serial)
{
}

Magick::Image Resources::BitmapFamily::get_image (BitmapType type) const
{
    image_map_t::const_iterator i = images.find (type);

    if (i != images.end ())
	return i->second;
    else
	return Magick::Image ();
}

void Resources::BitmapFamily::load_file (BitmapType type, const Glib::ustring &uri)
{
    char                 *data = 0;
    Gnome::Vfs::FileSize  len;

    try {
        IO::load_uri (uri, data, len);
    } catch (...) {
	delete[] data;
	return;
    }

    Magick::Blob blob;
    blob.updateNoCopy (data, len);
    
    set_image (type, blob);
}

void Resources::BitmapFamily::save_file_bmp (BitmapType type, const Glib::ustring &uri) const
{
    // Serialize image data in uncompressed BMP format
    Magick::Blob blob;
    Magick::Image image_cpy (get_image (type));
    
    image_cpy.compressType (Magick::NoCompression);
    image_cpy.write (&blob, "BMP");

    const char       *data = reinterpret_cast<const char*> (blob.data ());
    GnomeVFSFileSize  len = blob.length ();

    try {
        IO::save_uri (uri, data, len);
    } catch (...) {
    }
}

void Resources::BitmapFamily::set_image (BitmapType type, const Magick::Blob &blob)
{
    Magick::Image image (blob);

    set_image (type, image);
}

void Resources::BitmapFamily::set_image (BitmapType type, const Magick::Image &image)
{
    // 4bpp color and greyscale bitmaps are mutually exclusive
    if (image.isValid ())
    {
        if (type == Bitmap::TYPE_GREY_16)
            images[Bitmap::TYPE_COLOR_16] = Magick::Image ();
        else if (type == Bitmap::TYPE_COLOR_16)
            images[Bitmap::TYPE_GREY_16] = Magick::Image ();
    }
    
    images[type] = image;

    changed.emit ();
}
