/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID_TOKEN = 258,
     AUTOID = 259,
     BEG = 260,
     END = 261,
     LBRACE = 262,
     RBRACE = 263,
     ATSIGN = 264,
     BACKSLASH = 265,
     HELPID = 266,
     MENUID = 267,
     DEFAULTBTNID = 268,
     APPLICATIONICONNAME = 269,
     ALERT = 270,
     MENU = 271,
     STRING = 272,
     STRINGTABLE = 273,
     BITMAP = 274,
     BITMAPFAMILY = 275,
     DIALOG_CONFIRMATION = 276,
     DIALOG_INFORMATION = 277,
     DIALOG_WARNING = 278,
     DIALOG_ERROR = 279,
     BUTTON = 280,
     POPUPTRIGGER = 281,
     REPEATBUTTON = 282,
     CHECKBOX = 283,
     SELECTORTRIGGER = 284,
     LABEL = 285,
     PUSHBUTTON = 286,
     GRAFFITISTATEINDICATOR = 287,
     NOGRAFFITISTATEINDICATOR = 288,
     FIELD = 289,
     LIST = 290,
     FORMBITMAP = 291,
     GADGET = 292,
     POPUPLIST = 293,
     TABLE = 294,
     SCROLLBAR = 295,
     SLIDER = 296,
     AUTO = 297,
     USABLE = 298,
     NONUSABLE = 299,
     DISABLED = 300,
     LEFTANCHOR = 301,
     RIGHTANCHOR = 302,
     FRAME = 303,
     NOFRAME = 304,
     BOLDFRAME = 305,
     LEFTALIGN = 306,
     RIGHTALIGN = 307,
     NUMERIC = 308,
     AUTOSHIFT = 309,
     HASSCROLLBAR = 310,
     VERTICAL = 311,
     FEEDBACK = 312,
     VISIBLEITEMS = 313,
     SEARCH = 314,
     ROWS = 315,
     COLUMNS = 316,
     COLUMNWIDTHS = 317,
     VALUE = 318,
     MIN_VAL = 319,
     MAX_VAL = 320,
     PAGESIZE = 321,
     GRAPHICAL = 322,
     BITMAPID = 323,
     SELECTEDBITMAPID = 324,
     THUMBID = 325,
     BACKGROUNDID = 326,
     BITMAPGREY = 327,
     BITMAPGREY16 = 328,
     BITMAPCOLOR16 = 329,
     BITMAPCOLOR = 330,
     BITMAPCOLOR16K = 331,
     BITMAPFAMILYSPECIAL = 332,
     BITMAPFAMILYEX = 333,
     COMPRESS = 334,
     NOCOMPRESS = 335,
     FORCECOMPRESS = 336,
     COLORTABLE = 337,
     NOCOLORTABLE = 338,
     TRANSPARENT = 339,
     TRANSPARENTINDEX = 340,
     DENSITY = 341,
     BPP = 342,
     AT = 343,
     BUTTONS = 344,
     CHECKED = 345,
     DEFAULTBUTTON = 346,
     DYNAMICSIZE = 347,
     EDITABLE = 348,
     FONT = 349,
     FORM = 350,
     GROUP = 351,
     MAXCHARS = 352,
     MENUITEM = 353,
     MESSAGE = 354,
     MODAL = 355,
     MULTIPLELINES = 356,
     NONEDITABLE = 357,
     NOSAVEBEHIND = 358,
     PULLDOWN = 359,
     SAVEBEHIND = 360,
     SEPARATOR = 361,
     SINGLELINE = 362,
     TITLE = 363,
     UNDERLINED = 364,
     VERSION_TOKEN = 365,
     CENTER = 366,
     RIGHT = 367,
     BOTTOM = 368,
     PREVLEFT = 369,
     PREVRIGHT = 370,
     PREVTOP = 371,
     PREVBOTTOM = 372,
     PREVWIDTH = 373,
     PREVHEIGHT = 374,
     QUOTESTRING = 375,
     WORD = 376,
     NUMBER = 377,
     PLUS = 378,
     MINUS = 379,
     TIMES = 380,
     DIV = 381
   };
#endif
/* Tokens.  */
#define ID_TOKEN 258
#define AUTOID 259
#define BEG 260
#define END 261
#define LBRACE 262
#define RBRACE 263
#define ATSIGN 264
#define BACKSLASH 265
#define HELPID 266
#define MENUID 267
#define DEFAULTBTNID 268
#define APPLICATIONICONNAME 269
#define ALERT 270
#define MENU 271
#define STRING 272
#define STRINGTABLE 273
#define BITMAP 274
#define BITMAPFAMILY 275
#define DIALOG_CONFIRMATION 276
#define DIALOG_INFORMATION 277
#define DIALOG_WARNING 278
#define DIALOG_ERROR 279
#define BUTTON 280
#define POPUPTRIGGER 281
#define REPEATBUTTON 282
#define CHECKBOX 283
#define SELECTORTRIGGER 284
#define LABEL 285
#define PUSHBUTTON 286
#define GRAFFITISTATEINDICATOR 287
#define NOGRAFFITISTATEINDICATOR 288
#define FIELD 289
#define LIST 290
#define FORMBITMAP 291
#define GADGET 292
#define POPUPLIST 293
#define TABLE 294
#define SCROLLBAR 295
#define SLIDER 296
#define AUTO 297
#define USABLE 298
#define NONUSABLE 299
#define DISABLED 300
#define LEFTANCHOR 301
#define RIGHTANCHOR 302
#define FRAME 303
#define NOFRAME 304
#define BOLDFRAME 305
#define LEFTALIGN 306
#define RIGHTALIGN 307
#define NUMERIC 308
#define AUTOSHIFT 309
#define HASSCROLLBAR 310
#define VERTICAL 311
#define FEEDBACK 312
#define VISIBLEITEMS 313
#define SEARCH 314
#define ROWS 315
#define COLUMNS 316
#define COLUMNWIDTHS 317
#define VALUE 318
#define MIN_VAL 319
#define MAX_VAL 320
#define PAGESIZE 321
#define GRAPHICAL 322
#define BITMAPID 323
#define SELECTEDBITMAPID 324
#define THUMBID 325
#define BACKGROUNDID 326
#define BITMAPGREY 327
#define BITMAPGREY16 328
#define BITMAPCOLOR16 329
#define BITMAPCOLOR 330
#define BITMAPCOLOR16K 331
#define BITMAPFAMILYSPECIAL 332
#define BITMAPFAMILYEX 333
#define COMPRESS 334
#define NOCOMPRESS 335
#define FORCECOMPRESS 336
#define COLORTABLE 337
#define NOCOLORTABLE 338
#define TRANSPARENT 339
#define TRANSPARENTINDEX 340
#define DENSITY 341
#define BPP 342
#define AT 343
#define BUTTONS 344
#define CHECKED 345
#define DEFAULTBUTTON 346
#define DYNAMICSIZE 347
#define EDITABLE 348
#define FONT 349
#define FORM 350
#define GROUP 351
#define MAXCHARS 352
#define MENUITEM 353
#define MESSAGE 354
#define MODAL 355
#define MULTIPLELINES 356
#define NONEDITABLE 357
#define NOSAVEBEHIND 358
#define PULLDOWN 359
#define SAVEBEHIND 360
#define SEPARATOR 361
#define SINGLELINE 362
#define TITLE 363
#define UNDERLINED 364
#define VERSION_TOKEN 365
#define CENTER 366
#define RIGHT 367
#define BOTTOM 368
#define PREVLEFT 369
#define PREVRIGHT 370
#define PREVTOP 371
#define PREVBOTTOM 372
#define PREVWIDTH 373
#define PREVHEIGHT 374
#define QUOTESTRING 375
#define WORD 376
#define NUMBER 377
#define PLUS 378
#define MINUS 379
#define TIMES 380
#define DIV 381




/* Copy the first part of user declarations.  */
#line 19 "parser.yy"


#define YYERROR_VERBOSE

#include "parser-interface.h"
#include "expr.h"
    
#include <glib/gi18n.h>
    
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "io/guikachu-io.h"
    
#include "resource-manager.h"

#include "string-res.h"
#include "stringlist-res.h"
#include "dialog-res.h"
#include "form-res.h"
#include "menu-res.h"
#include "bitmap-res.h"
#include "bitmapfamily-res.h"

#include "form-editor/label.h"
#include "form-editor/checkbox.h"
#include "form-editor/button.h"    
#include "form-editor/pushbutton.h"
#include "form-editor/selector-trigger.h"
#include "form-editor/popup-trigger.h"
#include "form-editor/graffiti.h"
#include "form-editor/text-field.h"
#include "form-editor/list.h"
#include "form-editor/table.h"
#include "form-editor/scrollbar.h"
#include "form-editor/slider.h"
#include "form-editor/formbitmap.h"

#ifdef GUIKACHU_HAVE_GNOMEVFS
#include <libgnomevfsmm/uri.h>
#endif
    
    extern int yylex();
    extern int lexer_lineno;
    extern char *yytext;

    extern struct yy_buffer_state* yy_scan_bytes (const char *bytes, int len);
    extern void yypop_buffer_state ();
    
    using namespace Guikachu;
    using namespace Guikachu::IO;

    namespace Guikachu
    {
	namespace IO
	{
	    namespace RCP
	    {
		std::string error;
		
		void setup (ResourceManager *manager, const std::string &uri);
		void finish ();
	    }
	}
    }
    
    namespace
    {
	ResourceManager  *manager;
        IO::uri_holder_t  base_uri;
	
	union current_
	{
	    Resources::Dialog       *dialog;
	    Resources::Menu         *menu;
	    Resources::StringList   *stringlist;
	    Resources::Form         *form;
	    Resources::BitmapFamily *bitmap_family;
	} current;

	union current_widget_
	{
	    Widgets::Button          *button;
	    Widgets::Checkbox        *checkbox;
	    Widgets::Label           *label;
	    Widgets::PushButton      *pushbutton;
	    Widgets::SelectorTrigger *strigger;
	    Widgets::PopupTrigger    *ptrigger;
	    Widgets::TextField       *field;
	    Widgets::List            *lst;
	    Widgets::Table           *table;
	    Widgets::ScrollBar       *scrollbar;
            Widgets::FormBitmap      *bitmap;
            Widgets::Slider          *slider;
	} current_widget;

	Widget *previous_widget;
	
	struct current_pos_size_
	{
	    RCP::Expr::Expr *x;
	    RCP::Expr::Expr *y;
	    RCP::Expr::Expr *width;
            bool             width_auto;
	    RCP::Expr::Expr *height;
            bool             height_auto;
	} current_pos_size;

        Resources::Bitmap::BitmapType current_bitmap_type;

	Glib::ustring create_child_uri (const Glib::ustring child)
	{
#ifdef GUIKACHU_HAVE_GNOMEVFS
            IO::uri_holder_t child_uri = base_uri->append_path (child);
            return child_uri->to_string ();
#else
            return Glib::build_filename (base_uri, child);
#endif
	}
	
	namespace StringList
	{
	    std::vector<std::string> strings;

	    void import_string (const std::string &button)
	    {
		strings.push_back (button);
	    }
	    
	    void import_end ()
	    {
		current.stringlist->strings = strings;
		strings.clear ();
	    }
	}

	namespace Dialog
	{
	    void import_button (const std::string &button)
	    {
		std::vector<std::string> buttons = current.dialog->buttons;
		buttons.push_back (button);
		current.dialog->buttons = buttons;
	    }
	}

	namespace BitmapFamily
	{
	    void import_bitmap (const std::string &bitmap_filename,
				int                bitmap_bpp)
	    {
		Glib::ustring bitmap_uri = create_child_uri (bitmap_filename);
		
		Resources::Bitmap::BitmapType type = Resources::Bitmap::TYPE_COLOR_256;
		switch (bitmap_bpp)
		{
		case 1:
		    type = Resources::Bitmap::TYPE_MONO;
		    break;
		case 2:
		    type = Resources::Bitmap::TYPE_GREY_4;
		    break;
		case 4:
		    type = Resources::Bitmap::TYPE_GREY_16;
		    break;
		case 5:
		    type = Resources::Bitmap::TYPE_COLOR_16;
		    break;
		case 8:
		    type = Resources::Bitmap::TYPE_COLOR_256;
		    break;
		case 16:
		    type = Resources::Bitmap::TYPE_COLOR_16K;
		    break;
		default:
		    /* WRITE ME */
		    break;
		}
		
		current.bitmap_family->load_file (type, bitmap_uri);
	    }
	}
	
	namespace Menu
	{
	    Resources::Menu::MenuTree submenus;
	    
	    void import_end ()
	    {
		current.menu->set_submenus (submenus);
		submenus.clear ();
	    }

	    void import_menu (const std::string &menu_label)
	    {
		submenus.push_back (Resources::Menu::Submenu (menu_label));
	    }
	    
	    void import_menuitem (const std::string &id, const std::string &label,
				  const std::string &shortcut = "")
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item (id, label, shortcut[0]);
		submenu.items.push_back (item);
	    }

	    void import_separator ()
	    {
		Resources::Menu::Submenu &submenu = submenus.back ();
		Resources::Menu::MenuItem item;
		submenu.items.push_back (item);
	    }
	}

	namespace Form
	{
	    typedef std::map<std::string, std::string> popuplist_map_t;
	    popuplist_map_t popuplist_map;
	    
	    void import_popuplist (const std::string &popup_id,
				   const std::string &list_id)
	    {
		popuplist_map[popup_id] = list_id;
	    }
	    
	    void import_end ()
	    {
		for (popuplist_map_t::const_iterator i = popuplist_map.begin ();
		     i != popuplist_map.end (); ++i)
		{
		    Widget *widget = current.form->get_widget (i->first);
		    Widgets::PopupTrigger *ptrigger = dynamic_cast<Widgets::PopupTrigger*> (widget);
		    if (ptrigger)
			ptrigger->list_id = i->second;
		}		
		
		popuplist_map.clear ();
	    }
	}

	namespace List
	{
	    std::vector<std::string> items;

	    void import_item (const std::string &item)
	    {
		items.push_back (item);
	    }

	    void apply_items ()
	    {
		current_widget.lst->items = items;
		items.clear ();
	    }
	}

	namespace Table
	{
	    std::vector<int> cols;

	    void import_col (int col)
	    {
		cols.push_back (col);
	    }

	    void import_end ()
	    {
		current_widget.table->column_width = cols;
		cols.clear ();
	    }
	}
	
	void widget_apply_pos (Widget *widget)
	{
	    widget->x = current_pos_size.x->eval (widget, previous_widget);
	    widget->y = current_pos_size.y->eval (widget, previous_widget);

            delete current_pos_size.x;
            delete current_pos_size.y;
	}
	    
	void widget_apply_pos_size (Widget *widget)
	{
	    Widgets::ResizeableWidget *resizeable =
		dynamic_cast<Widgets::ResizeableWidget*> (widget);

            if (!current_pos_size.width_auto)
		resizeable->width = current_pos_size.width->eval (widget, previous_widget);
            if (!current_pos_size.height_auto)
		resizeable->height = current_pos_size.height->eval (widget, previous_widget);

            delete current_pos_size.width;
            delete current_pos_size.height;

	    widget_apply_pos (widget);
        }
    }
    
    void RCP::setup (ResourceManager *manager_, const Glib::ustring &uri)
    {
	manager = manager_;
	error = "";

	// Store base URI
#ifdef GUIKACHU_HAVE_GNOMEVFS
        IO::uri_holder_t orig_uri = Gnome::Vfs::Uri::create (uri);
	base_uri = orig_uri->get_parent ();
#else
        base_uri = Glib::path_get_dirname (uri);
#endif
    }

    void RCP::finish ()
    {
	yypop_buffer_state ();
    }
    
    /* parse errors */
    void yyerror(const char *s) {
	char *buffer = g_strdup_printf (_("%s at line %d near `%s'"),
					s, lexer_lineno, yytext);
	IO::RCP::error = buffer;
	g_free (buffer);
    }


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 346 "parser.yy"
{
    char                          *str;
    int                            num;
    Guikachu::IO::RCP::Expr::Expr *expr;
}
/* Line 193 of yacc.c.  */
#line 681 "parser.cc"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 694 "parser.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   553

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  127
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  115
/* YYNRULES -- Number of rules.  */
#define YYNRULES  299
/* YYNRULES -- Number of states.  */
#define YYNSTATES  473

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   381

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     6,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    30,    32,    35,    37,    39,
      41,    43,    45,    50,    57,    64,    66,    68,    70,    72,
      73,    81,    84,    85,    87,    89,    91,    93,    95,    98,
     101,   102,   110,   113,   114,   116,   118,   120,   122,   125,
     127,   128,   136,   139,   140,   142,   144,   146,   148,   150,
     153,   156,   157,   165,   168,   169,   171,   173,   174,   182,
     185,   186,   188,   190,   192,   194,   197,   199,   202,   205,
     210,   214,   218,   221,   222,   224,   226,   228,   230,   232,
     234,   236,   238,   241,   244,   245,   251,   254,   255,   258,
     260,   264,   266,   267,   274,   277,   278,   281,   284,   287,
     290,   291,   293,   294,   302,   305,   306,   308,   311,   312,
     314,   316,   319,   321,   322,   329,   332,   333,   335,   338,
     341,   344,   347,   348,   355,   358,   359,   361,   363,   365,
     367,   370,   373,   376,   379,   382,   385,   386,   393,   396,
     397,   399,   401,   403,   405,   407,   409,   411,   413,   415,
     417,   419,   421,   424,   426,   428,   434,   439,   442,   443,
     445,   447,   449,   451,   453,   455,   458,   461,   464,   467,
     468,   471,   475,   477,   479,   481,   483,   485,   487,   489,
     491,   493,   495,   497,   499,   501,   502,   510,   513,   514,
     517,   519,   521,   523,   525,   528,   531,   532,   535,   538,
     541,   544,   545,   547,   551,   555,   558,   562,   563,   569,
     572,   573,   575,   576,   582,   584,   586,   588,   590,   592,
     594,   597,   598,   600,   602,   604,   606,   608,   613,   616,
     619,   621,   623,   625,   626,   635,   636,   645,   647,   648,
     656,   659,   660,   661,   668,   669,   676,   679,   680,   681,
     688,   691,   692,   697,   700,   704,   706,   710,   714,   718,
     722,   726,   730,   732,   736,   740,   744,   748,   752,   754,
     756,   758,   762,   766,   768,   770,   772,   774,   776,   778,
     780,   782,   786,   790,   792,   794,   796,   798,   800,   802
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     128,     0,    -1,   128,   129,    -1,    -1,   193,    -1,   207,
      -1,   210,    -1,   208,    -1,   209,    -1,   199,    -1,   214,
      -1,   219,    -1,   229,    -1,   121,    -1,     3,   121,    -1,
       4,    -1,    94,   122,    -1,    43,    -1,    44,    -1,    45,
      -1,    46,    -1,    47,    -1,     7,   237,   238,     8,    -1,
       7,   237,   238,   138,   139,     8,    -1,     7,   237,   238,
     237,   238,     8,    -1,   237,    -1,    42,    -1,   238,    -1,
      42,    -1,    -1,    26,   236,   130,    88,   136,   141,   142,
      -1,   142,   143,    -1,    -1,   131,    -1,   132,    -1,   133,
      -1,   134,    -1,    67,    -1,    68,   121,    -1,    69,   121,
      -1,    -1,    28,   236,   130,    88,   136,   145,   146,    -1,
     146,   147,    -1,    -1,   131,    -1,   132,    -1,   133,    -1,
     134,    -1,    96,   122,    -1,    90,    -1,    -1,    29,   236,
     130,    88,   136,   149,   150,    -1,   150,   151,    -1,    -1,
     131,    -1,   134,    -1,   132,    -1,   133,    -1,    67,    -1,
      68,   121,    -1,    69,   121,    -1,    -1,    30,   236,   130,
      88,   135,   153,   154,    -1,   154,   155,    -1,    -1,   131,
      -1,   132,    -1,    -1,    31,   236,   130,    88,   136,   157,
     158,    -1,   158,   159,    -1,    -1,   131,    -1,   132,    -1,
     133,    -1,   134,    -1,    96,   122,    -1,    67,    -1,    68,
     121,    -1,    69,   121,    -1,   161,    88,   136,   162,    -1,
      25,   236,   130,    -1,    27,   236,   130,    -1,   162,   163,
      -1,    -1,   131,    -1,   132,    -1,   133,    -1,    49,    -1,
      48,    -1,    50,    -1,   134,    -1,    67,    -1,    68,   121,
      -1,    69,   121,    -1,    -1,    36,    88,   135,   165,   166,
      -1,   167,   166,    -1,    -1,    19,   121,    -1,   132,    -1,
      32,    88,   135,    -1,    33,    -1,    -1,    39,   130,    88,
     136,   170,   171,    -1,   172,   171,    -1,    -1,    60,   122,
      -1,    61,   122,    -1,    62,   173,    -1,   174,   173,    -1,
      -1,   122,    -1,    -1,    35,   177,   130,    88,   136,   176,
     179,    -1,   178,   177,    -1,    -1,   236,    -1,   180,   179,
      -1,    -1,   132,    -1,   131,    -1,    58,   122,    -1,    59,
      -1,    -1,    38,   130,    88,   136,   182,   183,    -1,   184,
     183,    -1,    -1,   132,    -1,    63,   122,    -1,    64,   122,
      -1,    65,   122,    -1,    66,   122,    -1,    -1,    41,   130,
      88,   136,   186,   187,    -1,   188,   187,    -1,    -1,   132,
      -1,   133,    -1,    56,    -1,    57,    -1,    70,   121,    -1,
      71,   121,    -1,    63,   122,    -1,    64,   122,    -1,    65,
     122,    -1,    66,   122,    -1,    -1,    34,   130,    88,   136,
     190,   191,    -1,   192,   191,    -1,    -1,   132,    -1,   133,
      -1,   131,    -1,    93,    -1,   102,    -1,   109,    -1,   107,
      -1,   101,    -1,    92,    -1,    54,    -1,    53,    -1,    55,
      -1,    97,   122,    -1,    51,    -1,    52,    -1,   194,   195,
       5,   197,     6,    -1,    95,   130,    88,   137,    -1,   195,
     196,    -1,    -1,    48,    -1,    49,    -1,    43,    -1,   100,
      -1,   105,    -1,   103,    -1,    11,   121,    -1,    12,   121,
      -1,    13,   121,    -1,   197,   198,    -1,    -1,   108,   236,
      -1,    38,   130,   121,    -1,   160,    -1,   156,    -1,   152,
      -1,   148,    -1,   140,    -1,   189,    -1,   144,    -1,   168,
      -1,   169,    -1,   181,    -1,   185,    -1,   175,    -1,   164,
      -1,    -1,    15,   130,   200,   201,     5,   203,     6,    -1,
     201,   202,    -1,    -1,    91,   122,    -1,    22,    -1,    21,
      -1,    23,    -1,    24,    -1,    11,   130,    -1,   203,   204,
      -1,    -1,   108,   236,    -1,    99,   236,    -1,    89,   205,
      -1,   205,   206,    -1,    -1,   236,    -1,    17,   130,   236,
      -1,   110,   130,   236,    -1,   110,   236,    -1,    14,   130,
     236,    -1,    -1,    18,   130,   236,   211,   212,    -1,   213,
     212,    -1,    -1,   236,    -1,    -1,   216,   130,   236,   215,
     217,    -1,    19,    -1,    72,    -1,    73,    -1,    74,    -1,
      75,    -1,    76,    -1,   218,   217,    -1,    -1,    80,    -1,
      79,    -1,    81,    -1,    83,    -1,    82,    -1,    84,   122,
     122,   122,    -1,    85,   121,    -1,    86,   121,    -1,   220,
      -1,   222,    -1,   224,    -1,    -1,    20,   130,   236,   236,
     236,   236,   221,   217,    -1,    -1,    77,   130,   236,   236,
     236,   236,   223,   217,    -1,    78,    -1,    -1,    20,   130,
     225,   217,     5,   226,     6,    -1,   227,   226,    -1,    -1,
      -1,    19,   236,    87,   122,   228,   217,    -1,    -1,    16,
     130,   230,     5,   231,     6,    -1,   232,   231,    -1,    -1,
      -1,   104,   236,   233,     5,   234,     6,    -1,   234,   235,
      -1,    -1,    98,   236,   130,   236,    -1,    98,   106,    -1,
      98,   236,   130,    -1,   120,    -1,   120,    10,   236,    -1,
     237,   123,   237,    -1,   237,   124,   237,    -1,   237,   125,
     237,    -1,   237,   126,   237,    -1,     7,   237,     8,    -1,
     239,    -1,   238,   123,   238,    -1,   238,   124,   238,    -1,
     238,   125,   238,    -1,   238,   126,   238,    -1,     7,   238,
       8,    -1,   240,    -1,   241,    -1,   111,    -1,   111,     9,
     237,    -1,   112,     9,   237,    -1,   114,    -1,   115,    -1,
     118,    -1,   116,    -1,   117,    -1,   119,    -1,   241,    -1,
     111,    -1,   111,     9,   238,    -1,   113,     9,   238,    -1,
     114,    -1,   115,    -1,   118,    -1,   116,    -1,   117,    -1,
     119,    -1,   122,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   507,   507,   507,   510,   511,   512,   513,   514,   515,
     516,   517,   518,   522,   522,   522,   527,   528,   528,   529,
     530,   530,   532,   537,   542,   553,   554,   556,   557,   564,
     564,   573,   573,   574,   575,   576,   577,   578,   579,   580,
     587,   587,   596,   596,   597,   598,   599,   600,   601,   602,
     610,   610,   619,   619,   620,   621,   622,   623,   624,   625,
     626,   633,   633,   642,   642,   643,   644,   652,   652,   661,
     661,   662,   663,   664,   665,   666,   667,   668,   669,   676,
     681,   685,   692,   692,   693,   694,   695,   696,   697,   698,
     699,   700,   701,   702,   709,   709,   717,   717,   718,   719,
     726,   731,   738,   738,   747,   747,   748,   749,   750,   752,
     752,   753,   760,   760,   769,   769,   770,   774,   774,   775,
     776,   777,   778,   785,   785,   793,   793,   794,   795,   796,
     797,   798,   803,   803,   811,   811,   812,   813,   814,   815,
     816,   817,   818,   819,   820,   821,   827,   827,   837,   837,
     838,   839,   840,   841,   842,   843,   844,   845,   846,   847,
     848,   849,   850,   851,   852,   858,   860,   871,   871,   872,
     873,   874,   875,   876,   877,   878,   879,   880,   882,   882,
     883,   884,   885,   886,   887,   888,   889,   890,   891,   892,
     893,   894,   895,   896,   897,   904,   904,   910,   910,   911,
     912,   913,   914,   915,   916,   919,   919,   920,   921,   922,
     924,   924,   925,   932,   944,   945,   947,   954,   954,   961,
     961,   962,   969,   969,   979,   980,   981,   982,   983,   984,
     987,   987,   988,   988,   988,   989,   989,   990,   991,   992,
     999,   999,   999,  1001,  1000,  1017,  1016,  1032,  1032,  1032,
    1037,  1037,  1038,  1038,  1046,  1046,  1051,  1051,  1052,  1052,
    1055,  1055,  1056,  1057,  1058,  1065,  1066,  1072,  1073,  1074,
    1075,  1076,  1077,  1079,  1080,  1081,  1082,  1083,  1084,  1086,
    1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,  1095,  1097,
    1098,  1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,  1108
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID_TOKEN", "AUTOID", "BEG", "END",
  "LBRACE", "RBRACE", "ATSIGN", "BACKSLASH", "HELPID", "MENUID",
  "DEFAULTBTNID", "APPLICATIONICONNAME", "ALERT", "MENU", "STRING",
  "STRINGTABLE", "BITMAP", "BITMAPFAMILY", "DIALOG_CONFIRMATION",
  "DIALOG_INFORMATION", "DIALOG_WARNING", "DIALOG_ERROR", "BUTTON",
  "POPUPTRIGGER", "REPEATBUTTON", "CHECKBOX", "SELECTORTRIGGER", "LABEL",
  "PUSHBUTTON", "GRAFFITISTATEINDICATOR", "NOGRAFFITISTATEINDICATOR",
  "FIELD", "LIST", "FORMBITMAP", "GADGET", "POPUPLIST", "TABLE",
  "SCROLLBAR", "SLIDER", "AUTO", "USABLE", "NONUSABLE", "DISABLED",
  "LEFTANCHOR", "RIGHTANCHOR", "FRAME", "NOFRAME", "BOLDFRAME",
  "LEFTALIGN", "RIGHTALIGN", "NUMERIC", "AUTOSHIFT", "HASSCROLLBAR",
  "VERTICAL", "FEEDBACK", "VISIBLEITEMS", "SEARCH", "ROWS", "COLUMNS",
  "COLUMNWIDTHS", "VALUE", "MIN_VAL", "MAX_VAL", "PAGESIZE", "GRAPHICAL",
  "BITMAPID", "SELECTEDBITMAPID", "THUMBID", "BACKGROUNDID", "BITMAPGREY",
  "BITMAPGREY16", "BITMAPCOLOR16", "BITMAPCOLOR", "BITMAPCOLOR16K",
  "BITMAPFAMILYSPECIAL", "BITMAPFAMILYEX", "COMPRESS", "NOCOMPRESS",
  "FORCECOMPRESS", "COLORTABLE", "NOCOLORTABLE", "TRANSPARENT",
  "TRANSPARENTINDEX", "DENSITY", "BPP", "AT", "BUTTONS", "CHECKED",
  "DEFAULTBUTTON", "DYNAMICSIZE", "EDITABLE", "FONT", "FORM", "GROUP",
  "MAXCHARS", "MENUITEM", "MESSAGE", "MODAL", "MULTIPLELINES",
  "NONEDITABLE", "NOSAVEBEHIND", "PULLDOWN", "SAVEBEHIND", "SEPARATOR",
  "SINGLELINE", "TITLE", "UNDERLINED", "VERSION_TOKEN", "CENTER", "RIGHT",
  "BOTTOM", "PREVLEFT", "PREVRIGHT", "PREVTOP", "PREVBOTTOM", "PREVWIDTH",
  "PREVHEIGHT", "QUOTESTRING", "WORD", "NUMBER", "PLUS", "MINUS", "TIMES",
  "DIV", "$accept", "rcpfile", "resource", "identifier",
  "widget_prop_font", "widget_prop_usable", "widget_prop_disabled",
  "widget_prop_anchor", "POSITION", "POS_SIZE", "FORM_POS_SIZE", "hsize",
  "vsize", "widget_ptrigger", "@1", "widget_ptrigger_options",
  "widget_ptrigger_option", "widget_checkbox", "@2",
  "widget_checkbox_options", "widget_checkbox_option", "widget_strigger",
  "@3", "widget_strigger_options", "widget_strigger_option",
  "widget_label", "@4", "widget_label_options", "widget_label_option",
  "widget_pushbutton", "@5", "widget_pushbutton_options",
  "widget_pushbutton_option", "widget_button", "widget_button_begin",
  "widget_button_options", "widget_button_option", "widget_bitmap", "@6",
  "widget_bitmap_options", "widget_bitmap_option", "widget_graffiti",
  "widget_table", "@7", "widget_table_options", "widget_table_option",
  "widget_table_cols", "widget_table_col", "widget_list", "@8",
  "widget_list_items", "widget_list_item", "widget_list_options",
  "widget_list_option", "widget_scrollbar", "@9",
  "widget_scrollbar_options", "widget_scrollbar_option", "widget_slider",
  "@10", "widget_slider_options", "widget_slider_option", "widget_field",
  "@11", "widget_field_options", "widget_field_option", "res_form",
  "res_form_start", "res_form_options", "res_form_option",
  "res_form_children", "res_form_child", "res_dialog", "@12",
  "res_dialog_options", "res_dialog_option", "res_dialog_children",
  "res_dialog_child", "res_dialog_buttons", "res_dialog_button",
  "res_string", "res_app_ver", "res_app_name", "res_stringlist", "@13",
  "res_stringlist_strings", "res_stringlist_string", "res_bitmap", "@14",
  "res_bitmap_type", "res_bitmap_options", "res_bitmap_option",
  "res_bitmapfamily", "res_bitmapfamily_def", "@15",
  "res_bitmapfamily_special", "@16", "res_bitmapfamily_ex", "@17",
  "res_bitmapfamily_children", "res_bitmapfamily_child", "@18", "res_menu",
  "@19", "res_menu_menus", "res_menu_menu", "@20", "res_menu_children",
  "res_menu_child", "stringlit", "hexpr", "vexpr", "hexpr_atom",
  "vexpr_atom", "NUMLIT", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   127,   128,   128,   129,   129,   129,   129,   129,   129,
     129,   129,   129,   130,   130,   130,   131,   132,   132,   133,
     134,   134,   135,   136,   137,   138,   138,   139,   139,   141,
     140,   142,   142,   143,   143,   143,   143,   143,   143,   143,
     145,   144,   146,   146,   147,   147,   147,   147,   147,   147,
     149,   148,   150,   150,   151,   151,   151,   151,   151,   151,
     151,   153,   152,   154,   154,   155,   155,   157,   156,   158,
     158,   159,   159,   159,   159,   159,   159,   159,   159,   160,
     161,   161,   162,   162,   163,   163,   163,   163,   163,   163,
     163,   163,   163,   163,   165,   164,   166,   166,   167,   167,
     168,   168,   170,   169,   171,   171,   172,   172,   172,   173,
     173,   174,   176,   175,   177,   177,   178,   179,   179,   180,
     180,   180,   180,   182,   181,   183,   183,   184,   184,   184,
     184,   184,   186,   185,   187,   187,   188,   188,   188,   188,
     188,   188,   188,   188,   188,   188,   190,   189,   191,   191,
     192,   192,   192,   192,   192,   192,   192,   192,   192,   192,
     192,   192,   192,   192,   192,   193,   194,   195,   195,   196,
     196,   196,   196,   196,   196,   196,   196,   196,   197,   197,
     198,   198,   198,   198,   198,   198,   198,   198,   198,   198,
     198,   198,   198,   198,   198,   200,   199,   201,   201,   202,
     202,   202,   202,   202,   202,   203,   203,   204,   204,   204,
     205,   205,   206,   207,   208,   208,   209,   211,   210,   212,
     212,   213,   215,   214,   216,   216,   216,   216,   216,   216,
     217,   217,   218,   218,   218,   218,   218,   218,   218,   218,
     219,   219,   219,   221,   220,   223,   222,   224,   225,   224,
     226,   226,   228,   227,   230,   229,   231,   231,   233,   232,
     234,   234,   235,   235,   235,   236,   236,   237,   237,   237,
     237,   237,   237,   238,   238,   238,   238,   238,   238,   239,
     239,   239,   239,   239,   239,   239,   239,   239,   239,   240,
     240,   240,   240,   240,   240,   240,   240,   240,   240,   241
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     2,     1,     1,     1,
       1,     1,     4,     6,     6,     1,     1,     1,     1,     0,
       7,     2,     0,     1,     1,     1,     1,     1,     2,     2,
       0,     7,     2,     0,     1,     1,     1,     1,     2,     1,
       0,     7,     2,     0,     1,     1,     1,     1,     1,     2,
       2,     0,     7,     2,     0,     1,     1,     0,     7,     2,
       0,     1,     1,     1,     1,     2,     1,     2,     2,     4,
       3,     3,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     0,     5,     2,     0,     2,     1,
       3,     1,     0,     6,     2,     0,     2,     2,     2,     2,
       0,     1,     0,     7,     2,     0,     1,     2,     0,     1,
       1,     2,     1,     0,     6,     2,     0,     1,     2,     2,
       2,     2,     0,     6,     2,     0,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     0,     6,     2,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     5,     4,     2,     0,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     0,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     7,     2,     0,     2,
       1,     1,     1,     1,     2,     2,     0,     2,     2,     2,
       2,     0,     1,     3,     3,     2,     3,     0,     5,     2,
       0,     1,     0,     5,     1,     1,     1,     1,     1,     1,
       2,     0,     1,     1,     1,     1,     1,     4,     2,     2,
       1,     1,     1,     0,     8,     0,     8,     1,     0,     7,
       2,     0,     0,     6,     0,     6,     2,     0,     0,     6,
       2,     0,     4,     2,     3,     1,     3,     3,     3,     3,
       3,     3,     1,     3,     3,     3,     3,     3,     1,     1,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       3,     0,     1,     0,     0,     0,     0,     0,   224,     0,
     225,   226,   227,   228,   229,     0,   247,     0,     0,     2,
       4,   168,     9,     5,     7,     8,     6,    10,     0,    11,
     240,   241,   242,    12,     0,    15,    13,     0,   195,   254,
       0,     0,   248,     0,     0,   265,     0,   215,     0,     0,
      14,   216,   198,     0,   213,   217,   231,     0,     0,     0,
       0,   214,   179,     0,     0,     0,   171,   169,   170,   172,
     174,   173,   167,   222,     0,   257,   220,   233,   232,   234,
     236,   235,     0,     0,     0,     0,   231,     0,     0,     0,
     166,   266,     0,   175,   176,   177,   231,   206,     0,   201,
     200,   202,   203,     0,   197,     0,     0,   257,   218,   220,
     221,     0,   238,   239,   251,   230,     0,     0,     0,   280,
       0,   283,   284,   286,   287,   285,   288,   299,     0,   272,
     279,   165,     0,     0,     0,     0,     0,     0,     0,     0,
     101,     0,   115,     0,     0,     0,     0,     0,   186,   188,
     185,   184,   183,   182,     0,   194,   189,   190,   193,   191,
     192,   187,   178,   223,     0,   204,   199,   258,   255,   256,
     219,     0,     0,     0,   251,   243,   245,     0,     0,     0,
       0,   290,     0,   293,   294,   296,   297,   295,   298,     0,
       0,     0,     0,     0,   278,   289,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   115,   116,     0,     0,
       0,     0,   180,     0,   196,   211,     0,     0,   205,     0,
     237,     0,   249,   250,   231,   231,   271,   281,   282,     0,
       0,     0,   267,   268,   269,   270,     0,     0,     0,     0,
       0,    80,     0,    81,     0,     0,     0,     0,     0,   100,
       0,     0,   114,    94,     0,   181,     0,     0,     0,    83,
     209,   208,   207,   261,     0,   244,   246,   277,   291,   292,
     273,   274,   275,   276,     0,     0,     0,     0,     0,     0,
       0,   146,     0,    97,   123,   102,   132,     0,    79,   210,
     212,     0,   252,    24,    29,    40,    50,    61,    67,     0,
     149,   112,     0,    17,    18,    99,    95,    97,   126,   105,
     135,     0,    19,    20,    21,    88,    87,    89,    91,     0,
       0,     0,    84,    85,    86,    90,    82,   259,     0,   260,
     231,    32,    43,    53,    64,    70,    22,   163,   164,   160,
     159,   161,   158,   153,     0,   157,   154,   156,   155,   152,
     150,   151,   147,   149,   118,    98,    96,     0,     0,     0,
       0,   127,   124,   126,     0,     0,   110,   103,   105,   138,
     139,     0,     0,     0,     0,     0,     0,   136,   137,   133,
     135,    26,     0,    25,    92,    93,    16,   263,     0,   253,
      30,    41,    51,    62,    68,   162,   148,     0,   122,   120,
     119,   113,   118,   128,   129,   130,   131,   125,   106,   107,
     111,   108,   110,   104,   142,   143,   144,   145,   140,   141,
     134,    28,     0,    27,   264,    37,     0,     0,    33,    34,
      35,    36,    31,    49,     0,    44,    45,    46,    47,    42,
      58,     0,     0,    54,    56,    57,    55,    52,    65,    66,
      63,    76,     0,     0,     0,    71,    72,    73,    74,    69,
     121,   117,   109,    23,   262,    38,    39,    48,    59,    60,
      77,    78,    75
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,    19,    37,   349,   305,   351,   325,   249,   259,
      90,   382,   422,   148,   331,   390,   432,   149,   332,   391,
     439,   150,   333,   392,   447,   151,   334,   393,   450,   152,
     335,   394,   459,   153,   154,   288,   326,   155,   283,   306,
     307,   156,   157,   309,   367,   368,   411,   412,   158,   354,
     205,   206,   401,   402,   159,   308,   362,   363,   160,   310,
     379,   380,   161,   300,   352,   353,    20,    21,    48,    72,
      92,   162,    22,    52,    74,   104,   164,   218,   260,   289,
      23,    24,    25,    26,    76,   108,   109,    27,    96,    28,
      85,    86,    29,    30,   224,    31,   225,    32,    56,   173,
     174,   330,    33,    53,   106,   107,   219,   291,   329,   110,
     128,   193,   129,   194,   130
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -332
static const yytype_int16 yypact[] =
{
    -332,   358,  -332,     2,     2,     2,     2,     2,  -332,     2,
    -332,  -332,  -332,  -332,  -332,     2,  -332,     2,    10,  -332,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,     2,  -332,
    -332,  -332,  -332,  -332,  -111,  -332,  -332,  -100,  -332,  -332,
    -100,  -100,  -100,  -100,   -59,    26,  -100,  -332,   356,  -100,
    -332,  -332,  -332,    52,  -332,  -332,     9,  -100,  -100,    31,
    -100,  -332,  -332,   -57,   -56,   -53,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,   230,   -42,  -100,  -332,  -332,  -332,
    -332,  -332,   -47,   -39,   -38,    71,     9,  -100,  -100,   180,
    -332,  -332,   416,  -332,  -332,  -332,     9,  -332,     2,  -332,
    -332,  -332,  -332,   -25,  -332,  -100,    78,   -42,  -332,  -100,
    -332,   -16,  -332,  -332,    88,  -332,  -100,  -100,   180,    99,
     116,  -332,  -332,  -332,  -332,  -332,  -332,  -332,    67,  -332,
    -332,  -332,  -100,  -100,  -100,  -100,  -100,  -100,  -100,    54,
    -332,     2,  -100,    55,     2,     2,     2,  -100,  -332,  -332,
    -332,  -332,  -332,  -332,    61,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,    -3,  -332,  -332,  -332,  -332,  -332,
    -332,     5,  -100,   144,    88,  -332,  -332,    33,   180,   180,
     190,   142,   146,  -332,  -332,  -332,  -332,  -332,  -332,   180,
     180,   180,   180,   145,  -332,  -332,     2,     2,     2,     2,
       2,     2,     2,   154,    79,     2,  -100,  -332,   154,   -77,
      80,    82,  -332,   159,  -332,  -332,  -100,  -100,  -332,   170,
    -332,    89,  -332,  -332,     9,     9,  -332,  -332,  -332,    39,
     190,   190,  -109,  -109,  -332,  -332,   190,   190,   190,   190,
      67,  -332,    91,  -332,   106,   107,   108,   112,   180,  -332,
     159,   113,  -332,  -332,   159,  -332,   159,   159,   180,  -332,
    -100,  -332,  -332,  -332,    92,  -332,  -332,  -332,  -332,  -332,
     -99,   -99,  -332,  -332,   114,   159,   159,   159,   154,   159,
      67,  -332,   159,    11,  -332,  -332,  -332,    67,   426,  -332,
    -332,     3,  -332,  -332,  -332,  -332,  -332,  -332,  -332,   124,
     301,  -332,    56,  -332,  -332,  -332,  -332,    11,   322,   -12,
     482,    93,  -332,  -332,  -332,  -332,  -332,  -332,  -332,    81,
     100,    98,  -332,  -332,  -332,  -332,  -332,  -332,  -102,  -332,
       9,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,   109,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,   301,     8,  -332,  -332,   110,   121,   136,
     143,  -332,  -332,   322,   150,   151,   152,  -332,   -12,  -332,
    -332,   162,   163,   165,   166,   115,   155,  -332,  -332,  -332,
     482,  -332,   164,    13,  -332,  -332,  -332,  -332,     2,  -332,
     434,   368,   439,   -36,   295,  -332,  -332,   167,  -332,  -332,
    -332,  -332,     8,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,   152,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,   226,   193,  -100,  -332,   169,   172,  -332,  -332,
    -332,  -332,  -332,  -332,   178,  -332,  -332,  -332,  -332,  -332,
    -332,   192,   199,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,   201,   202,   207,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -332,  -332,  -332,    28,   -43,    27,   -66,  -331,  -193,   255,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,    23,
    -332,  -332,  -332,  -332,   -37,  -332,   -80,  -332,  -332,  -332,
     127,  -332,   -68,  -332,  -332,  -332,   -27,  -332,  -332,  -332,
     -23,  -332,  -332,  -332,   -10,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,
    -332,  -332,  -332,  -332,  -332,   251,  -332,  -332,  -332,  -332,
     -84,  -332,  -332,  -332,  -332,  -332,  -332,  -332,  -332,   196,
    -332,  -332,  -332,  -332,   264,  -332,  -332,  -332,  -332,   -18,
     -45,  -159,  -332,  -332,  -127
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint16 yytable[] =
{
      47,   195,   115,   214,   387,    34,    35,   303,   304,   327,
      50,   254,   163,    34,    35,   253,   191,   192,    45,    51,
      45,   229,    54,    55,    57,    58,   238,   239,    61,    59,
     302,    73,    38,    39,    40,    41,    60,    42,    89,    87,
      88,   226,    91,    43,   255,    44,    46,   267,   364,   365,
     366,   303,   304,   195,   303,   304,    49,    75,   321,   431,
     438,   446,   105,   458,    93,    94,   397,   398,    95,   116,
     117,   268,   269,   177,   180,   111,   114,   270,   271,   272,
     273,   274,   112,   113,   168,   297,   215,   167,    77,    78,
      79,    80,    81,    82,    83,    84,   216,   166,   175,   176,
     118,   328,   321,   195,   195,   217,   171,   172,   178,   195,
     195,   195,   195,   195,   196,   197,   198,   199,   200,   201,
     202,   299,   293,    36,   207,   179,   165,   220,   311,   212,
      45,    36,   336,   227,   228,   381,   189,   190,   191,   192,
     265,   266,   203,   208,   232,   233,   234,   235,   240,   213,
     222,   230,   118,   195,   221,   231,   189,   190,   191,   192,
     195,   248,   236,   237,   238,   239,   258,   250,   256,   204,
     257,   180,   209,   210,   211,   263,   264,   355,   181,   275,
     182,   183,   184,   185,   186,   187,   188,   118,   207,   127,
     189,   190,   191,   192,   276,   277,   278,   180,   261,   262,
     279,   282,   384,   280,   119,   120,   421,   121,   122,   123,
     124,   125,   126,   287,   292,   127,   236,   237,   238,   239,
     386,   385,   324,   423,   241,   242,   243,   244,   245,   246,
     247,   395,   403,   251,   463,    97,   418,   236,   237,   238,
     239,    98,   290,   404,   378,   322,   389,   236,   237,   238,
     239,    99,   100,   101,   102,   195,   119,   120,   405,   121,
     122,   123,   124,   125,   126,   406,   383,   127,   236,   237,
     238,   239,   408,   409,   410,   181,   419,   182,   183,   184,
     185,   186,   187,   188,   414,   415,   127,   416,   417,   460,
     465,   119,   120,   466,   121,   122,   123,   124,   125,   126,
     467,   181,   127,   182,   183,   184,   185,   186,   187,   188,
     388,   399,   127,   468,   378,   323,   236,   237,   238,   239,
     469,   103,   470,   471,   430,   437,   445,   350,   457,   472,
     356,   413,   462,   252,   461,   361,   407,   377,   303,   304,
     312,   313,   314,   396,   303,   304,   312,   428,   435,   443,
     448,   455,   337,   338,   339,   340,   341,   420,     2,   399,
     170,    62,   451,   452,   453,   303,   304,    63,    64,    65,
     223,   169,     3,     4,     5,     6,     7,     8,     9,     0,
     350,   400,     0,     0,     0,   357,   358,   359,   360,   321,
     361,   454,     0,   342,   343,   321,     0,     0,   344,    66,
       0,     0,   345,   346,    67,    68,   464,   377,   347,     0,
     348,   303,   304,   312,   313,   314,   424,   429,   436,   444,
     449,   456,   131,     0,     0,     0,     0,     0,     0,   400,
      10,    11,    12,    13,    14,    15,    16,     0,     0,     0,
       0,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,    17,   144,   145,    69,   146,   433,    70,
       0,    71,   321,     0,   434,     0,     0,     0,    18,   303,
     304,   312,   313,   314,   315,   316,   317,   303,   304,   312,
     313,   314,   303,   304,   312,   313,   314,     0,     0,     0,
       0,     0,     0,   318,   319,   320,     0,     0,     0,     0,
       0,   425,   426,   427,     0,   281,   440,   441,   442,   284,
       0,   285,   286,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,   147,   303,   304,   312,   321,     0,
     294,   295,   296,   321,   298,     0,     0,   301,   369,   370,
       0,     0,     0,     0,     0,   371,   372,   373,   374,     0,
       0,     0,   375,   376
};

static const yytype_int16 yycheck[] =
{
      18,   128,    86,     6,   106,     3,     4,    43,    44,     6,
     121,    88,    96,     3,     4,   208,   125,   126,   120,    37,
     120,   180,    40,    41,    42,    43,   125,   126,    46,    88,
      19,    49,     4,     5,     6,     7,    10,     9,     7,    57,
      58,     8,    60,    15,   121,    17,    18,     8,    60,    61,
      62,    43,    44,   180,    43,    44,    28,     5,    94,   390,
     391,   392,   104,   394,   121,   121,    58,    59,   121,    87,
      88,   230,   231,   118,     7,   122,     5,   236,   237,   238,
     239,   240,   121,   121,     6,   278,    89,   105,    79,    80,
      81,    82,    83,    84,    85,    86,    99,   122,   116,   117,
       7,    98,    94,   230,   231,   108,   122,    19,     9,   236,
     237,   238,   239,   240,   132,   133,   134,   135,   136,   137,
     138,   280,     8,   121,   142,     9,    98,   122,   287,   147,
     120,   121,     8,   178,   179,    42,   123,   124,   125,   126,
     224,   225,    88,    88,   189,   190,   191,   192,   193,    88,
       6,     9,     7,   280,   172,     9,   123,   124,   125,   126,
     287,     7,   123,   124,   125,   126,     7,    88,    88,   141,
      88,     7,   144,   145,   146,     5,    87,   121,   111,    88,
     113,   114,   115,   116,   117,   118,   119,     7,   206,   122,
     123,   124,   125,   126,    88,    88,    88,     7,   216,   217,
      88,    88,   121,   248,   111,   112,    42,   114,   115,   116,
     117,   118,   119,   258,   122,   122,   123,   124,   125,   126,
     122,   121,   288,   382,   196,   197,   198,   199,   200,   201,
     202,   122,   122,   205,     8,     5,   121,   123,   124,   125,
     126,    11,   260,   122,   310,   288,   330,   123,   124,   125,
     126,    21,    22,    23,    24,   382,   111,   112,   122,   114,
     115,   116,   117,   118,   119,   122,   311,   122,   123,   124,
     125,   126,   122,   122,   122,   111,   121,   113,   114,   115,
     116,   117,   118,   119,   122,   122,   122,   122,   122,   122,
     121,   111,   112,   121,   114,   115,   116,   117,   118,   119,
     122,   111,   122,   113,   114,   115,   116,   117,   118,   119,
     328,   354,   122,   121,   380,   288,   123,   124,   125,   126,
     121,    91,   121,   121,   390,   391,   392,   300,   394,   122,
     307,   368,   412,   206,   402,   308,   363,   310,    43,    44,
      45,    46,    47,   353,    43,    44,    45,   390,   391,   392,
     393,   394,    51,    52,    53,    54,    55,   380,     0,   402,
     109,     5,    67,    68,    69,    43,    44,    11,    12,    13,
     174,   107,    14,    15,    16,    17,    18,    19,    20,    -1,
     353,   354,    -1,    -1,    -1,    63,    64,    65,    66,    94,
     363,    96,    -1,    92,    93,    94,    -1,    -1,    97,    43,
      -1,    -1,   101,   102,    48,    49,   424,   380,   107,    -1,
     109,    43,    44,    45,    46,    47,   388,   390,   391,   392,
     393,   394,     6,    -1,    -1,    -1,    -1,    -1,    -1,   402,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    95,    38,    39,   100,    41,    90,   103,
      -1,   105,    94,    -1,    96,    -1,    -1,    -1,   110,    43,
      44,    45,    46,    47,    48,    49,    50,    43,    44,    45,
      46,    47,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    67,    68,    69,    -1,   250,    67,    68,    69,   254,
      -1,   256,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    -1,    -1,    -1,   108,    43,    44,    45,    94,    -1,
     275,   276,   277,    94,   279,    -1,    -1,   282,    56,    57,
      -1,    -1,    -1,    -1,    -1,    63,    64,    65,    66,    -1,
      -1,    -1,    70,    71
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   128,     0,    14,    15,    16,    17,    18,    19,    20,
      72,    73,    74,    75,    76,    77,    78,    95,   110,   129,
     193,   194,   199,   207,   208,   209,   210,   214,   216,   219,
     220,   222,   224,   229,     3,     4,   121,   130,   130,   130,
     130,   130,   130,   130,   130,   120,   130,   236,   195,   130,
     121,   236,   200,   230,   236,   236,   225,   236,   236,    88,
      10,   236,     5,    11,    12,    13,    43,    48,    49,   100,
     103,   105,   196,   236,   201,     5,   211,    79,    80,    81,
      82,    83,    84,    85,    86,   217,   218,   236,   236,     7,
     137,   236,   197,   121,   121,   121,   215,     5,    11,    21,
      22,    23,    24,    91,   202,   104,   231,   232,   212,   213,
     236,   122,   121,   121,     5,   217,   236,   236,     7,   111,
     112,   114,   115,   116,   117,   118,   119,   122,   237,   239,
     241,     6,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    38,    39,    41,   108,   140,   144,
     148,   152,   156,   160,   161,   164,   168,   169,   175,   181,
     185,   189,   198,   217,   203,   130,   122,   236,     6,   231,
     212,   122,    19,   226,   227,   236,   236,   237,     9,     9,
       7,   111,   113,   114,   115,   116,   117,   118,   119,   123,
     124,   125,   126,   238,   240,   241,   236,   236,   236,   236,
     236,   236,   236,    88,   130,   177,   178,   236,    88,   130,
     130,   130,   236,    88,     6,    89,    99,   108,   204,   233,
     122,   236,     6,   226,   221,   223,     8,   237,   237,   238,
       9,     9,   237,   237,   237,   237,   123,   124,   125,   126,
     237,   130,   130,   130,   130,   130,   130,   130,     7,   135,
      88,   130,   177,   135,    88,   121,    88,    88,     7,   136,
     205,   236,   236,     5,    87,   217,   217,     8,   238,   238,
     238,   238,   238,   238,   238,    88,    88,    88,    88,    88,
     237,   136,    88,   165,   136,   136,   136,   237,   162,   206,
     236,   234,   122,     8,   136,   136,   136,   135,   136,   238,
     190,   136,    19,    43,    44,   132,   166,   167,   182,   170,
     186,   238,    45,    46,    47,    48,    49,    50,    67,    68,
      69,    94,   131,   132,   133,   134,   163,     6,    98,   235,
     228,   141,   145,   149,   153,   157,     8,    51,    52,    53,
      54,    55,    92,    93,    97,   101,   102,   107,   109,   131,
     132,   133,   191,   192,   176,   121,   166,    63,    64,    65,
      66,   132,   183,   184,    60,    61,    62,   171,   172,    56,
      57,    63,    64,    65,    66,    70,    71,   132,   133,   187,
     188,    42,   138,   237,   121,   121,   122,   106,   236,   217,
     142,   146,   150,   154,   158,   122,   191,    58,    59,   131,
     132,   179,   180,   122,   122,   122,   122,   183,   122,   122,
     122,   173,   174,   171,   122,   122,   122,   122,   121,   121,
     187,    42,   139,   238,   130,    67,    68,    69,   131,   132,
     133,   134,   143,    90,    96,   131,   132,   133,   134,   147,
      67,    68,    69,   131,   132,   133,   134,   151,   131,   132,
     155,    67,    68,    69,    96,   131,   132,   133,   134,   159,
     122,   179,   173,     8,   236,   121,   121,   122,   121,   121,
     121,   121,   122
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 120: /* "QUOTESTRING" */
#line 494 "parser.yy"
	{ g_free ((yyvaluep->str)); };
#line 2116 "parser.cc"
	break;
      case 121: /* "WORD" */
#line 494 "parser.yy"
	{ g_free ((yyvaluep->str)); };
#line 2121 "parser.cc"
	break;
      case 236: /* "stringlit" */
#line 494 "parser.yy"
	{ g_free ((yyvaluep->str)); };
#line 2126 "parser.cc"
	break;

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 14:
#line 522 "parser.yy"
    { (yyval.str) = (yyvsp[(2) - (2)].str); }
    break;

  case 15:
#line 522 "parser.yy"
    { (yyval.str) = "_AUTO_"; }
    break;

  case 16:
#line 527 "parser.yy"
    { (yyval.num) = (yyvsp[(2) - (2)].num); }
    break;

  case 17:
#line 528 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 18:
#line 528 "parser.yy"
    { (yyval.num) = false; }
    break;

  case 19:
#line 529 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 20:
#line 530 "parser.yy"
    { (yyval.num) = false; }
    break;

  case 21:
#line 530 "parser.yy"
    { (yyval.num) = true; }
    break;

  case 22:
#line 532 "parser.yy"
    {
    current_pos_size.x = (yyvsp[(2) - (4)].expr);
    current_pos_size.y = (yyvsp[(3) - (4)].expr);
}
    break;

  case 23:
#line 537 "parser.yy"
    {
    current_pos_size.x = (yyvsp[(2) - (6)].expr);
    current_pos_size.y = (yyvsp[(3) - (6)].expr);
}
    break;

  case 24:
#line 542 "parser.yy"
    {
    current_pos_size.x = (yyvsp[(2) - (6)].expr);
    current_pos_size.y = (yyvsp[(3) - (6)].expr);
    current_pos_size.width_auto = false;
    
    current_pos_size.width = (yyvsp[(4) - (6)].expr);
    current_pos_size.height_auto = false;
    current_pos_size.height = (yyvsp[(5) - (6)].expr);
}
    break;

  case 25:
#line 553 "parser.yy"
    { current_pos_size.width_auto = false; current_pos_size.width = (yyvsp[(1) - (1)].expr); }
    break;

  case 26:
#line 554 "parser.yy"
    { current_pos_size.width_auto = true; current_pos_size.width = 0; }
    break;

  case 27:
#line 556 "parser.yy"
    { current_pos_size.height_auto = false; current_pos_size.height = (yyvsp[(1) - (1)].expr); }
    break;

  case 28:
#line 557 "parser.yy"
    { current_pos_size.height_auto = true; current_pos_size.height = 0; }
    break;

  case 29:
#line 564 "parser.yy"
    {
    current_widget.ptrigger = dynamic_cast<Widgets::PopupTrigger*> (
	current.form->create_widget (Widgets::WIDGET_POPUP_TRIGGER, (yyvsp[(3) - (5)].str), true));
    current_widget.ptrigger->text = (yyvsp[(2) - (5)].str);
}
    break;

  case 30:
#line 568 "parser.yy"
    {
    widget_apply_pos_size (current_widget.ptrigger);
    previous_widget = current_widget.ptrigger;
}
    break;

  case 33:
#line 574 "parser.yy"
    { current_widget.ptrigger->font = (yyvsp[(1) - (1)].num); }
    break;

  case 34:
#line 575 "parser.yy"
    { current_widget.ptrigger->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 35:
#line 576 "parser.yy"
    { current_widget.ptrigger->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 36:
#line 577 "parser.yy"
    { current_widget.ptrigger->anchor_right = (yyvsp[(1) - (1)].num); }
    break;

  case 38:
#line 579 "parser.yy"
    { current_widget.ptrigger->bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 39:
#line 580 "parser.yy"
    { current_widget.ptrigger->selected_bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 40:
#line 587 "parser.yy"
    {
    current_widget.checkbox = dynamic_cast<Widgets::Checkbox*> (
	current.form->create_widget (Widgets::WIDGET_CHECKBOX, (yyvsp[(3) - (5)].str), true));
    current_widget.checkbox->text = (yyvsp[(2) - (5)].str);
}
    break;

  case 41:
#line 591 "parser.yy"
    {
    widget_apply_pos_size (current_widget.checkbox);
    previous_widget = current_widget.checkbox;
}
    break;

  case 44:
#line 597 "parser.yy"
    { current_widget.checkbox->font = (yyvsp[(1) - (1)].num); }
    break;

  case 45:
#line 598 "parser.yy"
    { current_widget.checkbox->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 46:
#line 599 "parser.yy"
    { current_widget.checkbox->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 47:
#line 600 "parser.yy"
    { current_widget.checkbox->anchor_right = (yyvsp[(1) - (1)].num); }
    break;

  case 48:
#line 601 "parser.yy"
    { current_widget.checkbox->group = (yyvsp[(2) - (2)].num); }
    break;

  case 49:
#line 602 "parser.yy"
    { current_widget.checkbox->toggled = true; }
    break;

  case 50:
#line 610 "parser.yy"
    {
    current_widget.strigger = dynamic_cast<Widgets::SelectorTrigger*> (
	current.form->create_widget (Widgets::WIDGET_SELECTOR_TRIGGER, (yyvsp[(3) - (5)].str), true));
    current_widget.strigger->text = (yyvsp[(2) - (5)].str);
}
    break;

  case 51:
#line 614 "parser.yy"
    {
    widget_apply_pos_size (current_widget.strigger);
    previous_widget = current_widget.strigger;
}
    break;

  case 54:
#line 620 "parser.yy"
    { current_widget.strigger->font = (yyvsp[(1) - (1)].num); }
    break;

  case 55:
#line 621 "parser.yy"
    { current_widget.strigger->anchor_right = (yyvsp[(1) - (1)].num); }
    break;

  case 56:
#line 622 "parser.yy"
    { current_widget.strigger->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 57:
#line 623 "parser.yy"
    { current_widget.strigger->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 59:
#line 625 "parser.yy"
    { current_widget.strigger->bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 60:
#line 626 "parser.yy"
    { current_widget.strigger->selected_bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 61:
#line 633 "parser.yy"
    {
    current_widget.label = dynamic_cast<Widgets::Label*> (
	current.form->create_widget (Widgets::WIDGET_LABEL, (yyvsp[(3) - (5)].str), true));
    current_widget.label->text = (yyvsp[(2) - (5)].str);
}
    break;

  case 62:
#line 637 "parser.yy"
    {
    widget_apply_pos (current_widget.label);
    previous_widget = current_widget.label;
}
    break;

  case 65:
#line 643 "parser.yy"
    { current_widget.label->font = (yyvsp[(1) - (1)].num); }
    break;

  case 66:
#line 644 "parser.yy"
    { current_widget.label->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 67:
#line 652 "parser.yy"
    {
    current_widget.pushbutton = dynamic_cast<Widgets::PushButton*> (
	current.form->create_widget (Widgets::WIDGET_PUSHBUTTON, (yyvsp[(3) - (5)].str), true));
    current_widget.pushbutton->text = (yyvsp[(2) - (5)].str);
}
    break;

  case 68:
#line 656 "parser.yy"
    {
    widget_apply_pos_size (current_widget.pushbutton);
    previous_widget = current_widget.pushbutton;
}
    break;

  case 71:
#line 662 "parser.yy"
    { current_widget.pushbutton->font = (yyvsp[(1) - (1)].num); }
    break;

  case 72:
#line 663 "parser.yy"
    { current_widget.pushbutton->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 73:
#line 664 "parser.yy"
    { current_widget.pushbutton->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 74:
#line 665 "parser.yy"
    { current_widget.pushbutton->anchor_right = (yyvsp[(1) - (1)].num); }
    break;

  case 75:
#line 666 "parser.yy"
    { current_widget.pushbutton->group = (yyvsp[(2) - (2)].num); }
    break;

  case 77:
#line 668 "parser.yy"
    { current_widget.pushbutton->bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 78:
#line 669 "parser.yy"
    { current_widget.pushbutton->selected_bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 79:
#line 676 "parser.yy"
    {
    widget_apply_pos_size (current_widget.button);
    previous_widget = current_widget.button;
}
    break;

  case 80:
#line 681 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, (yyvsp[(3) - (3)].str), true));
    current_widget.button->text = (yyvsp[(2) - (3)].str);
}
    break;

  case 81:
#line 685 "parser.yy"
    {
    current_widget.button = dynamic_cast<Widgets::Button*> (
	current.form->create_widget (Widgets::WIDGET_BUTTON, (yyvsp[(3) - (3)].str), true));
    current_widget.button->text = (yyvsp[(2) - (3)].str);
    current_widget.button->repeat = true;
}
    break;

  case 84:
#line 693 "parser.yy"
    { current_widget.button->font = (yyvsp[(1) - (1)].num); }
    break;

  case 85:
#line 694 "parser.yy"
    { current_widget.button->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 86:
#line 695 "parser.yy"
    { current_widget.button->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 87:
#line 696 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_NONE; }
    break;

  case 88:
#line 697 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_SIMPLE; }
    break;

  case 89:
#line 698 "parser.yy"
    { current_widget.button->frame = Widgets::Button::FRAME_BOLD; }
    break;

  case 90:
#line 699 "parser.yy"
    { current_widget.button->anchor_right = (yyvsp[(1) - (1)].num); }
    break;

  case 92:
#line 701 "parser.yy"
    { current_widget.button->bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 93:
#line 702 "parser.yy"
    { current_widget.button->selected_bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 94:
#line 709 "parser.yy"
    {
    current_widget.bitmap = dynamic_cast<Widgets::FormBitmap*> (
	current.form->create_widget (Widgets::WIDGET_FORMBITMAP));
}
    break;

  case 95:
#line 712 "parser.yy"
    {
    widget_apply_pos (current_widget.bitmap);
    previous_widget = current_widget.bitmap;
}
    break;

  case 98:
#line 718 "parser.yy"
    { current_widget.bitmap->bitmap_id = (yyvsp[(2) - (2)].str); }
    break;

  case 99:
#line 719 "parser.yy"
    { current_widget.bitmap->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 100:
#line 726 "parser.yy"
    {
    Widgets::Graffiti *graffiti = dynamic_cast<Widgets::Graffiti*> (
	current.form->create_widget (Widgets::WIDGET_GRAFFITI));
    widget_apply_pos (graffiti);
    previous_widget = graffiti;
}
    break;

  case 102:
#line 738 "parser.yy"
    {
    current_widget.table = dynamic_cast<Widgets::Table*> (
	current.form->create_widget (Widgets::WIDGET_TABLE, (yyvsp[(2) - (4)].str), true));
}
    break;

  case 103:
#line 741 "parser.yy"
    {
    Table::import_end ();
    widget_apply_pos_size (current_widget.table);
    previous_widget = current_widget.table;
}
    break;

  case 106:
#line 748 "parser.yy"
    { current_widget.table->num_rows = (yyvsp[(2) - (2)].num); }
    break;

  case 107:
#line 749 "parser.yy"
    { current_widget.table->num_columns = (yyvsp[(2) - (2)].num); }
    break;

  case 111:
#line 753 "parser.yy"
    { Table::import_col ((yyvsp[(1) - (1)].num)); }
    break;

  case 112:
#line 760 "parser.yy"
    {
    current_widget.lst = dynamic_cast<Widgets::List*> (
	current.form->create_widget (Widgets::WIDGET_LIST, (yyvsp[(3) - (5)].str), true));
    List::apply_items ();
}
    break;

  case 113:
#line 764 "parser.yy"
    {
    widget_apply_pos_size (current_widget.lst);
    previous_widget = current_widget.lst;
}
    break;

  case 116:
#line 770 "parser.yy"
    {
    List::import_item ((yyvsp[(1) - (1)].str));
}
    break;

  case 119:
#line 775 "parser.yy"
    { current_widget.lst->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 120:
#line 776 "parser.yy"
    { current_widget.lst->font = (yyvsp[(1) - (1)].num); }
    break;

  case 121:
#line 777 "parser.yy"
    { current_widget.lst->visible_items = (yyvsp[(2) - (2)].num); }
    break;

  case 122:
#line 778 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 123:
#line 785 "parser.yy"
    {
    current_widget.scrollbar = dynamic_cast<Widgets::ScrollBar*> (
	current.form->create_widget (Widgets::WIDGET_SCROLLBAR, (yyvsp[(2) - (4)].str), true));
}
    break;

  case 124:
#line 788 "parser.yy"
    {
    widget_apply_pos_size (current_widget.scrollbar);    
    previous_widget = current_widget.scrollbar;
}
    break;

  case 127:
#line 794 "parser.yy"
    { current_widget.scrollbar->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 128:
#line 795 "parser.yy"
    { current_widget.scrollbar->value = (yyvsp[(2) - (2)].num); }
    break;

  case 129:
#line 796 "parser.yy"
    { current_widget.scrollbar->min_value = (yyvsp[(2) - (2)].num); }
    break;

  case 130:
#line 797 "parser.yy"
    { current_widget.scrollbar->max_value = (yyvsp[(2) - (2)].num); }
    break;

  case 131:
#line 798 "parser.yy"
    { current_widget.scrollbar->page_size = (yyvsp[(2) - (2)].num); }
    break;

  case 132:
#line 803 "parser.yy"
    {
    current_widget.slider = dynamic_cast<Widgets::Slider*> (
        current.form->create_widget (Widgets::WIDGET_SLIDER, (yyvsp[(2) - (4)].str), true));
}
    break;

  case 133:
#line 806 "parser.yy"
    {
    widget_apply_pos_size (current_widget.slider);
    previous_widget = current_widget.slider;
}
    break;

  case 136:
#line 812 "parser.yy"
    { current_widget.slider->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 137:
#line 813 "parser.yy"
    { current_widget.slider->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 138:
#line 814 "parser.yy"
    { /* WRITE ME */ }
    break;

  case 139:
#line 815 "parser.yy"
    { current_widget.slider->feedback = true; }
    break;

  case 140:
#line 816 "parser.yy"
    { current_widget.slider->thumb_id = (yyvsp[(2) - (2)].str); }
    break;

  case 141:
#line 817 "parser.yy"
    { current_widget.slider->background_id = (yyvsp[(2) - (2)].str); }
    break;

  case 142:
#line 818 "parser.yy"
    { current_widget.slider->value = (yyvsp[(2) - (2)].num); }
    break;

  case 143:
#line 819 "parser.yy"
    { current_widget.slider->min_value = (yyvsp[(2) - (2)].num); }
    break;

  case 144:
#line 820 "parser.yy"
    { current_widget.slider->max_value = (yyvsp[(2) - (2)].num); }
    break;

  case 145:
#line 821 "parser.yy"
    { current_widget.slider->page_size = (yyvsp[(2) - (2)].num); }
    break;

  case 146:
#line 827 "parser.yy"
    {
    current_widget.field = dynamic_cast<Widgets::TextField*> (
	current.form->create_widget (Widgets::WIDGET_TEXT_FIELD, (yyvsp[(2) - (4)].str), true));
    current_widget.field->underline = false;
    current_widget.field->editable = false;
}
    break;

  case 147:
#line 832 "parser.yy"
    {
    widget_apply_pos_size (current_widget.field);
    previous_widget = current_widget.field;
}
    break;

  case 150:
#line 838 "parser.yy"
    { current_widget.field->usable = (yyvsp[(1) - (1)].num); }
    break;

  case 151:
#line 839 "parser.yy"
    { current_widget.field->disabled = (yyvsp[(1) - (1)].num); }
    break;

  case 152:
#line 840 "parser.yy"
    { current_widget.field->font = (yyvsp[(1) - (1)].num); }
    break;

  case 153:
#line 841 "parser.yy"
    { current_widget.field->editable = true; }
    break;

  case 154:
#line 842 "parser.yy"
    { current_widget.field->editable = false; }
    break;

  case 155:
#line 843 "parser.yy"
    { current_widget.field->underline = true; }
    break;

  case 156:
#line 844 "parser.yy"
    { current_widget.field->multi_line = false; }
    break;

  case 157:
#line 845 "parser.yy"
    { current_widget.field->multi_line = true; }
    break;

  case 158:
#line 846 "parser.yy"
    { current_widget.field->dynamic_size = true; }
    break;

  case 159:
#line 847 "parser.yy"
    { current_widget.field->auto_shift = true; }
    break;

  case 160:
#line 848 "parser.yy"
    { current_widget.field->numeric = true; }
    break;

  case 161:
#line 849 "parser.yy"
    { current_widget.field->has_scrollbar = true; }
    break;

  case 162:
#line 850 "parser.yy"
    { current_widget.field->max_length = (yyvsp[(2) - (2)].num); }
    break;

  case 163:
#line 851 "parser.yy"
    { current_widget.field->justify_right = false; }
    break;

  case 164:
#line 852 "parser.yy"
    { current_widget.field->justify_right = true; }
    break;

  case 165:
#line 858 "parser.yy"
    { Form::import_end (); }
    break;

  case 166:
#line 860 "parser.yy"
    {
    previous_widget = 0;
    
    current.form = dynamic_cast<Resources::Form*> (
	manager->create_resource (Resources::RESOURCE_FORM, (yyvsp[(2) - (4)].str)));
    current.form->x = current_pos_size.x->eval (0, 0);
    current.form->y = current_pos_size.y->eval (0, 0);
    current.form->width = current_pos_size.width->eval (0, 0);
    current.form->height = current_pos_size.height->eval (0, 0);
}
    break;

  case 169:
#line 872 "parser.yy"
    { current.form->frame = true; }
    break;

  case 170:
#line 873 "parser.yy"
    { current.form->frame = false; }
    break;

  case 171:
#line 874 "parser.yy"
    { /* Do nothing */ }
    break;

  case 172:
#line 875 "parser.yy"
    { current.form->modal = true; }
    break;

  case 173:
#line 876 "parser.yy"
    { current.form->savebehind = true; }
    break;

  case 174:
#line 877 "parser.yy"
    { current.form->savebehind = false; }
    break;

  case 175:
#line 878 "parser.yy"
    { current.form->help_id = (yyvsp[(2) - (2)].str); }
    break;

  case 176:
#line 879 "parser.yy"
    { current.form->menu_id = (yyvsp[(2) - (2)].str); }
    break;

  case 177:
#line 880 "parser.yy"
    { current.form->def_button = (yyvsp[(2) - (2)].str); }
    break;

  case 180:
#line 883 "parser.yy"
    { current.form->title = (yyvsp[(2) - (2)].str); }
    break;

  case 181:
#line 884 "parser.yy"
    { Form::import_popuplist ((yyvsp[(2) - (3)].str), (yyvsp[(3) - (3)].str)); }
    break;

  case 195:
#line 904 "parser.yy"
    {
    current.dialog = dynamic_cast<Resources::Dialog*> (
	manager->create_resource (Resources::RESOURCE_DIALOG, (yyvsp[(2) - (2)].str)));
}
    break;

  case 199:
#line 911 "parser.yy"
    { current.dialog->default_button = (yyvsp[(2) - (2)].num); }
    break;

  case 200:
#line 912 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_INFORMATION; }
    break;

  case 201:
#line 913 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_CONFIRMATION; }
    break;

  case 202:
#line 914 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_WARNING; }
    break;

  case 203:
#line 915 "parser.yy"
    { current.dialog->dialog_type = Resources::Dialog::TYPE_ERROR; }
    break;

  case 204:
#line 916 "parser.yy"
    { current.dialog->help_id = (yyvsp[(2) - (2)].str); }
    break;

  case 207:
#line 920 "parser.yy"
    { current.dialog->title = (yyvsp[(2) - (2)].str); }
    break;

  case 208:
#line 921 "parser.yy"
    { current.dialog->text = (yyvsp[(2) - (2)].str); }
    break;

  case 212:
#line 925 "parser.yy"
    { Dialog::import_button ((yyvsp[(1) - (1)].str)); }
    break;

  case 213:
#line 932 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_STRING, (yyvsp[(2) - (3)].str));
    Resources::String *str = dynamic_cast<Resources::String*> (res);

    str->text = (yyvsp[(3) - (3)].str);
}
    break;

  case 214:
#line 944 "parser.yy"
    { manager->get_application ()->version = (yyvsp[(3) - (3)].str); }
    break;

  case 215:
#line 945 "parser.yy"
    { manager->get_application ()->version = (yyvsp[(2) - (2)].str); }
    break;

  case 216:
#line 947 "parser.yy"
    {
    manager->get_application ()->iconname = (yyvsp[(3) - (3)].str); }
    break;

  case 217:
#line 954 "parser.yy"
    {
    current.stringlist = dynamic_cast<Resources::StringList*> (
	manager->create_resource (Resources::RESOURCE_STRINGLIST, (yyvsp[(2) - (3)].str)));

    current.stringlist->prefix = (yyvsp[(3) - (3)].str);
}
    break;

  case 218:
#line 959 "parser.yy"
    { StringList::import_end (); }
    break;

  case 221:
#line 962 "parser.yy"
    { StringList::import_string ((yyvsp[(1) - (1)].str)); }
    break;

  case 222:
#line 969 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAP, (yyvsp[(2) - (3)].str));
    Resources::Bitmap *bmp = dynamic_cast<Resources::Bitmap*> (res);

    bmp->bitmap_type = current_bitmap_type;
    std::string bitmap_uri = create_child_uri ((yyvsp[(3) - (3)].str));
    if (bitmap_uri != "")
	bmp->load_file (bitmap_uri);
}
    break;

  case 224:
#line 979 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_MONO; }
    break;

  case 225:
#line 980 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_4; }
    break;

  case 226:
#line 981 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_GREY_16; }
    break;

  case 227:
#line 982 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16; }
    break;

  case 228:
#line 983 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_256; }
    break;

  case 229:
#line 984 "parser.yy"
    { current_bitmap_type = Resources::Bitmap::TYPE_COLOR_16K; }
    break;

  case 243:
#line 1001 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[(2) - (6)].str));
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri ((yyvsp[(3) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(4) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(5) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(6) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 245:
#line 1017 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[(2) - (6)].str));
    Resources::BitmapFamily *bmpfam = dynamic_cast<Resources::BitmapFamily*> (res);    

    std::string bitmap_uri;
    if ((bitmap_uri = create_child_uri ((yyvsp[(3) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_MONO, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(4) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_GREY_4, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(5) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_16, bitmap_uri);
    if ((bitmap_uri = create_child_uri ((yyvsp[(6) - (6)].str))) != "")
	bmpfam->load_file (Resources::Bitmap::TYPE_COLOR_256, bitmap_uri);
}
    break;

  case 248:
#line 1032 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_BITMAPFAMILY, (yyvsp[(2) - (2)].str));
    current.bitmap_family = dynamic_cast<Resources::BitmapFamily*> (res);    
}
    break;

  case 252:
#line 1038 "parser.yy"
    {
    BitmapFamily::import_bitmap ((yyvsp[(2) - (4)].str), (yyvsp[(4) - (4)].num));
}
    break;

  case 254:
#line 1046 "parser.yy"
    {
    Resource *res = manager->create_resource (Resources::RESOURCE_MENU, (yyvsp[(2) - (2)].str));
    current.menu = dynamic_cast<Resources::Menu*> (res);
}
    break;

  case 255:
#line 1049 "parser.yy"
    { Menu::import_end (); }
    break;

  case 258:
#line 1052 "parser.yy"
    { Menu::import_menu ((yyvsp[(2) - (2)].str)); }
    break;

  case 262:
#line 1056 "parser.yy"
    { Menu::import_menuitem ((yyvsp[(3) - (4)].str), (yyvsp[(2) - (4)].str), (yyvsp[(4) - (4)].str)); }
    break;

  case 263:
#line 1057 "parser.yy"
    { Menu::import_separator (); }
    break;

  case 264:
#line 1058 "parser.yy"
    { Menu::import_menuitem ((yyvsp[(3) - (3)].str), (yyvsp[(2) - (3)].str)); }
    break;

  case 265:
#line 1065 "parser.yy"
    { (yyval.str) = g_strdup ((yyvsp[(1) - (1)].str)); }
    break;

  case 266:
#line 1066 "parser.yy"
    { (yyval.str) = g_strdup_printf ("%s%s", (yyvsp[(1) - (3)].str), (yyvsp[(3) - (3)].str)); }
    break;

  case 267:
#line 1072 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::add, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 268:
#line 1073 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::sub, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 269:
#line 1074 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::mul, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 270:
#line 1075 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::div, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 271:
#line 1076 "parser.yy"
    { (yyval.expr) = (yyvsp[(2) - (3)].expr); }
    break;

  case 273:
#line 1079 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::add, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 274:
#line 1080 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::sub, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 275:
#line 1081 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::mul, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 276:
#line 1082 "parser.yy"
    { (yyval.expr) = new RCP::Expr::BinFunction (RCP::Expr::Functions::div, (yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr)); }
    break;

  case 277:
#line 1083 "parser.yy"
    { (yyval.expr) = (yyvsp[(2) - (3)].expr); }
    break;

  case 280:
#line 1087 "parser.yy"
    { (yyval.expr) = new RCP::Expr::CenterHoriz; }
    break;

  case 281:
#line 1088 "parser.yy"
    { (yyval.expr) = new RCP::Expr::CenterHoriz ((yyvsp[(3) - (3)].expr)); }
    break;

  case 282:
#line 1089 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Right ((yyvsp[(3) - (3)].expr)); }
    break;

  case 283:
#line 1090 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevLeft; }
    break;

  case 284:
#line 1091 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevRight; }
    break;

  case 285:
#line 1092 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevWidth; }
    break;

  case 286:
#line 1093 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevTop; }
    break;

  case 287:
#line 1094 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevBottom; }
    break;

  case 288:
#line 1095 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevHeight; }
    break;

  case 290:
#line 1098 "parser.yy"
    { (yyval.expr) = new RCP::Expr::CenterVert; }
    break;

  case 291:
#line 1099 "parser.yy"
    { (yyval.expr) = new RCP::Expr::CenterVert ((yyvsp[(3) - (3)].expr)); }
    break;

  case 292:
#line 1100 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Bottom ((yyvsp[(3) - (3)].expr)); }
    break;

  case 293:
#line 1101 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevLeft; }
    break;

  case 294:
#line 1102 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevRight; }
    break;

  case 295:
#line 1103 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevWidth; }
    break;

  case 296:
#line 1104 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevTop; }
    break;

  case 297:
#line 1105 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevBottom; }
    break;

  case 298:
#line 1106 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Relative::PrevHeight; }
    break;

  case 299:
#line 1108 "parser.yy"
    { (yyval.expr) = new RCP::Expr::Literal ((yyvsp[(1) - (1)].num)); }
    break;


/* Line 1267 of yacc.c.  */
#line 3584 "parser.cc"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 1110 "parser.yy"


const char *yy_token_name(int token_index) {
  int internal_index = YYTRANSLATE(token_index);
  return yytname[internal_index];
}

