//$Id: ui-gui.cc,v 1.7 2004/07/12 21:49:04 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "ui-gui.h"
#include "session.h"

#include <gtkmm/alignment.h>
#include <gtkmm/label.h>
#include <gtkmm/image.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/main.h>
#include <libgnomeuimm/about.h>

#include <list>
#include <iostream>

using namespace Guikachu;

void UI::flush_events ()
{
    if (Guikachu::Main::initialized ())
	while (Gtk::Main::events_pending ())
	    Gtk::Main::iteration ();
}

void UI::show_about ()
{
    std::list<Glib::ustring> authors;
    authors.push_back ("Gerg\xC5\x91 \xC3\x89rdi");
    authors.push_back ("Jay Bloodworth");
    authors.push_back ("Christopher Keith Fairbairn");
    authors.push_back ("Nathan Kurz");

    std::list<Glib::ustring> documenters;
    
    // note to translators: please fill in your names and email addresses
    Glib::ustring translators = _("translator_credits");
    if (translators == "translator_credits")
	translators = "";
    
    static Gnome::UI::About *about = new Gnome::UI::About (
	"Guikachu", VERSION,
	"(C) 2001-2004 Gerg\xC5\x91 \xC3\x89rdi",
	authors,
	documenters,
	_("PalmOS resource file editor"),
	translators);

    about->show ();
}

void UI::show_error (const Glib::ustring &full_message,
		     const Glib::ustring &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gtk::MessageDialog dialog (full_message, true, Gtk::MESSAGE_ERROR,
                                   Gtk::BUTTONS_OK, true);
        dialog.run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Error: ") << short_message << std::endl;
    }
}

void UI::show_warning (const Glib::ustring &full_message,
		       const Glib::ustring &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gtk::MessageDialog dialog (full_message, true, Gtk::MESSAGE_WARNING,
                                   Gtk::BUTTONS_OK, true);
        dialog.run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Warning: ") << short_message << std::endl;
    }
}

Gtk::Button * UI::create_stock_button (const Gtk::StockID  &stock_id,
                                       const Glib::ustring &title)
{
    Gtk::Button *button = new Gtk::Button;
    
    Gtk::Alignment *alignment = new Gtk::Alignment (0.5, 0.5, 0, 0);
    Gtk::HBox *hbox = new Gtk::HBox (false, 2);
    hbox->pack_start (*manage (new Gtk::Image (stock_id, Gtk::ICON_SIZE_BUTTON)), Gtk::PACK_SHRINK);
    hbox->pack_start (*manage (new Gtk::Label (title)), Gtk::PACK_SHRINK);
    alignment->add (*manage (hbox));
    
    button->add (*manage (alignment));
    return button;
}
