//$Id: rcp-loader.cc,v 1.6 2004/06/12 12:14:32 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "rcp-loader.h"
#include "rcp/parser-interface.h"

#include "ui.h"

using namespace Guikachu;
using namespace Guikachu::IO;

namespace
{
    void show_error (const Glib::ustring &uri, const Glib::ustring &error_msg)
    {
	char *buffer = g_strdup_printf (_("Error while loading `%s':\n%s"),
					UI::visible_filename (uri).c_str (),
					error_msg.c_str ());
	UI::show_error (buffer);
	g_free (buffer);
    }
}

IOResult RCPLoader::load (ResourceManager *manager, const Glib::ustring &uri)
{
    // Load data from URI
    char             *data = 0;
    GnomeVFSFileSize  len;
    IOResult          res;
    
    if ((res = IO::load_uri (uri, data, len)) != GNOME_VFS_OK)
    {
	delete[] data;
	return res;
    }

    // Start the lexer
    yy_buffer_state* lex_buffer = yy_scan_bytes (data, len);
    delete[] data;

    // ...and the parser
    IO::RCP::setup (manager, uri);
    yyparse ();
    yy_delete_buffer (lex_buffer);
    
    if (IO::RCP::error != "")
    {
	show_error (uri, IO::RCP::error);
    }
    
    return GNOME_VFS_OK;
}
