//$Id: label-prop.cc,v 1.29 2004/06/25 17:15:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"
#include "widgets/font-combo.h"
#include "widgets/text.h"

#include "property-ops-widget.h"

using namespace Guikachu::GUI::FormEditor;

LabelProperties::LabelProperties (Widgets::Label *res):
    WidgetProperties (res)
{
    using WidgetOps::PropChangeOpFactory;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    add_general_controls (*proptable);

    /* Text */
    control = new GUI::PropertyEditors::TextArea (
	res->text,
	new PropChangeOpFactory<std::string> (_("Change text of %s"), res, res->text, true));
    proptable->add (_("_Text:"), *manage (control));

    /* Font */
    control = new GUI::PropertyEditors::FontCombo (
	res->font,
	new PropChangeOpFactory<int> (_("Change font of %s"), res, res->font, false));
    proptable->add (_("_Font:"), *manage (control));
    
    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (
	res->usable,
	new PropChangeOpFactory<bool> (_("Toggle usable state of %s"), res, res->usable, false));
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Separator */
    proptable->add_separator ();

    /* Position */
    add_position_controls (*proptable);
    
    proptable->show ();
    property_editor = proptable;
}

LabelProperties::~LabelProperties ()
{
    delete property_editor;
}

Gtk::Widget* LabelProperties::get_editor ()
{
    return property_editor;
}
