//$Id: form-editor-canvas.h,v 1.11 2004/06/10 15:51:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_CANVAS_H
#define GUIKACHU_FORM_EDITOR_CANVAS_H

#include <foocanvasmm/canvas.h>

#include "form-editor/font.h"
#include "bitmap-res.h"
#include "resource-ref.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
            FooCanvasmm::Item * draw_text (FooCanvasmm::Group &group,
                                           const std::string  &text,
                                           const Font         &font,
                                           const Gdk::Color   &color,
                                           int                 x,
                                           int                 y,
                                           int                 clip_width,
                                           int                 clip_height,
                                           Gtk::AnchorType     anchor = Gtk::ANCHOR_CENTER,
                                           bool                multi_line = false);
            
            Glib::RefPtr<Gdk::Pixbuf> render_bitmap (const Magick::Image           &image,
                                                     Resources::Bitmap::BitmapType  bitmap_type);
            
	    // Use this instead of Rectangle canvas items because
	    // those are shoddy
	    FooCanvasmm::Item * draw_rectangle (FooCanvasmm::Group &group,
                                                int x1, int y1,
                                                int x2, int y2);
	    
	    FooCanvasmm::Item * draw_pixbuf (FooCanvasmm::Group &group,
                                             GdkPixbuf          *pixbuf,
                                             int                 x = 0,
                                             int                 y = 0);
            
            FooCanvasmm::Item * draw_bitmap (FooCanvasmm::Group            &group,
                                             const Magick::Image           &image,
                                             Resources::Bitmap::BitmapType  bitmap_type,
                                             const Gdk::Color              &background_color,
                                             int                            x,
                                             int                            y,
                                             int                            clip_width = 0,
                                             int                            clip_height = 0,
                                             Gtk::AnchorType                anchor = Gtk::ANCHOR_NW);

            FooCanvasmm::Item * draw_bitmapref (FooCanvasmm::Group            &group,
                                                const Properties::ResourceRef &ref_prop,
                                                bool                           color,
                                                const Gdk::Color              &background_color,
                                                int                            x,
                                                int                            y,
                                                int                            clip_width = 0,
                                                int                            clip_height = 0,
                                                Gtk::AnchorType                anchor = Gtk::ANCHOR_NW);
	}
    }
}
    
#endif /* !GUIKACHU_FORM_EDITOR_CANVAS_H */
