//$Id: depthlist.cc,v 1.4 2004/06/25 17:15:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "depthlist.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu::GUI;

namespace
{
    typedef std::pair<Guikachu::Resources::Bitmap::BitmapType, Glib::ustring> depth_pair_t;
    typedef std::list<depth_pair_t> depth_list_t;

    const depth_list_t & get_depth_list ();    
} // anonymous namespace

DepthList::DepthList (Resources::BitmapFamily *res_):
    res (res_),
    update_block (false)
{
    Gtk::TreeModel::ColumnRecord cols;
    cols.add (col_label);
    cols.add (col_type);
    
    liststore = Gtk::ListStore::create (cols);
    set_model (liststore);
    
    append_column ("", col_label);
    set_headers_visible (false);

    get_selection ()->set_mode (Gtk::SELECTION_BROWSE);
    get_selection ()->signal_changed ().connect (
	sigc::mem_fun (*this, &DepthList::selection_changed_cb));
    
    res->changed.connect (sigc::mem_fun (*this, &DepthList::update));

    const depth_list_t &depth_list = get_depth_list ();
    for (depth_list_t::const_iterator i = depth_list.begin ();
         i != depth_list.end (); ++i)
        liststore->append ();
    get_selection ()->select (Gtk::TreeModel::Path ("0"));
    update ();
}

void DepthList::update ()
{
    update_block = true;

    const depth_list_t &depth_list = get_depth_list ();
    Gtk::ListStore::iterator store_iter = liststore->get_iter ("0");
    for (depth_list_t::const_iterator i = depth_list.begin ();
         i != depth_list.end (); ++i, ++store_iter)
    {
        char *label_str;
        if (res->get_image (i->first).isValid ())
            label_str = g_strdup (i->second.c_str ());
        else
            label_str = g_strdup_printf (_("%s (unset)"), i->second.c_str ());
        
        (*store_iter)[col_type] = i->first;
        (*store_iter)[col_label] = label_str;

        g_free (label_str);
    }
        
    update_block = false;
}

void DepthList::selection_changed_cb ()
{
    if (update_block)
        return;

    Gtk::TreeModel::iterator iter = get_selection ()->get_selected ();
    g_return_if_fail (iter);

    type_changed.emit ((*iter)[col_type]);
}

namespace
{
    const depth_list_t & get_depth_list ()
    {
        static depth_list_t depth_list;
        static bool depth_list_init = false;

        if (!depth_list_init)
        {
            using Guikachu::Resources::Bitmap;
            
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_MONO,      _("Monochrome")));
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_GREY_4,    _("Greyscale (4 shades)")));
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_GREY_16,   _("Greyscale (16 shades)")));
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_COLOR_16,  _("Color (16 colors)")));
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_COLOR_256, _("Color (256 colors)")));
            depth_list.push_back (depth_pair_t (Bitmap::TYPE_COLOR_16K, _("High Color (16k colors)")));

            depth_list_init = true;
        }
        
        return depth_list;
    }
} // anonymous namespace

