//$Id: bitmapfamily-res.h,v 1.5 2004/06/10 15:51:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_BITMAPFAMILY_RES_H
#define GUIKACHU_BITMAPFAMILY_RES_H

#include "resource.h"
#include "bitmap-res.h"

#include "hash-map.h"

namespace Guikachu
{
    namespace Resources
    {
	class BitmapFamily: public Resource
	{
	    typedef Resources::Bitmap::BitmapType BitmapType;
	    typedef std::hash_map<BitmapType, Magick::Image> image_map_t;
	    
	public:
	    BitmapFamily (ResourceManager *manager, const std::string &id, serial_t serial);

	    Type get_type () const { return RESOURCE_BITMAPFAMILY; };
	    void apply_visitor (ResourceVisitor &visitor) { visitor.visit_resource (this); };
	    Magick::Image get_image (BitmapType type) const;
	    
	    void load_file     (BitmapType type, const std::string &uri);
	    void save_file_bmp (BitmapType type, const std::string &uri) const;
            void set_image     (BitmapType type, const Magick::Blob &blob);
            void set_image     (BitmapType type, const Magick::Image &image);

	private:
	    image_map_t images;
	};
    }
}

#endif /* !GUIKACHU_BITMAPFAMILY_RES_H */
