//$Id: add-resource.h,v 1.12 2004/06/25 17:15:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_ADD_RESOURCE_H
#define GUIKACHU_ADD_RESOURCE_H

#include <glade/glade.h>
#include <gtkmm/entry.h>
#include <gtkmm/dialog.h>
#include <libglademm/xml.h>

#include "resource.h"
#include "resource-manager.h"

namespace Guikachu
{
    namespace GUI
    {
	class AddResourceWin: public sigc::trackable
	{
	    Glib::RefPtr<Gnome::Glade::Xml> gui;

	    Gtk::Dialog *dialog;
	    Gtk::Entry  *entry;

	    ResourceManager *manager;
	    Resources::Type  res_type;
	    
	public:
	    AddResourceWin (ResourceManager *manager);

	    void run (Gtk::Window *parent_win = 0);
	private:
	    void resource_type_cb (Resources::Type type);
	};
    }
}

#endif /* !GUIKACHU_ADD_RESOURCE_H */
