//$Id: add-resource.cc,v 1.29 2004/06/25 17:15:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "add-resource.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtkmm/optionmenu.h>
#include <gtkmm/menu.h>

#include "resource-manager.h"
#include "resource-manager-ops.h"

#include "ui.h"

using namespace Guikachu;

GUI::AddResourceWin::AddResourceWin (ResourceManager *manager_):
    gui (Gnome::Glade::Xml::create (GUIKACHU_GLADEDIR "/guikachu.glade", "dlg_add")),
    manager (manager_)
{
    Gtk::OptionMenu *optmenu;
    Gtk::Menu       *menu;
    
    gui->get_widget ("dlg_add", dialog);
    gui->get_widget ("add_name", entry);
    gui->get_widget ("add_type", optmenu);
    
    menu = optmenu->get_menu ();
    menu->items ().clear ();

#define ADD_TYPE(desc,t)                                                \
	menu->items ().push_back (Gtk::Menu_Helpers::MenuElem (desc,			\
		sigc::bind (sigc::mem_fun (*this, &AddResourceWin::resource_type_cb),	\
			    Resources::RESOURCE_##t)))
    
    ADD_TYPE(_("Form"),           FORM);
    ADD_TYPE(_("Dialog"),         DIALOG);
    ADD_TYPE(_("Menu"),           MENU);
    ADD_TYPE(_("Bitmap"),         BITMAP);
    ADD_TYPE(_("Bitmap group"),   BITMAPFAMILY);
    ADD_TYPE(_("String"),         STRING);
    ADD_TYPE(_("String list"),    STRINGLIST);
    ADD_TYPE(_("Free-text blob"), BLOB);

#undef ADD_TYPE
    
    optmenu->set_history (0);
    res_type = Resources::RESOURCE_FORM;
    
#if 0
    dialog->editable_enters (*entry);
    dialog->close_hides (true);
#endif
}

void GUI::AddResourceWin::run (Gtk::Window *parent_win)
{
    if (parent_win)
	dialog->set_transient_for (*parent_win);
    
    int dialog_result;

    dialog_result = dialog->run ();
    dialog->hide ();

    if (dialog_result == Gtk::RESPONSE_OK)
    {
	std::string id = entry->get_text ();
	
	Resource *res = manager->create_resource (res_type, id);
	if (!res)
	{
	    char *error_msg = g_strdup_printf (_("Non-unique identifier `%s'"), id.c_str ());
	    UI::show_error (error_msg);
	    g_free (error_msg);

	    return;
	}
	
	manager->get_undo_manager ().push (new ResourceOps::CreateOp (res));
    }
}

void GUI::AddResourceWin::resource_type_cb (Resources::Type type)
{
    res_type = type;
}
