//$Id: widget-combo.cc,v 1.17 2004/06/10 15:51:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu::GUI::PropertyEditors;

WidgetCombo::WidgetCombo (Widgets::Type    type,
			  property_t      &property_,
			  op_factory_t    *op_factory_):
    Gtk::HBox (false, 5),
    form (property_.get_form ()),
    button_edit (_("Edit...")),
    property (property_),
    op_factory (op_factory_)
{
    types.insert (type);
    
    create_widgets ();
}

WidgetCombo::WidgetCombo (const std::set<Widgets::Type> &types_,
			  property_t                    &property_,
			  op_factory_t                  *op_factory_):
    Gtk::HBox (false, 5),
    form (property_.get_form ()),
    button_edit (_("Edit...")),
    types (types_),
    property (property_),
    op_factory (op_factory_)
{
    create_widgets ();
}

void WidgetCombo::create_widgets ()
{
    combo.set_value_in_list (true, true);
    combo.set_use_arrows (true);
    combo.set_case_sensitive (false);
    combo.get_entry ()->set_editable (false);
    
    std::set<Guikachu::Widget*> widget_set = form->get_widgets ();

    std::list<std::string> empty_id_list;
    empty_id_list.push_back ("");
    combo.set_popdown_strings (empty_id_list);
    for (std::set<Guikachu::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	add_widget ((*i));
    
    button_edit.signal_clicked ().connect (slot (*this, &WidgetCombo::edit_cb));

    form->widget_created.connect (slot (*this, &WidgetCombo::add_widget));
    form->widget_removed.connect (slot (*this, &WidgetCombo::remove_widget));

    combo.get_entry ()->signal_changed ().connect (slot (*this, &WidgetCombo::entry_cb));
    
    pack_start (combo);
    pack_start (button_edit);
    underline_widget = &combo;

    property.changed.connect (slot (*this, &WidgetCombo::update));
    update ();
}

void WidgetCombo::add_widget (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
	return;
    
    update_block = true;

    std::string current = property;

    std::list<std::string> widget_ids = combo.get_popdown_strings ();
    widget_ids.push_back (widget->id);
    combo.set_popdown_strings (widget_ids);
    
    combo.get_entry ()->set_text (current);

    widget->changed.connect (SigC::bind (
	SigC::slot (*this, &WidgetCombo::widget_changed_cb), widget));
    
    update_block = false;
}

void WidgetCombo::remove_widget (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
	return;
    
    update_block = true;

    // This sucks, but we have to rebuild the whole list because
    // there's no other API to change a combo's list

    const std::set<Guikachu::Widget*> &widget_list = form->get_widgets ();
    std::list<std::string>             widget_id_list;

    widget_id_list.push_back ("");
    for (std::set<Guikachu::Widget*>::const_iterator i = widget_list.begin ();
	 i != widget_list.end (); ++i)
        if (types.find (widget->get_type ()) != types.end ())
	    widget_id_list.push_back ((*i)->id);
    
    combo.set_popdown_strings (widget_id_list);
    
    update_block = false;
}

void WidgetCombo::update ()
{
    update_block = true;
    
    combo.get_entry ()->set_text (property.get_val ());
    button_edit.set_sensitive (property != "");
    
    update_block = false;
}

void WidgetCombo::edit_cb ()
{
    Guikachu::Widget *widget = form->get_widget (property);
    g_return_if_fail (widget != 0);

#if 0
    std::set<Guikachu::Widget*> widget_set = form->get_widgets ();
    for (std::set<Guikachu::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	(*i)->selected (false);
    
    widget->selected (true);
#endif
    widget->request_edit ();
}

void WidgetCombo::entry_cb ()
{
    if (update_block)
	return;

    const std::string new_val = combo.get_entry ()->get_text ();
    if (property == new_val)
	return;
    
    op_factory->push_change (new_val);
    property = new_val;
}

void WidgetCombo::widget_changed_cb (Guikachu::Widget *widget)
{
    update_block = true;

    const std::set<Guikachu::Widget*> &widget_list = form->get_widgets ();
    std::list<std::string>             widget_id_list;

    widget_id_list.push_back ("");
    for (std::set<Guikachu::Widget*>::const_iterator i = widget_list.begin ();
	 i != widget_list.end (); ++i)
        if (types.find (widget->get_type ()) != types.end ())
	    widget_id_list.push_back ((*i)->id);
    
    combo.set_popdown_strings (widget_id_list);
    
    update_block = false;
}
