//$Id: target-combo.cc,v 1.10 2004/06/10 15:51:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widgets/target-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtkmm/menu.h>

#include "resource-manager.h"
#include "target.h"

using namespace Guikachu::GUI::PropertyEditors;

namespace Guikachu
{
    namespace TargetOps
    {
	class StockOp: public UndoOp
	{
	    Target      *target;
	    std::string  old_stock_id, new_stock_id;
	    int          old_width, old_height;

	public:
	    StockOp (Target            *target,
		     const std::string &new_stock_id);
	    
	    void undo ();
	    void redo ();
	    
	    Glib::ustring get_label () const { return _("Change target machine"); };
	};
    }
}
    
TargetCombo::TargetCombo (ResourceManager *manager_):
    PropertyEditor (this),
    manager (manager_),
    target (manager->get_target ())
{
    Gtk::Menu *target_menu = new Gtk::Menu;
    Target::stock_list_t targets = Target::stock_targets ();
    
    int current_index = 0;
    for (Target::stock_list_t::const_iterator i = targets.begin ();
	 i != targets.end (); ++i, ++current_index)
    {
	target_menu->items ().push_back (Gtk::Menu_Helpers::MenuElem (
	    i->second, bind (slot (*this, &TargetCombo::target_stock_cb), i->first)));
	
	stock_target_to_menuitem[i->first] = current_index;
    }
    
    target_menu->items ().push_back (Gtk::Menu_Helpers::MenuElem (
        _("Custom machine"), slot (*this, &TargetCombo::target_custom_cb)));
    num_targets = current_index;
    
    set_menu (*manage (target_menu));

    target->changed.connect (SigC::slot (*this, &TargetCombo::update));
    update ();
}

void TargetCombo::update ()
{
    Target::stock_id_t target_id = target->get_stock_id ();
    if (target_id != "")
	set_history (stock_target_to_menuitem[target_id]);
    else
	set_history (num_targets);
}

void TargetCombo::target_stock_cb (Target::stock_id_t stock_id)
{
    UndoOp *op = new TargetOps::StockOp (target, stock_id);
    target->load_stock (stock_id);
    manager->get_undo_manager ().push (op);
    
    stock_selected.emit ();
}

void TargetCombo::target_custom_cb ()
{
    custom_selected.emit ();
}

Guikachu::TargetOps::StockOp::StockOp (Target            *target_,
				       const std::string &new_stock_id_) :
    target (target_),
    old_stock_id (target->get_stock_id ()),
    new_stock_id (new_stock_id_),
    old_width (target->screen_width),
    old_height (target->screen_height)
{
}

void Guikachu::TargetOps::StockOp::undo ()
{
    if (old_stock_id != "")
	target->load_stock (old_stock_id);
    else {
	target->screen_width = old_width;
	target->screen_height = old_height;
    }
}

void Guikachu::TargetOps::StockOp::redo ()
{
    target->load_stock (new_stock_id);
}
