//$Id: resource-combo.cc,v 1.18 2004/06/10 15:51:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resource-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <vector>
#include "resource-manager.h"

#include "resource-factory.h"

using namespace Guikachu::GUI::PropertyEditors;

ResourceCombo::ResourceCombo (Resources::Type  type,
			      property_t      &property_,
			      op_factory_t    *op_factory_):
    Gtk::HBox (false, 5),
    manager (property_.get_manager ()),
    button_edit (_("Edit...")),
    property (property_),
    op_factory (op_factory_)
{
    types.insert (type);

    create_widgets ();
}

ResourceCombo::ResourceCombo (const std::set<Resources::Type> &types_,
			      property_t                      &property_,
			      op_factory_t                    *op_factory_):
    Gtk::HBox (false, 5),
    manager (property_.get_manager ()),
    button_edit (_("Edit...")),
    types (types_),
    property (property_),
    op_factory (op_factory_)
{
    create_widgets ();
}



void ResourceCombo::create_widgets ()
{
    combo.set_value_in_list (true, true);
    combo.set_use_arrows (true);
    combo.set_case_sensitive (false);
    combo.get_entry ()->set_editable (false);
    
    std::set<Resource*> resource_set = manager->get_resources ();

    std::list<std::string> empty_id_list;
    empty_id_list.push_back ("");
    combo.set_popdown_strings (empty_id_list);
    for (std::set<Resource*>::iterator i = resource_set.begin ();
	 i != resource_set.end (); i++)
	add_resource ((*i));

    button_edit.signal_clicked ().connect (slot (*this, &ResourceCombo::edit_cb));
    
    manager->resource_created.connect (slot (*this, &ResourceCombo::add_resource));
    manager->resource_removed.connect (slot (*this, &ResourceCombo::remove_resource));
    combo.get_entry ()->signal_changed ().connect (slot (*this, &ResourceCombo::entry_cb));
    
    pack_start (combo);
    pack_start (button_edit);
    underline_widget = &combo;
    
    property.changed.connect (slot (*this, &ResourceCombo::update));
    update ();
}

void ResourceCombo::add_resource (Resource *res)
{
    if (types.find (res->get_type ()) == types.end ())
	return;

    update_block = true;

    std::string current = property;

    std::list<std::string> resource_ids = combo.get_popdown_strings ();
    resource_ids.push_back (res->id);
    combo.set_popdown_strings (resource_ids);
    
    combo.get_entry ()->set_text (current);

    res->changed.connect (SigC::bind (
	SigC::slot (*this, &ResourceCombo::resource_changed_cb),
	res));
	
    update_block = false;
}

void ResourceCombo::remove_resource (Resource *res)
{
    if (types.find (res->get_type ()) == types.end ())
	return;
	
    update_block = true;

    // This sucks, but we have to rebuild the whole list because
    // there's no other API to change a combo's list

    std::set<Resource*> resource_list = manager->get_resources ();
    std::list<std::string> resource_id_list;
    resource_id_list.push_back ("");
    for (std::set<Resource*>::const_iterator i = resource_list.begin ();
	 i != resource_list.end (); ++i)
        if (types.find ((*i)->get_type ()) != types.end ())
	    resource_id_list.push_back ((*i)->id);
    
    combo.set_popdown_strings (resource_id_list);
    
    update_block = false;
}

void ResourceCombo::update ()
{
    update_block = true;

    combo.get_entry ()->set_text (property.get_val ());
    button_edit.set_sensitive (property != "");

    update_block = false;
}

void ResourceCombo::edit_cb ()
{
    Resource *res = property.resolve ();
    g_return_if_fail (res != 0);

    Guikachu::GUI::get_resource_editor (res)->show ();
}

void ResourceCombo::entry_cb ()
{
    if (update_block)
	return;
    
    const std::string new_val = combo.get_entry ()->get_text ();
    if (property == new_val)
	return;
    
    op_factory->push_change (new_val);
    property = new_val;
}

void ResourceCombo::resource_changed_cb (Resource *res)
{
    update_block = true;

    // This sucks, but we have to rebuild the whole list because
    // there's no other API to change a combo's list

    std::set<Resource*> resource_list = manager->get_resources ();
    std::list<std::string> resource_id_list;
    resource_id_list.push_back ("");
    for (std::set<Resource*>::const_iterator i = resource_list.begin ();
	 i != resource_list.end (); ++i)
        if (types.find ((*i)->get_type ()) != types.end ())
	    resource_id_list.push_back ((*i)->id);
    
    combo.set_popdown_strings (resource_id_list);    
    
    update_block = false;
}
