//$Id: storage.h,v 1.14 2004/06/10 15:51:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_STORAGE_H
#define GUIKACHU_STORAGE_H

#include <string>
#include <sigc++/signal.h>
#include <libgnomevfs/gnome-vfs.h>

#include "storage-node.h"

namespace Guikachu
{
    class Storage
    {
	xmlDocPtr doc;
	
    public:
	Storage ();
	Storage (xmlDocPtr doc);
	~Storage ();

	Storage (const Storage &other);
	Storage & operator= (const Storage &other);
	
	GnomeVFSResult load     (const Glib::ustring &filename);

	GnomeVFSResult load_uri (const Glib::ustring &uri);
	GnomeVFSResult save_uri (const Glib::ustring &uri) const;
	void           save_buffer (char *&buffer, GnomeVFSFileSize &buffer_size) const;
	
	StorageNode get_root    ();
	void        set_root    (StorageNode &root);
	StorageNode create_root (const std::string &name);

	SigC::Signal0<void> encoding_notify;
    };
    
}; // namespace Guikachu


#endif /* !GUIKACHU_STORAGE_H */
