//$Id: session.h,v 1.12 2004/06/10 15:51:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_SESSION_H
#define GUIKACHU_SESSION_H

#include <string>
#include <vector>
#include <libgnomemm/main.h>

#include <libgnomeuimm/client.h>

namespace Guikachu
{
    // Forward declarations
    class ResourceManager;
    
    namespace GUI
    {
	class MainWin;
    }
    
    class Main: public Gnome::Main
    {
	static Main *instance_;
	
	poptContext               ctx;
	std::string               cmd_self;
	std::vector<std::string>  cmd_arguments;
	Glib::ustring             last_filename;

	ResourceManager          *doc;
	GUI::MainWin             *mainwin;
	
    public:
	Main (int argc, char **argv);
	static inline Main *instance ()    { return instance_; };
	static inline bool  initialized () { return instance_ != 0; };
	~Main ();

        void load_doc (const Glib::ustring &filename, const std::string &mime_type);
	void save_doc (const Glib::ustring &filename);
	void new_doc  ();

    protected:
	void run_impl ();
	
    private:
	void set_doc      (ResourceManager   *doc);
        void set_filename (const Glib::ustring &filename, const std::string &mime_type);
	
	bool session_save_cb (int                      phase,
			      Gnome::UI::SaveStyle     save_style,
			      bool                     is_shutdown,
			      Gnome::UI::InteractStyle interact_style,
			      bool                     is_fast);
	void session_die_cb  ();
	
	void save_open_file ();
    };
}

#endif /* !GUIKACHU_SESSION_H */
