//$Id: resource-tree.h,v 1.7 2004/06/10 15:51:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_TREE_H
#define GUIKACHU_RESOURCE_TREE_H

namespace Guikachu
{
    namespace GUI
    {
	class ResourceTree;
    }
}

#include "resource.h"
#include "app-res.h"
#include "app-win.h"
#include "resource-manager.h"

#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/menu.h>

#include "hash-map.h"

namespace Guikachu
{
    namespace GUI
    {
	class ResourceTree: public Gtk::TreeView
	{
	    ResourceManager *manager;
	    
	    Gtk::TreeModelColumn<Glib::ustring> col_label;
	    Gtk::TreeModelColumn<Resource*>     col_res;
	    Glib::RefPtr<Gtk::TreeStore>        treestore;

	    typedef std::hash_map<Resources::Type, Gtk::TreeRow> subtree_map_t;

	    Gtk::TreeRow  root_tree;
	    subtree_map_t subtrees;

	    AppWindow *app_win;

            Gtk::Menu *popup_menu;
	    
	public:
	    ResourceTree ();
	    ~ResourceTree ();

	    void set_manager (ResourceManager *manager);

            Resource * get_selected ();

	private:
	    void create_tree_for_type (Resources::Type      type,
				       const Glib::ustring &category_name);

	    void row_activated_cb (const Gtk::TreeModel::Path &path,
				   Gtk::TreeView::Column      *col);

            void button_press_cb (GdkEventButton *e);
	    void key_press_cb    (GdkEventKey    *e);

            void popup_app_menu (guint button, guint32 time);
            void popup_res_menu (guint button, guint32 time, Resource *res);
		
	    void app_changed_cb ();

            void show_app_win ();
            void show_res_win (Resource *res);

            void app_reset_cb ();
            
            void res_cut_cb    (Resource *res);
            void res_copy_cb   (Resource *res);
            void res_remove_cb (Resource *res);
	    
	    void resource_created_cb (Resource *res);
	    void resource_removed_cb (Resource *res);
	    void resource_changed_cb (Gtk::TreeRow row);
	};
    }
}

#endif /* !GUIKACHU_RESOURCE_TREE_H */
