//$Id: gadget-prop.cc,v 1.13 2004/06/10 15:51:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gadget-prop.h"


#include "config.h"
#include <libgnome/libgnome.h>

#include "resizeable-prop.h"

#include "widgets/propertytable.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"

#include "property-ops-widget.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

GadgetProperties::GadgetProperties (Gadget *res):
    WidgetProperties (res)
{
    using namespace SigC;
    using WidgetOps::PropChangeOpFactory;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    add_general_controls (*proptable);

    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (
	res->usable,
	new PropChangeOpFactory<bool> (_("Toggle usable state of %s"), res, res->usable, false));
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    add_position_controls (*proptable);

    /* Size */
    ResizeableProperties::add_controls (res, *proptable);

    property_editor = proptable;
}

GadgetProperties::~GadgetProperties ()
{
    delete property_editor;
}

Gtk::Widget* GadgetProperties::get_editor ()
{
    return property_editor;
}
