//$Id: bitmap-res.h,v 1.9 2004/06/10 15:51:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2004 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_BITMAP_RES_H
#define GUIKACHU_BITMAP_RES_H

#include "resource.h"

#include <Magick++.h>

namespace Guikachu
{
    namespace Resources
    {
	class Bitmap: public Resource
	{
	public:
            enum BitmapType
            {
                TYPE_MONO,
                TYPE_GREY_4,
                TYPE_GREY_16,
                TYPE_COLOR_16,
                TYPE_COLOR_256,
		TYPE_COLOR_16K
            };
            
	    Bitmap (ResourceManager *manager, const std::string &id, serial_t serial);
            
	    Type get_type () const { return RESOURCE_BITMAP; };
	    void apply_visitor (ResourceVisitor &visitor) { visitor.visit_resource (this); };

	    Property<BitmapType>   bitmap_type;

            void load_file     (const std::string &uri);
	    void save_file_bmp (const std::string &uri) const;
            void set_image     (const Magick::Blob &blob);
            void set_image     (const Magick::Image &image);

            Magick::Image get_image () const { return image; };
            
        private:
            Magick::Image image;
	};
    }
}

#endif /* !GUIKACHU_BITMAP_RES_H */
