dnl **********************
dnl GUIKACHU_DEPS_GUIKACHU
dnl
dnl Check backend and GUI dependancy libraries for Guikachu
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_GUIKACHU],[
dnl Packages using pkg-config
PKG_CHECK_MODULES(GUIKACHU_GUI_DEPS, libgnomeuimm-2.0)
PKG_CHECK_MODULES(GUIKACHU_DEPS, glibmm-2.0 gnome-vfs-2.0 libxml-2.0)
LIBGNOME_DATADIR=`"$PKG_CONFIG" --variable=prefix libgnome-2.0`/share

dnl ImageMagick++
AC_PATH_PROG(MAGICKPP_CONFIG,Magick++-config,no)
AC_MSG_CHECKING(for ImageMagick++)
magickpp_ok=no

if test "$MAGICKPP_CONFIG" != no
then
	MAGICKPP_CFLAGS="`$MAGICKPP_CONFIG --cppflags` `$MAGICKPP_CONFIG --cxxflags`"
	MAGICKPP_LIBS="`$MAGICKPP_CONFIG --libs` `$MAGICKPP_CONFIG --ldflags`"
	magickpp_ok=yes
fi

if test "$magickpp_ok" = "no"
then
	AC_MSG_ERROR(Magick++, the C++ API of the ImageMagick library was not found.)
fi
AC_MSG_RESULT(found)

dnl Merge flags
GUIKACHU_GUI_DEPS_CFLAGS="$GUIKACHU_GUI_DEPS_CFLAGS $MAGICKPP_CFLAGS"
GUIKACHU_DEPS_CFLAGS="$GUIKACHU_DEPS_CFLAGS $MAGICKPP_CFLAGS"

GUIKACHU_GUI_DEPS_LIBS="$GUIKACHU_GUI_DEPS_LIBS $MAGICKPP_LIBS"
GUIKACHU_DEPS_LIBS="$GUIKACHU_DEPS_LIBS $MAGICKPP_LIBS"

dnl Export variables to Automake
AC_SUBST(GUIKACHU_DEPS_CFLAGS)
AC_SUBST(GUIKACHU_DEPS_LIBS)
AC_SUBST(GUIKACHU_GUI_DEPS_CFLAGS)
AC_SUBST(GUIKACHU_GUI_DEPS_LIBS)
AC_SUBST(LIBGNOME_DATADIR)
])


dnl **********************
dnl GUIKACHU_DEPS_FOOCANVAS
dnl
dnl Check dependancy libraries for FooCanvas
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_FOOCANVAS],[
PKG_CHECK_MODULES(FOOCANVAS_DEPS, gtk+-2.0 pango)
AC_SUBST(FOOCANVAS_DEPS_CFLAGS)
AC_SUBST(FOOCANVAS_DEPS_LIBS)

AC_PATH_PROG(GLIB_GENMARSHAL, glib-genmarshal)
])


dnl **********************
dnl GUIKACHU_DEPS_FOOCANVAS
dnl
dnl Check dependancy libraries for FooCanvasmm
dnl **********************
dnl
AC_DEFUN([GUIKACHU_DEPS_FOOCANVASMM],[
PKG_CHECK_MODULES(FOOCANVASMM_DEPS, gtkmm-2.0)
AC_SUBST(FOOCANVASMM_DEPS_CFLAGS)
AC_SUBST(FOOCANVASMM_DEPS_LIBS)

GTKMM_PREFIX=`$PKG_CONFIG --variable=prefix gtkmm-2.0`
GTKMM_PROCDIR=$GTKMM_PREFIX/lib/gtkmm-2.0/proc
AC_SUBST(GTKMM_PROCDIR)
GTKMM_PROC=$GTKMM_PROCDIR/gtkmmproc
AC_SUBST(GTKMM_PROC)
])
