//$Id: widget-canvas.cc,v 1.16 2004/03/23 22:29:24 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-canvas.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/main.h>
#include <gnome--/canvas-rect.h>

#include <list>
#include <algorithm>
#include <math.h>

#include <sigc++/retbind.h>

#include "preferences.h"

#include "form-editor-canvas.h"

using namespace Guikachu::GUI::FormEditor;

WidgetCanvasItem::WidgetCanvasItem (Widget             *widget_,
				    Gnome::CanvasGroup *parent_group_):
    CanvasItem (widget_, parent_group_),
    widget (widget_),
    selected (false),
    selection_box (0)
{
    // Chain signal callbacks
    canvas_item_changed.connect (SigC::slot (this, &WidgetCanvasItem::canvas_item_changed_cb));

    widget->changed.connect  (SigC::slot (this, &WidgetCanvasItem::update_hook));
    widget->selected.connect (SigC::slot (this, &WidgetCanvasItem::widget_selected_cb));
}

WidgetCanvasItem::~WidgetCanvasItem ()
{
    if (selection_box)
	delete selection_box;
}

void WidgetCanvasItem::update_hook ()
{
    update ();
}

void WidgetCanvasItem::canvas_item_changed_cb ()
{
    item->event.connect (SigC::retbind (
	SigC::slot (this, &WidgetCanvasItem::canvas_event_cb), 0));
    widget_selected_cb (selected);
}

void WidgetCanvasItem::canvas_event_cb (GdkEvent *e)
{
    // Context menu
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 3))
    {
	context_menu.emit (e->button.button, e->button.time);
    }
}

Gnome::CanvasItem * WidgetCanvasItem::create_selection_box ()
{
    int x1, y1, x2, y2;
    get_bounds (x1, y1, x2, y2);

    gdouble box_size = 1.5 / overlay_group->get_canvas ()->get_pixels_per_unit ();
    
    gdouble box_x1 = x1 - 0.5 - box_size;
    gdouble box_x2 = x2 + 0.5 + box_size;
    gdouble box_y1 = y1 - 0.5 - box_size;
    gdouble box_y2 = y2 + 0.5 + box_size;

    using namespace Gnome::CanvasHelpers;
    Gnome::CanvasRect *bounding_box = new Gnome::CanvasRect (
	*overlay_group, box_x1, box_y1, box_x2, box_y2);
    *bounding_box
	<< width_pixels (2)
	<< outline_color (get_selection_color ());

    return bounding_box;
}

void WidgetCanvasItem::widget_selected_cb (bool selected_)
{
    selected = selected_;
    
    if (!selected)
    {
	if (selection_box)
	{
	    delete selection_box;
	    selection_box = 0;
	}
	return;
    }

    delete selection_box;
    selection_box = create_selection_box ();
    selection_box->lower_to_bottom ();
    
    item_group->raise_to_top ();
}

std::string WidgetCanvasItem::get_foreground_color (bool enabled) const
{
    if (widget->get_manager ()->get_target ()->screen_color)
        return enabled ? "#000000" : "#757575";
    else
        return enabled ? Preferences::FormEditor::get_color_fg () :
            Preferences::FormEditor::get_color_disabled ();
}

std::string WidgetCanvasItem::get_background_color () const
{
    if (widget->get_manager ()->get_target ()->screen_color)
        return "#ffffff";
    else
        return Preferences::FormEditor::get_color_bg ();
}

std::string WidgetCanvasItem::get_selection_color () const
{
    if (widget->get_manager ()->get_target ()->screen_color)
	return "#ec00a8";
    else
	return Preferences::FormEditor::get_color_selection ();
}
