//$Id: button-prop.cc,v 1.27 2004/01/18 10:55:36 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/num-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"
#include "widgets/resource-combo.h"
#include <gtk--/menu.h>

#include "auto-resizeable-prop.h"
#include "textual-prop.h"
#include "graphical-prop.h"

#include "property-ops-widget.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ButtonProperties::ButtonProperties (Button *res_):
    WidgetProperties (res_),
    res (res_),
    update_block (false)
{
    using namespace SigC;
    using WidgetOps::PropChangeOpFactory;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;

    /* Resource ID */
    add_general_controls (*proptable);

    /* Label */
    TextualProperties::add_controls (res, *proptable);
    
    /* Bitmaps */
    GraphicalProperties::add_controls (res, *proptable);
    
    /* Frame type */
    frame_combo = new Gtk::OptionMenu;
    /* Fill the frame type dropdown list */
    Gtk::Menu *frame_menu = new Gtk::Menu;

#define FRAME_TYPE(s,t) 						 \
	    frame_menu->items ().push_back (				 \
		Gtk::Menu_Helpers::MenuElem (				 \
		    s,							 \
		    bind (slot (this, &ButtonProperties::frame_menu_cb), \
			  Widgets::Button::t)));

    FRAME_TYPE (_("None"),   FRAME_NONE);
    FRAME_TYPE (_("Simple"), FRAME_SIMPLE);
    FRAME_TYPE (_("Bold"),   FRAME_BOLD);
    
#undef FRAME_TYPE

    frame_menu->show_all ();
    frame_combo->set_menu (*manage (frame_menu));
    proptable->add (_("_Frame type:"), *manage (frame_combo));
    
    /* Repeat */
    control = new GUI::PropertyEditors::ToggleButton (
	res->repeat,
	new PropChangeOpFactory<bool> (_("Toggle repeating of %s"), res, res->repeat, false));
    proptable->add (_("_Repeating:"), *manage (control),
		    _("Repeating buttons fire multiple ButtonPress "
		      "signals when kept pressed"));

    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (
	res->usable,
	new PropChangeOpFactory<bool> (_("Toggle usable state of %s"), res, res->usable, false));
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Anchor right */
    control = new GUI::PropertyEditors::ToggleButton (
	res->anchor_right,
	new PropChangeOpFactory<bool> (_("Change alignment of %s"), res, res->anchor_right, false));
    proptable->add (_("_Anchor right:"), *manage (control),
		    _("Keep right aligned when changing label "
		      "text at run-time"));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    add_position_controls (*proptable);
    
    /* Size */
    AutoWidthProperties::add_controls  (res, *proptable);
    AutoHeightProperties::add_controls (res, *proptable);
    
    proptable->show ();
    property_editor = proptable;

    res->changed.connect (slot (this, &ButtonProperties::update));
    update ();
}

ButtonProperties::~ButtonProperties ()
{
    delete property_editor;
}

void ButtonProperties::update ()
{
    update_block = true;
    
    frame_combo->set_history (res->frame);

    update_block = false;
}

Gtk::Widget* ButtonProperties::get_editor ()
{
    return property_editor;
}

void ButtonProperties::frame_menu_cb (Widgets::Button::FrameType frame_type)
{
    if (res->frame == frame_type)
	return;
    
    char *label_str = g_strdup_printf (_("Change frame of %s"), res->id ().c_str ());
    
    UndoOp *op = new WidgetOps::PropChangeOp<Widgets::Button::FrameType> (
	label_str, res, res->frame, frame_type, false);
    g_free (label_str);    

    res->frame = frame_type;
    
    res->get_manager ()->get_undo_manager ().push (op);
}
