//$Id: io.cc,v 1.3 2004/01/26 22:08:38 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "io/io.h"

using namespace Guikachu;

std::string IO::create_canonical_uri (const std::string &filename)
{
    if (filename == "")
	return "";

    if (filename.find ("://") < filename.find ("/"))
	// Don't touch URI's
	return filename;
    
    std::string full_filename;
    if (g_path_is_absolute (filename.c_str ()))
	full_filename = filename;
    else {
	char *current_dirname = g_get_current_dir ();
	full_filename = std::string (current_dirname) + "/" + filename;
	g_free (current_dirname);
    }
    
    char *uri_tmp = gnome_vfs_make_uri_canonical (full_filename.c_str ());
    std::string uri = uri_tmp;
    g_free (uri_tmp);
    
    return uri;
}

IO::IOResult IO::load_uri (const std::string &uri, char *&data, GnomeVFSFileSize &len)
{
    GnomeVFSHandle *vfs_handle = 0;
    GnomeVFSResult  res = gnome_vfs_open (&vfs_handle, uri.c_str (), GNOME_VFS_OPEN_READ);
    
    if (res != GNOME_VFS_OK)
	return res;
        
    GnomeVFSFileInfo *vfs_info = gnome_vfs_file_info_new ();
    res = gnome_vfs_get_file_info_from_handle (
	vfs_handle, vfs_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
        
    if (res != GNOME_VFS_OK)
    {
	gnome_vfs_file_info_unref (vfs_info);
	gnome_vfs_close (vfs_handle);
	return res;
    }
        
    data = new char[vfs_info->size];
    len = 0;        
    char             buffer[10240];
    GnomeVFSFileSize bytes_read;
    
    gnome_vfs_file_info_unref (vfs_info);
    
    while (res == GNOME_VFS_OK)
    {
	res = gnome_vfs_read (vfs_handle, buffer, sizeof buffer - 1, &bytes_read);
	
	if(!bytes_read)
	    break;

	memcpy(data + len, buffer, bytes_read);
	len += bytes_read;
    }
    gnome_vfs_close (vfs_handle);
    
    return GNOME_VFS_OK;
}

IO::IOResult IO::save_uri (const std::string &uri, const char *data, GnomeVFSFileSize len)
{
    // Create file
    GnomeVFSHandle *vfs_handle = 0;
    GnomeVFSResult res = gnome_vfs_create (
	&vfs_handle, uri.c_str (), GNOME_VFS_OPEN_WRITE, 0, 0644);
    if (res != GNOME_VFS_OK)
	return res;
	
    // Write data to VFS stream
    const GnomeVFSFileSize chunk_size = len;
    
    for (GnomeVFSFileSize bytes_written = 0; len; data += bytes_written)
    {
        res = gnome_vfs_write (vfs_handle, data, std::min (chunk_size, len), &bytes_written);
        len -= bytes_written;
        
        if (res != GNOME_VFS_OK)
            break;
    }
    
    if (vfs_handle)
        gnome_vfs_close (vfs_handle);

    return res;
}
