//$Id: canvas-grip.cc,v 1.3 2003/06/30 14:07:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "canvas-grip.h"

#include <sigc++/retbind.h>
#include <math.h>

using namespace Guikachu::GUI::FormEditor;

CanvasGrip::CanvasGrip (Gnome::CanvasGroup &parent_group,
			int                 x,
			int                 y):
    Gnome::CanvasRect (parent_group)
{   
    set_width_pixels (2);
    set_outline_color ("black");
    set_fill_color ("white");
    
    set_position (x, y);
    
    drag_context.dragging = false;
    
    event.connect (SigC::retbind (SigC::slot (this, &CanvasGrip::canvas_event_cb), 1));
}

void CanvasGrip::set_position (int x, int y)
{
    set_x1 (x - 3);
    set_x2 (x + 3);

    set_y1 (y - 3);
    set_y2 (y + 3);
}

void CanvasGrip::canvas_event_cb (GdkEvent *e)
{
    // Begin drag
    if (e->type == GDK_BUTTON_PRESS &&
        e->button.button == 1 &&
        !drag_context.dragging)
        drag_begin_impl (e);
    
    // Dragging
    if (e->type == GDK_MOTION_NOTIFY &&
        drag_context.dragging)
        drag_motion_impl (e);

    // Ending drag
    if (e->type == GDK_BUTTON_RELEASE &&
        e->button.button == 1 &&
        drag_context.dragging)
        drag_end_impl (e);
}

void CanvasGrip::drag_begin_impl (GdkEvent *e)
{
    double x = e->button.x;
    double y = e->button.y;

    drag_context.last_x = x;
    drag_context.last_y = y;

    drag_context.delta_remainder_x = 0;
    drag_context.delta_remainder_y = 0;
    
    grab (GDK_POINTER_MOTION_MASK | GDK_BUTTON_MOTION_MASK |
	  GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_PRESS_MASK,
	  0, e->button.time);

    drag_context.dragging = true;

    drag_begin.emit ();
}

void CanvasGrip::drag_motion_impl (GdkEvent *e)
{
    double x = e->motion.x;
    double y = e->motion.y;
    
    double dx = x - drag_context.last_x + drag_context.delta_remainder_x;
    double dy = y - drag_context.last_y + drag_context.delta_remainder_y;
    
    // Store fractions of one pixel
    drag_context.delta_remainder_x = fmod (dx, 1.0);
    drag_context.delta_remainder_y = fmod (dy, 1.0);
    
    // Emit motion signal
    drag_motion.emit (int (dx), int (dy));
    
    drag_context.last_x = x;
    drag_context.last_y = y;
}

void CanvasGrip::drag_end_impl (GdkEvent *e)
{
    ungrab (e->button.time);

    drag_context.dragging = false;

    drag_end.emit ();
}
