//$Id: widget-combo.cc,v 1.14 2003/12/19 11:29:27 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu::GUI::PropertyEditors;

WidgetCombo::WidgetCombo (Resources::Form *form_,
			  Widgets::Type    type,
			  property_t      &property_,
			  op_factory_t    *op_factory_):
    Gtk::HBox (false, 5),
    form (form_),
    button_edit (_("Edit...")),
    property (property_),
    op_factory (op_factory_)
{
    types.insert (type);
    
    create_widgets ();
}

WidgetCombo::WidgetCombo (Resources::Form               *form_,
			  const std::set<Widgets::Type> &types_,
			  property_t                    &property_,
			  op_factory_t                  *op_factory_):
    Gtk::HBox (false, 5),
    form (form_),
    button_edit (_("Edit...")),
    types (types_),
    property (property_),
    op_factory (op_factory_)
{
    create_widgets ();
}

void WidgetCombo::create_widgets ()
{
    combo.set_value_in_list (true, true);
    combo.set_use_arrows (true);
    combo.set_case_sensitive (false);
    combo.get_entry ()->set_editable (false);
    
    std::set<Guikachu::Widget*> widget_set = form->get_widgets ();

    Gtk::ListItem *item = new Gtk::ListItem ("");
    item->set_user_data (0);
    item->show ();
    combo.get_list ()->add (*manage (item));
    for (std::set<Guikachu::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	add_widget ((*i));

    button_edit.clicked.connect (slot (this, &WidgetCombo::edit_cb));

    form->widget_created.connect (slot (this, &WidgetCombo::add_widget));
    form->widget_removed.connect (slot (this, &WidgetCombo::remove_widget));

    combo.get_entry ()->changed.connect (slot (this, &WidgetCombo::entry_cb));
    
    pack_start (combo);
    pack_start (button_edit);

    property.changed.connect (slot (this, &WidgetCombo::update));
    update ();
}

void WidgetCombo::add_widget (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
	return;
    
    update_block = true;

    Gtk::ListItem *item = new Gtk::ListItem (widget->id ());
    item->set_user_data (widget);
    item->show ();
    combo.get_list ()->add (*manage (item));

    widget->changed.connect (bind (slot (this, &WidgetCombo::widget_changed_cb),
				   widget));
    
    update_block = false;
}

void WidgetCombo::remove_widget (Guikachu::Widget *widget)
{
    if (types.find (widget->get_type ()) == types.end ())
	return;
    
    update_block = true;
    
    Gtk::List::ItemList listitems = combo.get_list ()->items ();
    for (Gtk::List::ItemList::iterator i = listitems.begin ();
         i != listitems.end (); i++)
    {
        if ((*i)->get_user_data () == widget)
            i = listitems.erase (i);
    }
    
    update_block = false;
}

void WidgetCombo::update ()
{
    update_block = true;
    
    combo.get_entry ()->set_text (property);
    button_edit.set_sensitive (property != "");
    
    update_block = false;
}

void WidgetCombo::edit_cb ()
{
    Guikachu::Widget *widget = form->get_widget (property);
    g_return_if_fail (widget != 0);
    
    std::set<Guikachu::Widget*> widget_set = form->get_widgets ();
    for (std::set<Guikachu::Widget*>::iterator i = widget_set.begin ();
	 i != widget_set.end (); i++)
	(*i)->selected (false);
    
    widget->selected (true);
    widget->request_edit ();
}

void WidgetCombo::entry_cb ()
{
    if (update_block)
	return;

    const std::string new_val = combo.get_entry ()->get_text ();
    if (property == new_val)
	return;
    
    op_factory->push_change (new_val);
    property = new_val;
}

void WidgetCombo::widget_changed_cb (Guikachu::Widget *widget)
{
    update_block = true;

    Gtk::List::ItemList& itemlist = combo.get_list ()->items ();
    Gtk::List::ItemList::iterator i = itemlist.begin ();
    while (i != itemlist.end () && (*i)->get_user_data () != widget)
	i++;
    g_return_if_fail (i != itemlist.end ());
    
    (*i)->remove ();
    (*i)->add_label (widget->id);
    
    update_block = false;
}

void WidgetCombo::install_underline (Gtk::AccelGroup &accel_group,
				     guint            accel_key)
{
    combo.get_button ()->add_accelerator ("clicked",
					  accel_group, accel_key,
					  GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
}
