//$Id: ui-gui.cc,v 1.2 2003/06/30 14:07:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "ui.h"
#include "session.h"

#include <gnome--/dialog.h>
#include <gnome--/about.h>
#include <gtk--/main.h>

#include <list>
#include <iostream>

using namespace Guikachu;

void UI::flush_events ()
{
    if (Guikachu::Main::initialized ())
	while (Gtk::Main::events_pending ())
	    Gtk::Main::iteration ();
}

void UI::show_about ()
{
    std::list<std::string> authors;
    authors.push_back ("Gerg rdi");
    authors.push_back ("Jay Bloodworth");
    authors.push_back ("Christopher Keith Fairbairn");
    
    Gnome::About *about = new Gnome::About ("Guikachu", VERSION,
					    "(C) 2001-2003 Gerg rdi",
					    authors,
					    _("PalmOS resource file editor"));
    about->run ();  
}

void UI::show_error (const std::string &full_message,
		     const std::string &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gnome::Dialog *dialog = Gnome::Dialogs::error (full_message);
	dialog->run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Error: ") << short_message << std::endl;
    }
}

void UI::show_warning (const std::string &full_message,
		       const std::string &short_message)
{
    if (Guikachu::Main::initialized ())
    {
	Gnome::Dialog *dialog = Gnome::Dialogs::warning (full_message);
	dialog->run ();
    } else {
	if (short_message != "")
	    std::cerr << _("Guikachu: Warning: ") << short_message << std::endl;
    }
}
