//$Id: resource-tree.cc,v 1.6 2003/12/15 17:35:38 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "resource-tree.h"

#include "treeitem.h"
#include "top-treeitem.h"

using namespace Guikachu;

GUI::ResourceTree::ResourceTree ():
    manager (0),
    top_item (0)
{
    set_selection_mode (GTK_SELECTION_BROWSE);
}

void GUI::ResourceTree::set_manager (ResourceManager *manager_)
{
    manager = manager_;

    // Top treeitem
    tree ().clear ();
    top_item = new TopTreeItem (manager->get_application ());    
    top_item->show ();
    tree ().push_back (*manage (top_item));

    // Create the tree for the resources
    main_tree = new Gtk::Tree ();
    top_item->set_subtree (*manage (main_tree));
    top_item->expand ();

    // Create subtrees
    subtrees.clear ();
    create_tree_for_type (Resources::RESOURCE_DIALOG,     _("Dialogs"));
    create_tree_for_type (Resources::RESOURCE_FORM,       _("Forms"));
    create_tree_for_type (Resources::RESOURCE_MENU,       _("Menus"));
    create_tree_for_type (Resources::RESOURCE_STRING,     _("Strings"));
    create_tree_for_type (Resources::RESOURCE_STRINGLIST, _("String lists"));
    create_tree_for_type (Resources::RESOURCE_BITMAP,     _("Bitmaps"));
    create_tree_for_type (Resources::RESOURCE_BLOB,       _("Blobs"));

    /* Fill with existing resources */
    std::set<Resource*> resources = manager->get_resources ();
    for (std::set<Resource*>::iterator i = resources.begin ();
	 i != resources.end (); i++)
	resource_created_cb ((*i));

    /* Connect to Resource Manager signals */
    manager->resource_created.connect (slot (this, &ResourceTree::resource_created_cb));
    manager->resource_removed.connect (slot (this, &ResourceTree::resource_removed_cb));
}

Resource * GUI::ResourceTree::get_selected () const
{
    const Gtk::Tree::SelectionList &selection_list = selection ();

    if (!selection_list.size ())
	return 0;

    Gtk::TreeItem *selected_item = *(selection_list.begin ());
    if (GUI::TreeItem *item = dynamic_cast<GUI::TreeItem*> (selected_item))
	return item->get_resource ();

    return 0;
}

void GUI::ResourceTree::resource_created_cb (Resource *resource)
{
    TreeItem *item = new GUI::TreeItem (resource);
    item->set_user_data (resource);
    item->show ();

    Gtk::TreeItem *subtree_item = subtrees[resource->get_type ()];
    
    if (!subtree_item->get_subtree ())
    {
	subtree_item->set_subtree (*manage (new Gtk::Tree));
	subtree_item->expand ();
    }
    
    subtree_item->get_subtree ()->tree ().push_back (*manage (item));
    treeitems.insert (treeitem_map::value_type (resource, item));
}

void GUI::ResourceTree::resource_removed_cb (Resource *resource)
{
    treeitem_map::iterator treeitem_entry = treeitems.find (resource);

    g_assert (treeitem_entry != treeitems.end ());
    
    Gtk::TreeItem *subtree_item = subtrees[resource->get_type ()];
    Gtk::TreeItem *resource_item = treeitem_entry->second;
    
    subtree_item->get_subtree ()->tree ().remove (resource_item);

    treeitems.erase (treeitem_entry);
}

void GUI::ResourceTree::create_tree_for_type (Resources::Type    type,
					      const std::string &category_name)
{
    Gtk::TreeItem *subtree_item = new Gtk::TreeItem (category_name);
    subtrees[type] = subtree_item;

    subtree_item->show ();
    main_tree->tree ().push_back (*manage (subtree_item));
}
