//$Id: formbitmap-canvas.cc,v 1.6 2003/12/25 16:07:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "formbitmap-canvas.h"

#include "form-editor.h"
#include "form-editor-canvas.h"

#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

FormBitmapCanvasItem::FormBitmapCanvasItem (Widgets::FormBitmap *widget_,
                                            Gnome::CanvasGroup  *parent_group):
    CanvasItem (widget_, parent_group),
    WidgetCanvasItem (widget_, parent_group),
    widget (widget_),
    group (0)
{
    // TODO: watch the changes of the associated Bitmap resource, and
    // call update() when appropriate
    
    update ();
}

void FormBitmapCanvasItem::update_placeholder ()
{
    group = new Gnome::CanvasGroup (*draw_group, 0, 0);    

    int x = widget->x;
    int y = widget->y;
    
    static const char stipple_bits[] = {
        0x04, 0x02, 0x01, };
    
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
                                                      stipple_bits,
                                                      3, 3);
    
    using namespace Gnome::CanvasHelpers;
    *(draw_rectangle (*group, x, y, x + widget->get_width (), y + widget->get_height ()))
        << fill_stipple (stipple)
        << fill_color (get_foreground_color (widget->usable));    
    
    gdk_bitmap_unref (stipple);
    
    set_canvas_item (group);
    return;
}

void FormBitmapCanvasItem::update ()
{
    if (group)
	delete group;
    
    Resource *bitmap_res = widget->bitmap_id.resolve ();
    Resources::Bitmap *bitmap = dynamic_cast<Resources::Bitmap*> (bitmap_res);

    if (!bitmap) // Create placeholder
    {
        update_placeholder ();
        return;
    }

    // Don't display color bitmaps in greyscale preview
    Resources::Bitmap::BitmapType bitmap_type = bitmap->bitmap_type;
    if (!widget->get_manager ()->get_target ()->screen_color)
        bitmap_type = std::min (bitmap_type, Resources::Bitmap::TYPE_GREY_16);
    
    GdkPixbuf *pixbuf = render_bitmap (bitmap_type, bitmap->get_image ());

    if (!pixbuf)
    {
        update_placeholder ();
        return;
    }
    
    group = new Gnome::CanvasGroup (*draw_group, 0, 0);    

    int x = widget->x;
    int y = widget->y;

    // Create clickable background
    using namespace Gnome::CanvasHelpers;
    *(FormEditor::draw_rectangle (*group, x, y,
				  x + gdk_pixbuf_get_width (pixbuf), y + gdk_pixbuf_get_height (pixbuf)))
        << fill_color (get_background_color ());
    
    gnome_canvas_item_new (group->gtkobj (),
                           gnome_canvas_pixbuf_get_type (),
                           "pixbuf", pixbuf,
                           "x", double(x),
                           "y", double(y),
                           0);
    
    gdk_pixbuf_unref (pixbuf);

    set_canvas_item (group);
}
