//$Id: bitmap-res.cc,v 1.4 2003/12/24 14:14:04 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "bitmap-res.h"

#include <Magick++.h>
#include <libgnomevfs/gnome-vfs.h>

using namespace Guikachu;

Resources::Bitmap::Bitmap (ResourceManager   *manager,
			   const std::string &id,
			   serial_t           serial):
    Resource (manager, id, serial),
    bitmap_type (changed, TYPE_GREY_16)
{
}

namespace {
    
    void load_uri (const std::string &uri, char *&data, size_t &len)
    {
        GnomeVFSHandle *vfs_handle = 0;
        GnomeVFSResult  res = gnome_vfs_open (&vfs_handle, uri.c_str (), GNOME_VFS_OPEN_READ);
        
        if (res != GNOME_VFS_OK)
            return;
        
        GnomeVFSFileInfo *vfs_info = gnome_vfs_file_info_new ();
        res = gnome_vfs_get_file_info_from_handle (vfs_handle, vfs_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
        
        if (res != GNOME_VFS_OK)
        {
            gnome_vfs_file_info_unref (vfs_info);
            gnome_vfs_close (vfs_handle);
            return;
        }
        
        data = new char[vfs_info->size];
        len = 0;        
        char             buffer[1024];
        GnomeVFSFileSize bytes_read;
        
        gnome_vfs_file_info_unref (vfs_info);
        
        while (res == GNOME_VFS_OK)
        {
            res = gnome_vfs_read (vfs_handle, buffer, sizeof buffer - 1, &bytes_read);
            
            if(!bytes_read)
                break;

            memcpy(data + len, buffer, bytes_read);
            len += bytes_read;
        }
    }
    
} // Anonymous namespace
 
void Resources::Bitmap::load_file (const std::string &uri)
{
    char *data;
    size_t len;

    load_uri (uri, data, len);

    Magick::Blob blob;
    blob.updateNoCopy (data, len);
    
    set_image (blob);
}

void Resources::Bitmap::set_image (const Magick::Blob &blob)
{
    image.read (blob);

    changed.emit ();
}
